/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.api.recipe.RecipeType;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class RadiationHatchPartMachine
extends MultiblockPartMachine
implements IMachineLife,
IRecipeCapabilityHolder {
    @Persisted
    private final NotifiableItemStackHandler inventory = new NotifiableItemStackHandler((MetaMachine)this, 1, IO.IN, IO.BOTH);
    @Persisted
    private int radioactivity;
    @Persisted
    private int initialRadioactivity;
    @Persisted
    private int count;
    @Persisted
    private int time;
    @Persisted
    private int inhibitionDose;
    @Persisted
    private int initialTime;
    private final Map<IO, List<RecipeHandlerList>> capabilitiesProxy = new EnumMap<IO, List<RecipeHandlerList>>(IO.class);
    private final Map<IO, Map<RecipeCapability<?>, List<IRecipeHandler<?>>>> capabilitiesFlat = new EnumMap(IO.class);
    private TickableSubscription radiationSubs;
    private final RecipeHandlerList currentHandlerList = RecipeHandlerList.of((IO)IO.IN, (IRecipeHandler[])new IRecipeHandler[]{this.inventory});

    public RadiationHatchPartMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.addHandlerList(this.currentHandlerList);
    }

    public void onLoad() {
        super.onLoad();
        this.radiationSubs = this.subscribeServerTick(this.radiationSubs, this::checkRadiation);
    }

    public void onUnload() {
        super.onUnload();
        if (this.radiationSubs != null) {
            this.radiationSubs.unsubscribe();
            this.radiationSubs = null;
        }
    }

    private void checkRadiation() {
        if (this.time > 0) {
            if (this.count < 1) {
                this.radioactivity = this.initialRadioactivity * (this.initialTime + this.time) / (this.initialTime << 1);
            }
            --this.time;
        } else if (this.getOffsetTimer() % 20 == 0) {
            this.radioactivity = 0;
            GTRecipeType[] recipeTypes = this.getDefinition().getRecipeTypes();
            if (recipeTypes != null) {
                RecipeType recipeType = (RecipeType)recipeTypes[0];
                recipeType.findRecipe((IRecipeCapabilityHolder)this, r -> {
                    Recipe recipe = (Recipe)r;
                    if (recipe != null && RecipeRunner.handleRecipeIO((IRecipeCapabilityHolder)this, (Recipe)recipe, (IO)IO.IN, Collections.emptyMap())) {
                        this.count = this.inventory.storage.getStackInSlot(0).m_41613_();
                        this.initialRadioactivity = (int)((double)(recipe.data.m_128451_("radioactivity") - this.inhibitionDose) * (1.0 + (double)this.count / 64.0));
                        this.time = this.initialTime = recipe.duration * (this.inhibitionDose + 200) / 200;
                        this.radioactivity = this.initialRadioactivity;
                        return true;
                    }
                    return false;
                });
            }
        }
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 190, 125);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 182, 117).setBackground((IGuiTexture)GuiTextures.DISPLAY).addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_())).addWidget((Widget)new ComponentPanelWidget(4, 17, this::addDisplayText).setMaxWidthLimit(150).clickHandler(this::handleDisplayClick)));
        Size size = group.getSize();
        group.addWidget(new SlotWidget((IItemHandlerModifiable)this.inventory.storage, 0, size.width - 30, size.height - 30, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT}));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    private void addDisplayText(List<Component> textList) {
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.radiation_hatch.inhibition_dose", (Object[])new Object[]{this.inhibitionDose}).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [-]"), (String)"Sub")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [+]"), (String)"Add")));
        textList.add((Component)Component.m_237110_((String)"gtocore.recipe.radioactivity", (Object[])new Object[]{this.radioactivity}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.radiation_hatch.time", (Object[])new Object[]{this.time, this.initialTime}));
    }

    private void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote) {
            int amount = clickData.isCtrlClick ? 40 : (clickData.isShiftClick ? 8 : 1);
            this.inhibitionDose = Mth.m_14045_((int)(this.inhibitionDose + ("Add".equals(componentData) ? amount : -amount)), (int)0, (int)40);
        }
    }

    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.inventory.storage);
    }

    public boolean canShared() {
        return false;
    }

    @Nullable
    public RecipeHandlerList getCurrentHandlerList() {
        return this.currentHandlerList;
    }

    public Map<IO, List<RecipeHandlerList>> getCapabilitiesProxy() {
        return this.capabilitiesProxy;
    }

    public Map<IO, Map<RecipeCapability<?>, List<IRecipeHandler<?>>>> getCapabilitiesFlat() {
        return this.capabilitiesFlat;
    }

    @Generated
    public int getRadioactivity() {
        return this.radioactivity;
    }
}

