/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.noenergy;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.data.GTOMaterials;
import com.gtolib.api.capability.IExtendWirelessEnergyContainerHolder;
import com.gtolib.api.machine.multiblock.NoEnergyMultiblockMachine;
import com.gtolib.api.recipe.IdleReason;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.wireless.ExtendWirelessEnergyContainer;
import com.hepdd.gtmthings.api.misc.WirelessEnergyContainer;
import com.hepdd.gtmthings.utils.TeamUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class HarmonyMachine
extends NoEnergyMultiblockMachine
implements IExtendWirelessEnergyContainerHolder {
    private static final BigInteger BASE = BigInteger.valueOf(5277655810867200L);
    private static final long FLUID_BASE = 1024000000L;
    private static final Fluid HYDROGEN = GTMaterials.Hydrogen.getFluid();
    private static final Fluid HELIUM = GTMaterials.Helium.getFluid();
    private static final Fluid COSMIC_ELEMENT = GTOMaterials.CosmicElement.getFluid();
    private final ConditionalSubscriptionHandler tickSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::update, 20, () -> ((HarmonyMachine)this).isFormed());
    private WirelessEnergyContainer WirelessEnergyContainerCache;
    @Persisted
    private int tier = 1;
    @Persisted
    private int count;
    @Persisted
    private int oc;
    @Persisted
    private long hydrogen;
    @Persisted
    private long helium;
    @Persisted
    private long cosmicElement;

    public HarmonyMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    private void update() {
        this.oc = 0;
        long[] a2 = this.getFluidAmount(new Fluid[]{HYDROGEN, HELIUM, COSMIC_ELEMENT});
        if (this.inputFluid(HYDROGEN, a2[0])) {
            this.hydrogen += a2[0];
        }
        if (this.inputFluid(HELIUM, a2[1])) {
            this.helium += a2[1];
        }
        long requiredCosmic = 1024000L - this.cosmicElement;
        long providedCosmic = Math.min(requiredCosmic, a2[2]);
        if (requiredCosmic > 0L && this.inputFluid(COSMIC_ELEMENT, providedCosmic)) {
            this.cosmicElement += providedCosmic;
        }
        if (this.notConsumableCircuit(4)) {
            this.oc = 4;
        } else if (this.notConsumableCircuit(3)) {
            this.oc = 3;
        } else if (this.notConsumableCircuit(2)) {
            this.oc = 2;
        } else if (this.notConsumableCircuit(1)) {
            this.oc = 1;
        }
        this.tickSubs.updateSubscription();
    }

    private BigInteger getStartupEnergy() {
        if (this.oc == 0) {
            return BigInteger.ZERO;
        }
        return BASE.multiply(BigInteger.ONE.shiftLeft(3 * this.oc - 1));
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.tickSubs.initialize(this.getLevel());
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        if (this.getUUID() != null && this.tier >= recipe.data.m_128451_("tier") && this.hydrogen >= 1024000000L && this.helium >= 1024000000L && this.cosmicElement >= 1024000L && this.oc > 0) {
            BigInteger energy;
            this.hydrogen -= 1024000000L;
            this.helium -= 1024000000L;
            this.cosmicElement -= 1024000L;
            ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
            if (container == null) {
                return null;
            }
            BigInteger storage = container.getStorage();
            if (storage.compareTo(energy = this.getStartupEnergy().multiply(BigInteger.valueOf(Math.max(1, recipe.data.m_128451_("tier") - 1 << 2)))) > 0) {
                container.unrestrictedRemoveEnergy(energy);
                if (this.tier == recipe.data.m_128451_("tier")) {
                    ++this.count;
                    if (this.count > 16 + (this.tier << 2)) {
                        this.count = 0;
                        ++this.tier;
                    }
                }
                recipe.duration >>= this.oc - 1;
                return recipe;
            }
            this.setIdleReason(IdleReason.NO_EU);
        }
        return null;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{this.tier}));
        textList.add((Component)Component.m_237110_((String)"behaviour.lighter.uses", (Object[])new Object[]{16 + (this.tier << 2) - this.count}));
        if (this.getUUID() != null) {
            ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
            textList.add((Component)Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.0", (Object[])new Object[]{TeamUtil.GetName((Level)this.getLevel(), (UUID)this.getUUID())}));
            if (container != null) {
                textList.add((Component)Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.1", (Object[])new Object[]{FormattingUtil.formatNumbers((Object)container.getStorage())}));
            }
        }
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.eye_of_harmony.eu", (Object[])new Object[]{FormattingUtil.formatNumbers((Object)this.getStartupEnergy())}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.eye_of_harmony.hydrogen", (Object[])new Object[]{FormattingUtil.formatNumbers((long)this.hydrogen)}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.eye_of_harmony.helium", (Object[])new Object[]{FormattingUtil.formatNumbers((long)this.helium)}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.eye_of_harmony.cosmicElement", (Object[])new Object[]{FormattingUtil.formatNumbers((long)this.cosmicElement)}));
    }

    @Nullable
    public UUID getUUID() {
        return this.getOwnerUUID();
    }

    public WirelessEnergyContainer getWirelessEnergyContainerCache() {
        return this.WirelessEnergyContainerCache;
    }

    public void setWirelessEnergyContainerCache(WirelessEnergyContainer WirelessEnergyContainerCache) {
        this.WirelessEnergyContainerCache = WirelessEnergyContainerCache;
    }
}

