/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.generator;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gtolib.api.machine.impl.part.WirelessEnergyInterfacePartMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.api.wireless.ExtendWirelessEnergyContainer;
import org.jetbrains.annotations.NotNull;

public final class WirelessEnergyGeneratorMachine
extends ElectricMultiblockMachine {
    private WirelessEnergyInterfacePartMachine energyInterfacePartMachine;

    public WirelessEnergyGeneratorMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void onPartScan(@NotNull IMultiPart part) {
        super.onPartScan(part);
        if (this.energyInterfacePartMachine == null && part instanceof WirelessEnergyInterfacePartMachine) {
            WirelessEnergyInterfacePartMachine hatchPartMachine;
            this.energyInterfacePartMachine = hatchPartMachine = (WirelessEnergyInterfacePartMachine)part;
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.energyInterfacePartMachine = null;
    }

    public Recipe getRealRecipe(@NotNull Recipe recipe) {
        return RecipeModifierFunction.generatorOverclocking((MetaMachine)this, (Recipe)recipe);
    }

    public long getOverclockVoltage() {
        if (this.energyInterfacePartMachine == null) {
            return this.energyContainer.getOverclockVoltage();
        }
        return Long.MAX_VALUE;
    }

    public boolean useEnergy(long eu, boolean simulate) {
        if (eu >= 0L) {
            return true;
        }
        if (this.energyInterfacePartMachine == null) {
            return super.useEnergy(eu, simulate);
        }
        ExtendWirelessEnergyContainer container = this.energyInterfacePartMachine.getWirelessEnergyContainer();
        if (container == null) {
            return false;
        }
        if (simulate) {
            return true;
        }
        container.unrestrictedAddEnergy(-eu);
        return true;
    }
}

