/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.voidseries;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gtocore.common.data.GTOBedrockFluids;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.item.DimensionDataItem;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.machine.impl.DrillingControlCenterMachine;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.machine.trait.IFluidDrillLogic;
import com.gtolib.api.recipe.ContentBuilder;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public final class VoidFluidDrillingRigMachine
extends StorageMultiblockMachine
implements IFluidDrillLogic {
    private static final Recipe RECIPE = RecipeBuilder.ofRaw().notConsumable((Item)GTItems.PROGRAMMED_CIRCUIT.get()).EUt((long)GTValues.VA[6]).duration(20).buildRawRecipe();
    private int c;
    private List<FluidStack> fluidStacks;
    private DrillingControlCenterMachine cache;

    public VoidFluidDrillingRigMachine(MetaMachineBlockEntity holder) {
        super(holder, 1, i -> i.m_150930_((Item)GTOItems.DIMENSION_DATA.get()) && i.m_41782_());
    }

    public void onMachineChanged() {
        this.fluidStacks = GTOBedrockFluids.ALL_BEDROCK_FLUID.get(GTODimensions.getDimensionKey((ResourceLocation)DimensionDataItem.getDimension(this.getStorageStack())));
        if (this.fluidStacks == null) {
            return;
        }
        this.c = this.checkingCircuit(false);
        this.getRecipeLogic().updateTickSubscription();
    }

    public void onContentChanges(RecipeHandlerList handlerList) {
        if (handlerList.hasCapability((RecipeCapability)ItemRecipeCapability.CAP)) {
            this.c = this.checkingCircuit(false);
        }
    }

    private Recipe getRecipe() {
        if (this.fluidStacks == null) {
            return null;
        }
        if (this.getOverclockVoltage() > (long)GTValues.VA[6] && !this.isEmpty() && RecipeRunner.matchRecipeInput((IRecipeCapabilityHolder)this, (Recipe)RECIPE)) {
            Recipe recipe = RECIPE.copy();
            recipe.eut = GTValues.VA[this.getTier()];
            FluidStack fluidStack = this.fluidStacks.get(Math.min(this.fluidStacks.size() - 1, this.c)).copy();
            int amount = fluidStack.getAmount() * (1 << this.getTier() - 2);
            DrillingControlCenterMachine machine = (DrillingControlCenterMachine)this.getNetMachine();
            if (machine != null) {
                amount = (int)((double)amount * machine.getMultiplier());
            }
            fluidStack.setAmount(amount);
            recipe.outputs.put(FluidRecipeCapability.CAP, List.of(ContentBuilder.create().fluid(fluidStack).builder()));
            return recipe;
        }
        return null;
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.onMachineChanged();
    }

    public void addDisplayText(@NotNull List<Component> textList) {
        super.addDisplayText(textList);
        if (this.fluidStacks != null && this.isFormed() && !this.getStorageStack().m_41619_()) {
            textList.add((Component)Component.m_237115_((String)"gui.ae2.Fluids").m_130946_(":"));
            this.fluidStacks.forEach(f -> textList.add((Component)f.getFluid().getFluidType().getDescription().m_6881_().m_130946_("x" + f.getAmount())));
        }
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }

    public DrillingControlCenterMachine getNetMachineCache() {
        return this.cache;
    }

    public void setNetMachineCache(DrillingControlCenterMachine cache) {
        this.cache = cache;
    }

    public MetaMachine getMachine() {
        return this;
    }
}

