/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.voidseries;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.machine.trait.AdvancedInfiniteDrillLogic;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class AdvancedInfiniteDrillMachine
extends StorageMultiblockMachine {
    private static final FluidStack DISTILLED_WATER = GTMaterials.DistilledWater.getFluid(20000);
    private static final FluidStack OXYGEN = GTMaterials.Oxygen.getFluid(FluidStorageKeys.LIQUID, 20000);
    private static final FluidStack HELIUM = GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID, 20000);
    private static final Map<Material, Integer> HEAT_MAP = Map.of(GTOMaterials.Neutron, 1);
    private static final int RUNNING_HEAT = 2000;
    private static final int MAX_HEAT = 10000;
    @Persisted
    private int currentHeat = 300;
    @Persisted
    private int process;
    private final ConditionalSubscriptionHandler heatSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::heatUpdate, 5, () -> ((AdvancedInfiniteDrillMachine)this).isFormed());

    public AdvancedInfiniteDrillMachine(MetaMachineBlockEntity holder) {
        super(holder, 1, i -> ChemicalHelper.getPrefix((ItemLike)i.m_41720_()) == TagPrefix.toolHeadDrill);
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new AdvancedInfiniteDrillLogic((IRecipeLogicMachine)this, 5);
    }

    private void heatUpdate() {
        boolean heatedByPlayer;
        this.heatSubs.updateSubscription();
        boolean isWorking = this.getRecipeLogic().isWorking();
        int playerWantsToHeat = !this.isEmpty() ? this.inputBlast() : 0;
        boolean bl = heatedByPlayer = playerWantsToHeat > 0;
        if (heatedByPlayer && this.currentHeat < 10000) {
            playerWantsToHeat = Math.min(playerWantsToHeat, 10000 - this.currentHeat);
            this.currentHeat += playerWantsToHeat;
        }
        if (isWorking && this.process <= 0) {
            this.currentHeat += (int)Math.floor((double)Math.abs(this.currentHeat - 2000) / 2000.0);
        }
        if (isWorking) {
            if (this.inputFluid(new FluidStack[]{DISTILLED_WATER})) {
                --this.currentHeat;
            } else if (this.inputFluid(new FluidStack[]{OXYGEN})) {
                this.currentHeat -= 2;
            } else if (this.inputFluid(new FluidStack[]{HELIUM})) {
                this.currentHeat -= 4;
            }
        }
        if (!isWorking && !heatedByPlayer) {
            this.currentHeat = Math.max(300, this.currentHeat - 1);
        }
        this.currentHeat = Math.max(4, this.currentHeat);
        if (this.currentHeat > 10000) {
            ++this.process;
            if (this.process >= 200) {
                this.process = 0;
                this.currentHeat = 300;
                this.machineStorage.setStackInSlot(0, ItemStack.f_41583_);
                this.getRecipeLogic().interruptRecipe();
            }
        } else if (this.process > 0) {
            --this.process;
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.heatSubs.initialize(this.getLevel());
    }

    public AdvancedInfiniteDrillLogic getRecipeLogic() {
        return (AdvancedInfiniteDrillLogic)super.getRecipeLogic();
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        if (this.isEmpty()) {
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.advanced_infinite_driller.not_fluid_head").m_130940_(ChatFormatting.RED));
        } else {
            textList.add((Component)Component.m_237110_((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{5, 5}));
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.advanced_infinite_driller.heat", (Object[])new Object[]{10000, 2000}));
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.current_temperature", (Object[])new Object[]{this.currentHeat}));
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.fission_reactor.damaged", (Object[])new Object[]{FormattingUtil.formatNumber2Places((float)((float)this.process / 200.0f * 100.0f))}).m_130946_("%"));
            Reference2IntOpenHashMap<Fluid> fluids = this.getRecipeLogic().getVeinFluids();
            if (!fluids.isEmpty()) {
                fluids.forEach((fluid, produced) -> {
                    MutableComponent fluidInfo = fluid.getFluidType().getDescription().m_6881_().m_130940_(ChatFormatting.GREEN);
                    MutableComponent amountInfo = Component.m_237113_((String)(FormattingUtil.formatNumbers((int)(produced * this.getRate())) + " mB/s")).m_130940_(ChatFormatting.BLUE);
                    textList.add((Component)Component.m_237110_((String)"gtocore.machine.advanced_infinite_driller.drilled_fluid", (Object[])new Object[]{fluidInfo, amountInfo}));
                });
            } else {
                MutableComponent noFluid = Component.m_237115_((String)"gtceu.multiblock.fluid_rig.no_fluid_in_area").m_130940_(ChatFormatting.RED);
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.fluid_rig.drilled_fluid", (Object[])new Object[]{noFluid}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public int getRate() {
        return (int)Math.max(1.0, (double)((this.currentHeat - 2000) * this.getDrillHeadTier()) * 0.75);
    }

    private int getDrillHeadTier() {
        Material material;
        Integer result;
        MaterialStack ms;
        ItemStack itemStack = this.getStorageStack();
        if (!itemStack.m_41619_() && !(ms = ChemicalHelper.getMaterialStack((ItemStack)itemStack)).isEmpty() && (result = HEAT_MAP.get(material = ms.material())) != null) {
            return result;
        }
        return 0;
    }

    private int inputBlast() {
        if (this.inputFluid(new FluidStack[]{GTMaterials.Blaze.getFluid(this.getFluidConsume())})) {
            return 1;
        }
        if (this.inputFluid(new FluidStack[]{GTOMaterials.BlazeCube.getFluid(this.getFluidConsume())})) {
            return 1000;
        }
        return 0;
    }

    private int getFluidConsume() {
        return (int)Math.pow(this.currentHeat, 1.3);
    }

    public boolean canRunnable() {
        return this.currentHeat >= 2000;
    }

    @Generated
    public int getCurrentHeat() {
        return this.currentHeat;
    }
}

