/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space.spacestaion;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.api.machine.part.ILargeSpaceStationMachine;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.AbstractSpaceStation;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.CleanroomProvider;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.ISpaceServiceMachine;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.SpaceElevatorConnectorModule;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.SpaceStationEnergyConversionModule;
import com.gtolib.api.capability.IIWirelessInteractor;
import com.gtolib.api.machine.feature.IWirelessDimensionProvider;
import com.gtolib.api.machine.feature.multiblock.ITierCasingMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.machine.trait.TierCasingTrait;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.utils.ServerUtils;
import com.hepdd.gtmthings.api.misc.WirelessEnergyContainer;
import earth.terrarium.adastra.api.planets.PlanetApi;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Core
extends AbstractSpaceStation
implements ILargeSpaceStationMachine,
IWirelessDimensionProvider {
    private final Map<Class<? extends ISpaceServiceMachine>, ISpaceServiceMachine> serviceMachineMap = new Reference2ObjectOpenHashMap();
    private final Set<ILargeSpaceStationMachine> subMachinesFlat = new ObjectOpenHashSet();
    private WirelessEnergyContainer WirelessEnergyContainerCache;
    private final TierCasingTrait tierCasingTrait = new TierCasingTrait((ITierCasingMachine)this, new String[]{"i_f"});
    private boolean dirty = false;

    @Override
    public void markDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public Core(MetaMachineBlockEntity metaMachineBlockEntity) {
        super(metaMachineBlockEntity);
    }

    @Override
    public Core getRoot() {
        return this;
    }

    @Override
    public void setRoot(Core root) {
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.onFormed();
        IIWirelessInteractor.addToNet((Object)this);
        this.markDirty(true);
        this.loadContainer();
    }

    @Override
    public void onUnload() {
        this.unloadContainer();
        IIWirelessInteractor.removeFromNet((Object)this);
        super.onUnload();
    }

    public boolean isWorkingEnabled() {
        return true;
    }

    public void setWorkingEnabled(boolean ignored) {
    }

    private void delayedUnload() {
        if (!this.isRemote()) {
            ServerUtils.getServer().m_6937_((Runnable)new TickTask(200, () -> {
                if (this.getHolder().m_58898_() && !this.isFormed()) {
                    this.unloadContainer();
                }
            }));
        }
    }

    public void onStructureInvalid() {
        this.delayedUnload();
        super.onStructureInvalid();
        IIWirelessInteractor.removeFromNet((Object)this);
        this.onInvalid();
    }

    @Override
    public void onMachineRemoved() {
        super.onMachineRemoved();
        this.removeAllSubMachines();
    }

    @Override
    public void customText(@NotNull List<Component> list) {
        super.customText(list);
        list.add((Component)Component.m_237110_((String)"gui.ae2.PowerUsageRate", (Object[])new Object[]{"%s EU/t".formatted(FormattingUtil.formatNumbers((long)this.getEUt()))}).m_130940_(ChatFormatting.YELLOW));
        list.add((Component)Component.m_237110_((String)"gtocore.machine.spacestation.energy_consumption.total", (Object[])new Object[]{FormattingUtil.formatNumbers((Object)Optional.ofNullable(this.getRecipeLogic().getLastRecipe()).map(GTRecipe::getInputEUt).orElse(0L))}).m_130940_(ChatFormatting.GOLD));
        list.add((Component)Component.m_237110_((String)"gtocore.machine.spacestation.module_count", (Object[])new Object[]{this.subMachinesFlat.size()}));
    }

    private void removeAllSubMachines() {
        for (ILargeSpaceStationMachine m : this.subMachinesFlat) {
            if (m == this || m.getRoot() != this) continue;
            m.setRoot(null);
        }
        this.subMachinesFlat.clear();
    }

    private void refreshModules() {
        this.removeAllSubMachines();
        this.serviceMachineMap.clear();
        ReferenceOpenHashSet its = new ReferenceOpenHashSet((Collection)this.getConnectedModules());
        while (!its.isEmpty()) {
            Iterator it = its.iterator();
            ILargeSpaceStationMachine m = (ILargeSpaceStationMachine)it.next();
            it.remove();
            if (m.getRoot() != null) continue;
            m.setRoot(this);
            if (m instanceof ISpaceServiceMachine) {
                ISpaceServiceMachine serviceMachine = (ISpaceServiceMachine)((Object)m);
                this.serviceMachineMap.putIfAbsent(serviceMachine.getClass(), serviceMachine);
            }
            if (!this.subMachinesFlat.add(m)) continue;
            its.addAll(m.getConnectedModules());
        }
    }

    @Override
    public Set<BlockPos> getModulePositions() {
        BlockPos pos = this.getPos();
        Direction fFacing = this.getFrontFacing();
        Direction uFacing = RelativeDirection.UP.getRelative(fFacing, this.getUpwardsFacing(), false);
        Direction thirdAxis = RelativeDirection.RIGHT.getRelative(fFacing, this.getUpwardsFacing(), false);
        return Set.of(pos.m_5484_(fFacing, 38).m_5484_(uFacing, 6).m_5484_(thirdAxis, 2), pos.m_5484_(fFacing, 38).m_5484_(uFacing, 6).m_5484_(thirdAxis.m_122424_(), 2), pos.m_5484_(fFacing, 38).m_5484_(uFacing, 4), pos.m_5484_(fFacing, 38).m_5484_(uFacing, 8));
    }

    @Override
    public ILargeSpaceStationMachine.ConnectType getConnectType() {
        return ILargeSpaceStationMachine.ConnectType.CORE;
    }

    @NotNull
    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe, false);
    }

    @Override
    public Recipe getRecipe() {
        if (!PlanetApi.API.isSpace(this.getLevel())) {
            return null;
        }
        if (this.dirty) {
            this.refreshModules();
            this.dirty = false;
        }
        long EUt = this.getEUt();
        for (ILargeSpaceStationMachine machine : this.subMachinesFlat) {
            EUt += machine.getEUt();
            if (!(machine instanceof IRecipeLogicMachine)) continue;
            IRecipeLogicMachine r = (IRecipeLogicMachine)machine;
            r.getRecipeLogic().updateTickSubscription();
        }
        return Core.inputFluids(this.getRecipeBuilder().duration(20).EUt(EUt), this.subMachinesFlat.size() + 1).outputFluids(GTOMaterials.FlocculationWasteSolution.getFluid(30 * (this.subMachinesFlat.size() + 1))).buildRawRecipe();
    }

    private static RecipeBuilder inputFluids(RecipeBuilder builder, int mul) {
        builder.inputFluids(GTMaterials.DistilledWater, 15 * mul);
        builder.inputFluids(GTMaterials.RocketFuel, 10 * mul);
        builder.inputFluids(GTMaterials.Air, 100 * mul);
        return builder;
    }

    public boolean onWorking() {
        if (this.firstLoad() || this.getOffsetTimer() % 400 == 0) {
            this.provideOxygen();
        }
        return super.onWorking();
    }

    @Override
    public long getEUt() {
        return GTValues.VA[5];
    }

    public Object2IntMap<String> getCasingTiers() {
        return this.tierCasingTrait.getCasingTiers();
    }

    @Nullable
    public UUID getUUID() {
        return this.getOwnerUUID();
    }

    public void setWirelessEnergyContainerCache(WirelessEnergyContainer WirelessEnergyContainerCache) {
        this.WirelessEnergyContainerCache = WirelessEnergyContainerCache;
    }

    public WirelessEnergyContainer getWirelessEnergyContainerCache() {
        return this.WirelessEnergyContainerCache;
    }

    @Override
    public Set<CleanroomType> getTypes() {
        CleanroomProvider provider = (CleanroomProvider)this.serviceMachineMap.get(CleanroomProvider.class);
        if (provider == null) {
            return Collections.emptySet();
        }
        return provider.getTypes();
    }

    public boolean canUseLaser() {
        return this.serviceMachineMap.get(SpaceStationEnergyConversionModule.class) != null;
    }

    public double getDurationMultiplierFromSpaceElevator() {
        SpaceElevatorConnectorModule provider = (SpaceElevatorConnectorModule)this.serviceMachineMap.get(SpaceElevatorConnectorModule.class);
        if (provider == null) {
            return 1.0;
        }
        return provider.getDurationMultiplier();
    }

    @Generated
    public Map<Class<? extends ISpaceServiceMachine>, ISpaceServiceMachine> getServiceMachineMap() {
        return this.serviceMachineMap;
    }

    @Generated
    public boolean isDirty() {
        return this.dirty;
    }
}

