/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space.spacestaion;

import com.google.common.collect.ImmutableSet;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IFilterType;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gtocore.api.machine.part.ILargeSpaceStationMachine;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.Extension;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.ISpaceServiceMachine;
import com.gtocore.common.machine.multiblock.part.maintenance.CMHatchPartMachine;
import com.gtolib.api.capability.IIWirelessInteractor;
import com.gtolib.api.machine.feature.multiblock.IDroneControlCenterMachine;
import com.gtolib.api.machine.impl.part.DroneHatchPartMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanroomProvider
extends Extension
implements IDroneControlCenterMachine,
ISpaceServiceMachine {
    @Nullable
    private ICleanroomProvider cleanroomType = null;
    private final List<DroneHatchPartMachine> droneHatchPartMachine = new ArrayList<DroneHatchPartMachine>();

    public CleanroomProvider(MetaMachineBlockEntity metaMachineBlockEntity) {
        super(metaMachineBlockEntity, ILargeSpaceStationMachine.twoWayPositionFunction(41));
    }

    @Override
    public void onStructureFormed() {
        this.droneHatchPartMachine.clear();
        super.onStructureFormed();
        IFilterType filterType = (IFilterType)this.getMultiblockState().getMatchContext().get((Object)"FilterType");
        if (filterType != null) {
            this.cleanroomType = switch (filterType.getCleanroomType().getName()) {
                case "sterile_cleanroom" -> CMHatchPartMachine.STERILE_DUMMY_CLEANROOM;
                case "law_cleanroom" -> CMHatchPartMachine.LAW_DUMMY_CLEANROOM;
                default -> CMHatchPartMachine.DUMMY_CLEANROOM;
            };
        }
        IIWirelessInteractor.addToNet((Object)this, IDroneControlCenterMachine.class);
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.cleanroomType = null;
        this.droneHatchPartMachine.clear();
        IIWirelessInteractor.removeFromNet((Object)this, IDroneControlCenterMachine.class);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.cleanroomType = null;
        IIWirelessInteractor.removeFromNet((Object)this, IDroneControlCenterMachine.class);
    }

    public boolean isActiveState() {
        return this.isWorkspaceReady();
    }

    public void onPartScan(@NotNull IMultiPart part) {
        super.onPartScan(part);
        if (part instanceof DroneHatchPartMachine) {
            DroneHatchPartMachine machine = (DroneHatchPartMachine)part;
            this.droneHatchPartMachine.add(machine);
        }
    }

    @Override
    public long getEUt() {
        if (this.cleanroomType == null) {
            return GTValues.VA[3];
        }
        return (long)GTValues.VA[6] * (long)this.cleanroomType.getTypes().size();
    }

    @Override
    public Set<CleanroomType> getTypes() {
        return this.cleanroomType == null ? Collections.emptySet() : ImmutableSet.copyOf((Collection)this.cleanroomType.getTypes());
    }

    public List<DroneHatchPartMachine> getDroneHatchPartMachine() {
        return this.droneHatchPartMachine;
    }

    @Override
    public void customText(@NotNull List<Component> list) {
        super.customText(list);
        list.add((Component)Component.m_237115_((String)"gtocore.machine.modular_maintenance.current_cleanroom"));
        list.add((Component)this.getCurrentCleanroom().m_130940_(ChatFormatting.GREEN));
        super.addCustomText(list);
    }

    private MutableComponent getCurrentCleanroom() {
        if (this.cleanroomType == null || this.cleanroomType.getTypes().isEmpty()) {
            return Component.m_237115_((String)"gtocore.machine.modular_maintenance.no_cleanroom");
        }
        MutableComponent result = Component.m_237119_();
        Iterator iterator = this.cleanroomType.getTypes().iterator();
        while (iterator.hasNext()) {
            result.m_7220_((Component)Component.m_237115_((String)((CleanroomType)iterator.next()).getTranslationKey()));
            if (!iterator.hasNext()) continue;
            result.m_130946_(", ");
        }
        return result;
    }
}

