/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.nano;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.data.GTOMaterials;
import com.gtolib.api.machine.feature.multiblock.IMultiStructureMachine;
import com.gtolib.api.machine.feature.multiblock.IParallelMachine;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class NanoForgeMachine
extends StorageMultiblockMachine
implements IParallelMachine,
IMultiStructureMachine {
    private static final Int2ObjectOpenHashMap<BlockPattern> PATTERNS = new Int2ObjectOpenHashMap(4, 0.9f);
    @Persisted
    @DescSynced
    private int machineTier;

    public NanoForgeMachine(MetaMachineBlockEntity holder) {
        super(holder, 64, i -> ChemicalHelper.getPrefix((ItemLike)i.m_41720_()) == GTOTagPrefix.NANITES);
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        if (recipe.data.m_128451_("nano_forge_tier") > this.machineTier) {
            return null;
        }
        if ((recipe = ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)(this.getParallel() * (1L << this.machineTier - recipe.data.m_128451_("nano_forge_tier"))))) == null) {
            return null;
        }
        return RecipeModifierFunction.overclocking((MetaMachine)this, (Recipe)recipe, (boolean)false, (double)1.0, (double)1.0, (double)(this.machineTier > recipe.data.m_128451_("nano_forge_tier") ? 0.25 : 0.5));
    }

    public void onMachineChanged() {
        this.machineTier = 0;
        MaterialStack stack = ChemicalHelper.getMaterialStack((ItemStack)this.getStorageStack());
        if (stack.isEmpty()) {
            return;
        }
        Material material = stack.material();
        if (material == GTMaterials.Carbon) {
            this.machineTier = 1;
        } else if (material == GTOMaterials.Amprosium) {
            this.machineTier = 2;
        } else if (material == GTOMaterials.Draconium) {
            this.machineTier = 3;
        }
        this.updateCheck();
    }

    public static BlockPattern getBlockPattern(int tier, MultiblockMachineDefinition definition) {
        return (BlockPattern)PATTERNS.computeIfAbsent(tier, t -> {
            FactoryBlockPattern builder = FactoryBlockPattern.start((MultiblockMachineDefinition)definition).where('~', Predicates.controller((MachineDefinition)definition)).where(' ', Predicates.any());
            return switch (t) {
                case 2 -> builder.aisle(new String[]{"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "    A              ", "    A              ", "    A              ", "    A              ", "    A              ", "    A              ", "    A              ", "    A              ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"  CCCCC            ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{" CAAAAAC           ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "  DA AD            ", "  DA AD            ", "  DA AD            ", "  DA AD            ", "  AA AA            ", "  AA AA            ", "  AA AA            ", "  AA AA            ", "  AA AA            ", "  AA AA            ", "  AA AA            ", "  AA AA            ", "  DA AD            ", "  DA AD            ", "  DA AD            ", "  DA AD            ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "    D              ", "    D              ", "    D              ", "    D              ", "    D              "}).aisle(new String[]{"CAAAAAAAC          ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", " AA   AA           ", " AA   AA           ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "    A              ", "    A              ", "    A              ", "    A              ", "    A              "}).aisle(new String[]{"CAAAAAAAC          ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", " AA   AA           ", " AA   AA           ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "    A              ", "    A              ", "    A              ", "    A              ", "    A              "}).aisle(new String[]{"CAAAAAAAC   AAAAAA ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", " AA   AA           ", " AA   AA           ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "    A              ", "    A              ", "    A              ", "    A              ", "    A              "}).aisle(new String[]{"CAAAAAAAC  AAAAAAAA", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", " AA   AA           ", " AA   AA           ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", "  A   A            ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "   A A             ", "    A              ", "    A              ", "    A              ", "    A              ", "    A              "}).aisle(new String[]{" CAAAAAC   AAAAAAAA", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD        AA   ", "   DAD        BB   ", "   DAD        AA   ", "  DA AD            ", "  DA AD            ", "  DA AD            ", "  DA AD            ", "  AA AA       AA   ", "  AA AA       BB   ", "  AA AA       AA   ", "  AA AA            ", "  AA AA            ", "  AA AA            ", "  AA AA            ", "  AA AA            ", "  DA AD            ", "  DA AD            ", "  DA AD            ", "  DA AD            ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "    D              ", "    D              ", "    D              ", "    D              ", "    D              "}).aisle(new String[]{"  CC~CC    AAAAAAAA", "              AA   ", "              AA   ", "              AA   ", "              AA   ", "             AAAA  ", "             BAAB  ", "             AAAA  ", "   DAD        AA   ", "   DAD        AA   ", "   DAD        AA   ", "   DAD        AA   ", "   DAD       AAAA  ", "   DAD       BAAB  ", "   DAD       AAAA  ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "   DAD             ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"           AAAAAAAA", "              AA   ", "              AA   ", "              AA   ", "              AA   ", "             AAAA  ", "             BAAB  ", "             AAAA  ", "              AA   ", "              AA   ", "              AA   ", "              AA   ", "    A        AAAA  ", "    A        BAAB  ", "    A        AAAA  ", "    A              ", "    A              ", "    A              ", "    A              ", "    A              ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"           AAAAAAAA", "                   ", "                   ", "                   ", "                   ", "              AA   ", "              BB   ", "              AA   ", "                   ", "                   ", "                   ", "                   ", "              AA   ", "              BB   ", "              AA   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"           AAAAAAAA", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"            AAAAAA ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.NAQUADAH_ALLOY_CASING.get()})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.NAQUADAH_ALLOY_CASING.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_ITEMS})).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.EXPORT_ITEMS})).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_FLUIDS})).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_LASER}))).where('B', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_ASSEMBLY_LINE.get()})).where('D', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Ruridit)})).build();
                case 3 -> builder.aisle(new String[]{"                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "              A              ", "              A              ", "              A              ", "              A              ", "              A              ", "              A              ", "              A              ", "              A              ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             "}).aisle(new String[]{"            DDDDD            ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             "}).aisle(new String[]{"           DAAAAAD           ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "            CA AC            ", "            CA AC            ", "            CA AC            ", "            CA AC            ", "            AA AA            ", "            AA AA            ", "            AA AA            ", "            AA AA            ", "            AA AA            ", "            AA AA            ", "            AA AA            ", "            AA AA            ", "            CA AC            ", "            CA AC            ", "            CA AC            ", "            CA AC            ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "              C              ", "              C              ", "              C              ", "              C              ", "              C              "}).aisle(new String[]{"          DAAAAAAAD          ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "            A   A            ", "            A   A            ", "            A   A            ", "            A   A            ", "            A   A            ", "           AA   AA           ", "           AA   AA           ", "            A   A            ", "            A   A            ", "            A   A            ", "            A   A            ", "            A   A            ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "              A              ", "              A              ", "              A              ", "              A              ", "              A              "}).aisle(new String[]{"          DAAAAAAAD          ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "            A   A            ", "            A   A            ", "            A   A            ", "            A   A            ", "            A   A            ", "           AA   AA           ", "           AA   AA           ", "            A   A            ", "            A   A            ", "            A   A            ", "            A   A            ", "            A   A            ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "              A              ", "              A              ", "              A              ", "              A              ", "              A              "}).aisle(new String[]{" AAAAAA   DAAAAAAAD   AAAAAA ", "             A A             ", "    CC       A A             ", "  CC         A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "    CC       A A             ", "  CC         A A             ", "            A   A            ", "            A   A            ", "            A   A            ", "            A   A            ", "    CC      A   A            ", "  CC       AA   AA           ", "           AA   AA           ", "            A   A            ", "            A   A            ", "            A   A            ", "    CC      A   A            ", "  CC        A   A            ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "              A              ", "              A              ", "              A              ", "              A              ", "              A              "}).aisle(new String[]{"AAAAAAAA  DAAAAAAAD  AAAAAAAA", "      C      A A             ", "             A A             ", "             A A             ", " C           A A             ", "             A A             ", "             A A             ", "      C      A A             ", "             A A             ", "             A A             ", " C          A   A            ", "            A   A            ", "            A   A            ", "      C     A   A            ", "            A   A            ", "           AA   AA           ", " C         AA   AA           ", "            A   A            ", "            A   A            ", "      C     A   A            ", "            A   A            ", "            A   A            ", " C           A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "             A A             ", "              A              ", "              A              ", "              A              ", "              A              ", "              A              "}).aisle(new String[]{"AAAAAAAA   DAAAAAD   AAAAAAAA", "             CAC             ", "             CAC             ", "             CAC             ", "   AA        CAC             ", "C  BB        CAC        AA   ", "   AA  C     CAC        BB   ", "             CAC        AA   ", "            CA AC            ", "            CA AC            ", "            CA AC            ", "C           CA AC            ", "       C    AA AA       AA   ", "            AA AA       BB   ", "   AA       AA AA       AA   ", "   AA       AA AA            ", "   AA       AA AA            ", "C  AA       AA AA            ", "       C    AA AA            ", "            AA AA            ", "            CA AC            ", "            CA AC            ", "            CA AC            ", "C           CA AC            ", "   AA  C     CAC             ", "   BBCC      CAC             ", "   AA        CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "             CAC             ", "              C              ", "              C              ", "              C              ", "              C              ", "              C              "}).aisle(new String[]{"AAAAAAAA    DD~DD    AAAAAAAA", "   AA                   AA   ", "   AA                   AA   ", "   AA                   AA   ", "  AAAA                  AA   ", "C BAAB                 AAAA  ", "  AAAA C               BAAB  ", "   AA                  AAAA  ", "   AA        CAC        AA   ", "   AA        CAC        AA   ", "   AA        CAC        AA   ", "C  AA        CAC        AA   ", "   AA  C     CAC       AAAA  ", "   AA        CAC       BAAB  ", "  AAAA       CAC       AAAA  ", "  AAAA       CAC             ", "  AAAA       CAC             ", "C AAAA       CAC             ", "   AA  C     CAC             ", "   AA        CAC             ", "   AA        CAC             ", "   AA        CAC             ", "   AA        CAC             ", "C  AA        CAC             ", "  AAAA C                     ", "  BAAB                       ", "  AAAA                       ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             "}).aisle(new String[]{"AAAAAAAA             AAAAAAAA", "   AA                   AA   ", "   AA                   AA   ", "   AA                   AA   ", "  AAAA                  AA   ", "  BAAB C               AAAA  ", "C AAAA                 BAAB  ", "   AA                  AAAA  ", "   AA                   AA   ", "   AA                   AA   ", "   AA                   AA   ", "   AA  C                AA   ", "C  AA         A        AAAA  ", "   AA         A        BAAB  ", "  AAAA        A        AAAA  ", "  AAAA        A              ", "  AAAA        A              ", "  AAAA C      A              ", "C  AA         A              ", "   AA         A              ", "   AA                        ", "   AA                        ", "   AA                        ", "   AA  C                     ", "C AAAA                       ", "  BAAB                       ", "  AAAA                       ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             "}).aisle(new String[]{"AAAAAAAA             AAAAAAAA", "                             ", "                             ", "                             ", "   AA                        ", "   BB  C                AA   ", "C  AA                   BB   ", "                        AA   ", "                             ", "                             ", "                             ", "       C                     ", "C                       AA   ", "                        BB   ", "   AA                   AA   ", "   AA                        ", "   AA                        ", "   AA  C                     ", "C                            ", "                             ", "                             ", "                             ", "                             ", "       C                     ", "C  AA                        ", " CCBB                        ", "   AA                        ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             "}).aisle(new String[]{"AAAAAAAA             AAAAAAAA", " C                           ", "                             ", "                             ", "      C                      ", "                             ", "                             ", " C                           ", "                             ", "                             ", "      C                      ", "                             ", "                             ", " C                           ", "                             ", "                             ", "      C                      ", "                             ", "                             ", " C                           ", "                             ", "                             ", "      C                      ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             "}).aisle(new String[]{" AAAAAA               AAAAAA ", "                             ", "  CC                         ", "    CC                       ", "                             ", "                             ", "                             ", "                             ", "  CC                         ", "    CC                       ", "                             ", "                             ", "                             ", "                             ", "  CC                         ", "    CC                       ", "                             ", "                             ", "                             ", "                             ", "  CC                         ", "    CC                       ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             ", "                             "}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.NAQUADAH_ALLOY_CASING.get()})).where('D', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.NAQUADAH_ALLOY_CASING.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_ITEMS})).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.EXPORT_ITEMS})).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_FLUIDS})).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_LASER}))).where('B', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.ADVANCED_ASSEMBLY_LINE_UNIT.get()})).where('C', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Ruridit)})).build();
                default -> builder.aisle(new String[]{"         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "    B    ", "    B    ", "    B    ", "    B    ", "    B    ", "    B    ", "    B    ", "    B    ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         "}).aisle(new String[]{"  AAAAA  ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         "}).aisle(new String[]{" ABBBBBA ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "  CB BC  ", "  CB BC  ", "  CB BC  ", "  CB BC  ", "  BB BB  ", "  BB BB  ", "  BB BB  ", "  BB BB  ", "  BB BB  ", "  BB BB  ", "  BB BB  ", "  BB BB  ", "  CB BC  ", "  CB BC  ", "  CB BC  ", "  CB BC  ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "    C    ", "    C    ", "    C    ", "    C    ", "    C    "}).aisle(new String[]{"ABBBBBBBA", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", " BB   BB ", " BB   BB ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "    B    ", "    B    ", "    B    ", "    B    ", "    B    "}).aisle(new String[]{"ABBBBBBBA", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", " BB   BB ", " BB   BB ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "    B    ", "    B    ", "    B    ", "    B    ", "    B    "}).aisle(new String[]{"ABBBBBBBA", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", " BB   BB ", " BB   BB ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "    B    ", "    B    ", "    B    ", "    B    ", "    B    "}).aisle(new String[]{"ABBBBBBBA", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", " BB   BB ", " BB   BB ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", "  B   B  ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "   B B   ", "    B    ", "    B    ", "    B    ", "    B    ", "    B    "}).aisle(new String[]{" ABBBBBA ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "  CB BC  ", "  CB BC  ", "  CB BC  ", "  CB BC  ", "  BB BB  ", "  BB BB  ", "  BB BB  ", "  BB BB  ", "  BB BB  ", "  BB BB  ", "  BB BB  ", "  BB BB  ", "  CB BC  ", "  CB BC  ", "  CB BC  ", "  CB BC  ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "    C    ", "    C    ", "    C    ", "    C    ", "    C    "}).aisle(new String[]{"  AA~AA  ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "   CBC   ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         ", "         "}).where('B', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.NAQUADAH_ALLOY_CASING.get()})).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.NAQUADAH_ALLOY_CASING.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_ITEMS})).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.EXPORT_ITEMS})).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_FLUIDS})).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_LASER}))).where('C', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Ruridit)})).build();
            };
        });
    }

    public BlockPattern getPattern() {
        return NanoForgeMachine.getBlockPattern(this.machineTier, this.getDefinition());
    }

    public long getMaxParallel() {
        return this.machineTier > 0 ? (long)this.getStorageStack().m_41613_() : 0L;
    }

    public List<BlockPattern> getMultiPattern() {
        return List.of(NanoForgeMachine.getBlockPattern(1, this.getDefinition()), NanoForgeMachine.getBlockPattern(2, this.getDefinition()), NanoForgeMachine.getBlockPattern(3, this.getDefinition()));
    }
}

