/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.assembly;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.machine.multiblock.part.FluidHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ItemBusPartMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gtocore.common.machine.multiblock.part.HugeBusPartMachine;
import com.gtocore.data.IdleReason;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.utils.ItemUtils;
import com.gtolib.utils.MathUtil;
import com.hepdd.gtmthings.common.block.machine.multiblock.part.CreativeInputBusPartMachine;
import com.hepdd.gtmthings.common.block.machine.multiblock.part.CreativeInputHatchPartMachine;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AdvancedAssemblyLineMachine
extends ElectricMultiblockMachine {
    private final List<CustomItemStackHandler> itemStackTransfers = new ReferenceArrayList();
    private final List<CustomFluidTank[]> fluidTankTransfers = new ReferenceArrayList();

    public AdvancedAssemblyLineMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        ConfigHolder.MachineConfigs config = ConfigHolder.INSTANCE.machines;
        if (config.orderedAssemblyLineItems && !this.checkItemInputs((GTRecipe)recipe)) {
            this.setIdleReason(IdleReason.ORDERED_ITEM);
            return null;
        }
        if (config.orderedAssemblyLineFluids && !this.checkFluidInputs((GTRecipe)recipe)) {
            this.setIdleReason(IdleReason.ORDERED_FLUID);
            return null;
        }
        return RecipeModifierFunction.laserLossOverclocking((MetaMachine)this, (Recipe)RecipeModifierFunction.hatchParallel((MetaMachine)this, (Recipe)recipe));
    }

    private boolean checkItemInputs(GTRecipe recipe) {
        List inputs = (List)recipe.inputs.get(ItemRecipeCapability.CAP);
        if (this.itemStackTransfers.size() < inputs.size()) {
            return false;
        }
        for (int i = 0; i < inputs.size(); ++i) {
            FastSizedIngredient ingredient;
            Object content = ((Content)inputs.get(i)).getContent();
            if (!(content instanceof FastSizedIngredient) || (ingredient = (FastSizedIngredient)content).m_43947_() || this.matchItem(this.itemStackTransfers.get(i), ingredient)) continue;
            return false;
        }
        return true;
    }

    private boolean checkFluidInputs(GTRecipe recipe) {
        List inputs = (List)recipe.inputs.get(FluidRecipeCapability.CAP);
        if (this.fluidTankTransfers.size() < inputs.size()) {
            return false;
        }
        for (int i = 0; i < inputs.size(); ++i) {
            FastFluidIngredient ingredient;
            Object content = ((Content)inputs.get(i)).getContent();
            if (!(content instanceof FastFluidIngredient) || (ingredient = (FastFluidIngredient)content).isEmpty() || this.matchFluid(this.fluidTankTransfers.get(i), ingredient)) continue;
            return false;
        }
        return true;
    }

    private boolean matchItem(CustomItemStackHandler storage, FastSizedIngredient currentIngredient) {
        Item item = Items.f_41852_;
        for (int slot = 0; slot < storage.getSlots(); ++slot) {
            ItemStack stack = storage.getStackInSlot(slot);
            Item providedItem = stack.m_41720_();
            if (providedItem == Items.f_41852_ || providedItem == item) continue;
            if (item != Items.f_41852_) {
                return false;
            }
            if (!currentIngredient.testItem(providedItem)) {
                return false;
            }
            item = providedItem;
        }
        return item != Items.f_41852_;
    }

    private boolean matchFluid(CustomFluidTank[] storage, FastFluidIngredient currentIngredient) {
        Fluid fluid = Fluids.f_76191_;
        for (CustomFluidTank tank : storage) {
            Fluid providedFluid = tank.getFluid().getFluid();
            if (providedFluid == Fluids.f_76191_ || providedFluid == fluid) continue;
            if (fluid != Fluids.f_76191_) {
                return false;
            }
            if (!currentIngredient.testFluid(providedFluid)) {
                return false;
            }
            fluid = providedFluid;
        }
        return fluid != Fluids.f_76191_;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new AssemblyLineLogic((IRecipeLogicMachine)this);
    }

    public Comparator<IMultiPart> getPartSorter() {
        return Comparator.comparing(p -> p.self().getPos(), RelativeDirection.RIGHT.getSorter(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped()));
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.itemStackTransfers.clear();
        this.fluidTankTransfers.clear();
        for (IMultiPart part : this.getParts()) {
            if (part instanceof ItemBusPartMachine) {
                ItemBusPartMachine itemBusPart = (ItemBusPartMachine)part;
                NotifiableItemStackHandler inv = itemBusPart.getInventory();
                if (inv.handlerIO != IO.IN && inv.handlerIO != IO.BOTH) continue;
                this.itemStackTransfers.add(inv.storage);
                continue;
            }
            if (part instanceof HugeBusPartMachine) {
                HugeBusPartMachine hugeBusPartMachine = (HugeBusPartMachine)part;
                this.itemStackTransfers.add(hugeBusPartMachine.getInventory().storage);
                continue;
            }
            if (part instanceof FluidHatchPartMachine) {
                FluidHatchPartMachine fluidHatchPartMachine = (FluidHatchPartMachine)part;
                this.fluidTankTransfers.add(fluidHatchPartMachine.tank.getStorages());
                continue;
            }
            if (part instanceof CreativeInputBusPartMachine) {
                CreativeInputBusPartMachine creativeInputBusPartMachine = (CreativeInputBusPartMachine)part;
                this.itemStackTransfers.add(creativeInputBusPartMachine.getInventory().storage);
                continue;
            }
            if (!(part instanceof CreativeInputHatchPartMachine)) continue;
            CreativeInputHatchPartMachine creativeInputHatchPartMachine = (CreativeInputHatchPartMachine)part;
            this.fluidTankTransfers.add(creativeInputHatchPartMachine.tank.getStorages());
        }
    }

    private static class AssemblyLineLogic
    extends RecipeLogic {
        private AssemblyLineLogic(IRecipeLogicMachine machine) {
            super(machine);
        }

        @NotNull
        public AdvancedAssemblyLineMachine getMachine() {
            return (AdvancedAssemblyLineMachine)super.getMachine();
        }

        protected boolean handleRecipeIO(GTRecipe recipe, IO io) {
            List items;
            if (io != IO.IN) {
                return super.handleRecipeIO(recipe, io);
            }
            if (ConfigHolder.INSTANCE.machines.orderedAssemblyLineItems ? !this.consumeOrderedItemInputs(recipe) : !RecipeHelper.handleRecipe((IRecipeCapabilityHolder)this.machine, (GTRecipe)recipe, (IO)io, Map.of(ItemRecipeCapability.CAP, items = recipe.getInputContents((RecipeCapability)ItemRecipeCapability.CAP)), (Map)this.chanceCaches, (boolean)false)) {
                return false;
            }
            if (ConfigHolder.INSTANCE.machines.orderedAssemblyLineFluids) {
                return this.consumeOrderedFluidInputs(recipe);
            }
            List fluids = recipe.getInputContents((RecipeCapability)FluidRecipeCapability.CAP);
            return RecipeHelper.handleRecipe((IRecipeCapabilityHolder)this.machine, (GTRecipe)recipe, (IO)io, Map.of(FluidRecipeCapability.CAP, fluids), (Map)this.chanceCaches, (boolean)false);
        }

        private boolean consumeOrderedItemInputs(GTRecipe recipe) {
            List itemInputs = recipe.inputs.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList());
            if (itemInputs.isEmpty()) {
                return true;
            }
            List<CustomItemStackHandler> machineInputs = this.getMachine().itemStackTransfers;
            if (machineInputs.size() < itemInputs.size()) {
                return false;
            }
            for (int i = 0; i < itemInputs.size(); ++i) {
                CustomItemStackHandler inputSlot = machineInputs.get(i);
                Ingredient recipeInput = (Ingredient)ItemRecipeCapability.CAP.of(((Content)itemInputs.get((int)i)).content);
                boolean tested = false;
                long amount = ItemUtils.getSizedAmount((Ingredient)recipeInput);
                for (int j = 0; j < inputSlot.size; ++j) {
                    ItemStack stack = inputSlot.getStackInSlot(j);
                    if (stack.m_41619_() || !tested && !recipeInput.test(stack)) continue;
                    tested = true;
                    if ((amount -= (long)inputSlot.extractItem(j, MathUtil.saturatedCast((long)amount), false).m_41613_()) <= 0L) break;
                }
                if (amount <= 0L) continue;
                return false;
            }
            return true;
        }

        private boolean consumeOrderedFluidInputs(GTRecipe recipe) {
            List fluidInputs = recipe.inputs.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList());
            if (fluidInputs.isEmpty()) {
                return true;
            }
            List<CustomFluidTank[]> machineInputs = this.getMachine().fluidTankTransfers;
            if (machineInputs.size() < fluidInputs.size()) {
                return false;
            }
            for (int i = 0; i < fluidInputs.size(); ++i) {
                CustomFluidTank[] inputTankArray = machineInputs.get(i);
                FluidIngredient recipeInput = (FluidIngredient)FluidRecipeCapability.CAP.of(((Content)fluidInputs.get((int)i)).content);
                long amountToDrain = recipeInput.getAmount();
                for (CustomFluidTank tankInHatch : inputTankArray) {
                    FluidStack drainedStack;
                    if (!tankInHatch.getFluid().isEmpty() && recipeInput.test(tankInHatch.getFluid()) && (amountToDrain -= (long)(drainedStack = tankInHatch.drain(MathUtil.saturatedCast((long)amountToDrain), IFluidHandler.FluidAction.EXECUTE)).getAmount()) <= 0L) break;
                }
                if (amountToDrain <= 0L) continue;
                return false;
            }
            return true;
        }
    }
}

