/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.data.IdleReason;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DataGeneratorScanned
public final class TreeGrowthSimulator
extends StorageMultiblockMachine {
    @RegisterLanguage(cn="\u4e3b\u4ea7\u7269\u4ea7\u51fa%s%%", en="Main Output %s%%")
    private static final String MAIN = "gtocore.machine.main_output";
    private int output = 1;
    private float speed = 1.0f;

    public TreeGrowthSimulator(MetaMachineBlockEntity holder) {
        super(holder, 1, i -> {
            Item patt0$temp = i.m_41720_();
            if (patt0$temp instanceof IGTTool) {
                IGTTool item = (IGTTool)patt0$temp;
                return item.getToolType() == GTToolType.CHAINSAW_LV || item.getToolType() == GTToolType.AXE;
            }
            return false;
        });
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        ItemStack stack = this.getStorageStack();
        Item item = stack.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool item2 = (IGTTool)item;
            boolean isElectric = item2.isElectric();
            if (isElectric) {
                IElectricItem electricStack = GTCapabilityHelper.getElectricItem((ItemStack)stack);
                if (electricStack == null) {
                    this.setIdleReason(IdleReason.FELLING_TOOL);
                    return null;
                }
                int eu = 256 * (1 << this.tier);
                if (electricStack.getCharge() < (long)eu) {
                    this.setIdleReason(IdleReason.CHARGE);
                    return null;
                }
                electricStack.discharge((long)eu * (1L << this.tier), electricStack.getTier(), true, false, false);
            }
            if (!isElectric || GTValues.RNG.m_188503_(10) == 0) {
                int damage = stack.m_41773_();
                if (damage >= stack.m_41776_()) {
                    this.machineStorage.setStackInSlot(0, ItemStack.f_41583_);
                    this.setIdleReason(IdleReason.FELLING_TOOL);
                    return null;
                }
                int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack) + 1;
                if (GTValues.RNG.m_188502_() % level == 0) {
                    stack.m_41721_(damage + 1);
                }
            }
            recipe.duration = (int)((float)recipe.duration / this.speed);
            if (this.output > 1) {
                List contents = (List)recipe.outputs.get(ItemRecipeCapability.CAP);
                Content content = ((Content)contents.get(0)).copy((RecipeCapability)ItemRecipeCapability.CAP, ContentModifier.multiplier((double)2.0));
                if (contents.size() > 1) {
                    recipe.outputs.put(ItemRecipeCapability.CAP, List.of(content, (Content)contents.get(1)));
                } else {
                    recipe.outputs.put(ItemRecipeCapability.CAP, List.of(content));
                }
            }
            return RecipeModifierFunction.overclocking((MetaMachine)this, (Recipe)recipe);
        }
        this.setIdleReason(IdleReason.FELLING_TOOL);
        return null;
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.onMachineChanged();
    }

    public void onMachineChanged() {
        this.output = 1;
        this.speed = 1.0f;
        Item item = this.getStorageStack().m_41720_();
        if (item instanceof IGTTool) {
            IGTTool item2 = (IGTTool)item;
            GTToolType type = item2.getToolType();
            if (type == GTToolType.CHAINSAW_LV) {
                this.output = 2;
            }
            this.speed = (float)(1.0 + 0.5 * Math.sqrt(((ToolProperty)item2.getMaterial().getProperty(PropertyKey.TOOL)).getHarvestSpeed()));
            this.getRecipeLogic().updateTickSubscription();
        }
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)MAIN, (Object[])new Object[]{this.output * 100}));
        textList.add((Component)Component.m_237110_((String)"jade.horseStat.speed", (Object[])new Object[]{"x " + FormattingUtil.formatNumbers((double)this.speed)}));
    }
}

