/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.fast.fastcollection.O2LOpenCustomCacheHashMap;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.gtocore.common.machine.multiblock.part.ae.MECraftPatternPartMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import com.gtolib.utils.MathUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SuperMolecularAssemblerMachine
extends ElectricMultiblockMachine {
    private final List<MECraftPatternPartMachine> partMachines = new ArrayList<MECraftPatternPartMachine>();

    public SuperMolecularAssemblerMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void onPartScan(@NotNull IMultiPart part) {
        super.onPartScan(part);
        if (part instanceof MECraftPatternPartMachine) {
            MECraftPatternPartMachine machine = (MECraftPatternPartMachine)part;
            this.partMachines.add(machine);
            machine.setOnContentsChanged(() -> ((RecipeLogic)this.getRecipeLogic()).updateTickSubscription());
        }
    }

    public void onStructureFormed() {
        this.partMachines.clear();
        super.onStructureFormed();
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.partMachines.clear();
    }

    private Recipe getRecipe() {
        long maxEUt = this.getOverclockVoltage();
        if (maxEUt == 0L) {
            return null;
        }
        O2LOpenCustomCacheHashMap map = new O2LOpenCustomCacheHashMap((Hash.Strategy)ItemStackHashStrategy.ITEM_AND_TAG);
        for (MECraftPatternPartMachine machine : this.partMachines) {
            for (MECraftPatternPartMachine.InternalSlot inventory : (MECraftPatternPartMachine.InternalSlot[])machine.getInternalInventory()) {
                if (inventory.getAmount() <= 0L) continue;
                map.addTo((Object)inventory.getOutput(), inventory.getAmount());
                inventory.setAmount(0L);
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        long totalEu = map.values().longStream().sum();
        double d = (double)totalEu / (double)maxEUt;
        int limit = this.gtolib$getOCLimit();
        RecipeBuilder builder = this.getRecipeBuilder().EUt(Math.max(1L, d >= (double)limit ? maxEUt : (long)((double)maxEUt * d / (double)limit))).duration((int)Math.max(d, (double)limit));
        for (Object2LongMap.Entry entry : map.object2LongEntrySet()) {
            ItemStack item = (ItemStack)entry.getKey();
            item.m_41764_(MathUtil.saturatedCast((long)entry.getLongValue()));
            builder.output((RecipeCapability)ItemRecipeCapability.CAP, (Object)FastSizedIngredient.create((ItemStack)((ItemStack)entry.getKey()), (long)entry.getLongValue()));
        }
        return builder.buildRawRecipe();
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }
}

