/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.utils.MachineUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class GreenhouseMachine
extends ElectricMultiblockMachine {
    private int SkyLight = 15;

    public GreenhouseMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    private void getGreenhouseLight() {
        BlockPos[] coordinates;
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.SkyLight = 15;
        BlockPos pos = MachineUtils.getOffsetPos((int)1, (int)4, (Direction)this.getFrontFacing(), (BlockPos)this.getPos());
        for (BlockPos i : coordinates = new BlockPos[]{pos, pos.m_7918_(1, 0, 0), pos.m_7918_(1, 0, 1), pos.m_7918_(1, 0, -1), pos.m_7918_(0, 0, 1), pos.m_7918_(0, 0, -1), pos.m_7918_(-1, 0, 0), pos.m_7918_(-1, 0, 1), pos.m_7918_(-1, 0, -1)}) {
            int l = level.m_45517_(LightLayer.SKY, i) - (level.m_46472_() == Level.f_46428_ ? level.m_7445_() : 0);
            if (l >= this.SkyLight) continue;
            this.SkyLight = l;
        }
    }

    protected boolean beforeWorking(Recipe recipe) {
        this.getGreenhouseLight();
        if (this.SkyLight == 0) {
            return false;
        }
        return super.beforeWorking(recipe);
    }

    public boolean onWorking() {
        if (!super.onWorking()) {
            return false;
        }
        if (this.getOffsetTimer() % 20 == 0) {
            this.getGreenhouseLight();
            if (this.SkyLight == 0) {
                this.getRecipeLogic().setProgress(0);
            }
            if (this.SkyLight < 13) {
                this.getRecipeLogic().setProgress(this.getRecipeLogic().getProgress() - 10);
            }
        }
        return true;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        if (this.getOffsetTimer() % 10 == 0) {
            this.getGreenhouseLight();
        }
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.greenhouse.SkyLight", (Object[])new Object[]{this.SkyLight}));
    }
}

