/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.machine.multiblock.part.SensorPartMachine;
import com.gtolib.api.machine.feature.multiblock.IParallelMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.utils.FunctionContainer;
import com.gtolib.utils.MachineUtils;
import com.gtolib.utils.MathUtil;
import com.gtolib.utils.explosion.SphereExplosion;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class FissionReactorMachine
extends ElectricMultiblockMachine
implements IExplosionMachine,
IParallelMachine {
    private static final Fluid DistilledWater = GTMaterials.DistilledWater.getFluid();
    private static final Fluid Steam = GTMaterials.Steam.getFluid();
    private static final Fluid SodiumPotassium = GTMaterials.SodiumPotassium.getFluid();
    private static final Fluid HotSodiumPotassium = GTOMaterials.HotSodiumPotassium.getFluid();
    private static final Fluid SupercriticalSodiumPotassium = GTOMaterials.SupercriticalSodiumPotassium.getFluid();
    @Persisted
    private int heat = 298;
    @Persisted
    private int damaged;
    @Persisted
    private int parallel;
    @Persisted
    private int recipeHeat;
    private int fuel;
    private int cooler;
    private int heatAdjacent = 1;
    private int coolerAdjacent;
    private final ConditionalSubscriptionHandler HeatSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::HeatUpdate, 20, () -> this.isFormed() || this.heat > 298);
    private SensorPartMachine sensorMachine;

    public FissionReactorMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void onPartScan(IMultiPart part) {
        super.onPartScan(part);
        if (this.sensorMachine == null && part instanceof SensorPartMachine) {
            SensorPartMachine sensorPartMachine;
            this.sensorMachine = sensorPartMachine = (SensorPartMachine)part;
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.fuel = 0;
        this.cooler = 0;
        this.heatAdjacent = 1;
        this.coolerAdjacent = 0;
        FunctionContainer container = (FunctionContainer)this.getMultiblockState().getMatchContext().get((Object)"fissionComponent");
        if (container != null) {
            this.fuel = ((int[])container.getValue())[0];
            this.cooler = ((int[])container.getValue())[1];
            this.heatAdjacent = ((int[])container.getValue())[2] / 2 + 1;
            this.coolerAdjacent = ((int[])container.getValue())[3] / 2;
        }
        this.HeatSubs.initialize(this.getLevel());
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.fuel = 0;
        this.cooler = 0;
        this.sensorMachine = null;
    }

    public void onRecipeFinish() {
        this.parallel = 0;
        this.recipeHeat = 0;
    }

    public void doExplosion(BlockPos pos, float explosionPower) {
        MultiblockControllerMachine machine = this.self();
        Level level = machine.getLevel();
        if (level != null) {
            level.m_7471_(machine.getPos(), false);
            SphereExplosion.explosion((BlockPos)pos, (Level)level, (int)((int)Math.sqrt(explosionPower)), (boolean)false, (boolean)true);
        }
    }

    private void HeatUpdate() {
        this.HeatSubs.updateSubscription();
        if (this.getRecipeLogic().isWorking()) {
            boolean isCooler = false;
            int required = this.recipeHeat * this.parallel * this.heat / 1500;
            if (required > 0) {
                long[] a2 = this.getFluidAmount(new Fluid[]{DistilledWater, SodiumPotassium});
                int capacity = (int)Math.min(Math.max(a2[0] / 800L, a2[1] / 20L), (long)this.cooler - (long)this.coolerAdjacent / 3L << 3);
                if (capacity - required >= 0) {
                    if (this.inputFluid(DistilledWater, (long)capacity * 800L)) {
                        isCooler = this.outputFluid(Steam, (int)((double)(capacity * 800) * (this.heat > 373 ? 160.0 : 160.0 / Math.pow(1.4, 373 - this.heat))));
                    } else if (this.inputFluid(SodiumPotassium, (long)capacity * 20L)) {
                        isCooler = this.heat > 825 ? this.outputFluid(SupercriticalSodiumPotassium, (long)capacity * 20L) : this.outputFluid(HotSodiumPotassium, (long)capacity * 20L);
                    }
                }
                if (isCooler) {
                    int progress = this.getProgress() + 20 * capacity / required;
                    int surplusProgress = progress - this.getMaxProgress();
                    if (surplusProgress > 0) {
                        if (this.heat > 298) {
                            this.heat -= surplusProgress / 20;
                        }
                    } else {
                        this.getRecipeLogic().setProgress(progress);
                    }
                }
            }
            if (!isCooler) {
                this.heat += this.recipeHeat * this.heatAdjacent;
            }
        } else if (this.heat > 298) {
            --this.heat;
        } else if (this.damaged > 0) {
            --this.damaged;
        }
        if (this.heat > 1500) {
            if (this.damaged > 99) {
                this.doExplosion(MachineUtils.getOffsetPos((int)4, (int)4, (Direction)this.getFrontFacing(), (BlockPos)this.getPos()), this.fuel);
            } else {
                this.damaged += Math.max(1, this.heatAdjacent / 6);
            }
        }
        if (this.sensorMachine != null) {
            this.sensorMachine.update(this.heat);
        }
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        if (this.fuel > 1) {
            long maxContentParallel = ParallelLogic.getMaxContentParallel((IRecipeLogicMachine)this, (Recipe)recipe);
            if (maxContentParallel == 0L) {
                return null;
            }
            if (maxContentParallel > 1L) {
                recipe.modifier(ContentModifier.multiplier((double)Math.min((long)this.fuel, maxContentParallel)), false);
            }
        }
        this.parallel = MathUtil.saturatedCast((long)recipe.parallels);
        this.recipeHeat = recipe.data.m_128451_("FRheat");
        return recipe;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.fission_reactor.fuel", (Object[])new Object[]{this.fuel, this.heatAdjacent - 1}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.fission_reactor.cooler", (Object[])new Object[]{this.cooler, this.coolerAdjacent}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.fission_reactor.heat", (Object[])new Object[]{this.heat}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.fission_reactor.damaged", (Object[])new Object[]{this.damaged}).m_130946_("%"));
    }

    public long getMaxParallel() {
        return this.fuel;
    }
}

