/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.fast.fastcollection.OpenCacheHashSet;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gtolib.api.machine.feature.multiblock.IFluidRendererMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DissolvingTankMachine
extends ElectricMultiblockMachine
implements IFluidRendererMachine {
    @DescSynced
    @RequireRerender
    private final Set<BlockPos> fluidBlockOffsets = new OpenCacheHashSet();
    @DescSynced
    private Fluid cachedFluid;

    public DissolvingTankMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    protected boolean beforeWorking(@NotNull Recipe recipe) {
        this.cachedFluid = IFluidRendererMachine.getFluid((GTRecipe)recipe);
        return super.beforeWorking(recipe);
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        if (!this.fluidBlockOffsets.isEmpty()) {
            return;
        }
        BlockPos pos = MachineUtils.getOffsetPos((int)2, (int)1, (Direction)this.getFrontFacing(), (BlockPos)this.getPos());
        for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    this.fluidBlockOffsets.add(pos.m_7918_(i, j, k).m_121996_((Vec3i)this.getPos()));
                }
            }
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.fluidBlockOffsets.clear();
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        if (this.getSubFormedAmount() > 0) {
            return RecipeModifierFunction.overclocking((MetaMachine)this, (Recipe)RecipeModifierFunction.hatchParallel((MetaMachine)this, (Recipe)recipe));
        }
        List fluidList = recipe.inputs.getOrDefault(FluidRecipeCapability.CAP, null);
        FluidStack fluidStack1 = ((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)fluidList.get(0)).getContent())).getStacks()[0];
        FluidStack fluidStack2 = ((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)fluidList.get(1)).getContent())).getStacks()[0];
        long[] a2 = this.getFluidAmount(new Fluid[]{fluidStack1.getFluid(), fluidStack2.getFluid()});
        if (a2[1] > 0L && (recipe = RecipeModifierFunction.overclocking((MetaMachine)this, (Recipe)RecipeModifierFunction.hatchParallel((MetaMachine)this, (Recipe)recipe))) != null) {
            if ((double)a2[0] / (double)a2[1] != (double)fluidStack1.getAmount() / (double)fluidStack2.getAmount()) {
                recipe.outputs.clear();
            }
            return recipe;
        }
        return null;
    }

    public Set<BlockPos> getFluidBlockOffsets() {
        return this.fluidBlockOffsets;
    }

    public Fluid getCachedFluid() {
        return this.cachedFluid;
    }
}

