/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.machine.multiblock.part.BlockBusPartMachine;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public final class BlockConversionRoomMachine
extends StorageMultiblockMachine {
    private static final List<int[]> poses1;
    private static final List<int[]> poses2;
    public static final Map<Block, Block> COV_RECIPE;
    private final int am;
    private final List<int[]> poses;
    private BlockBusPartMachine blockBusPartMachine;

    public BlockConversionRoomMachine(MetaMachineBlockEntity holder, boolean isLarge) {
        super(holder, 1, i -> i.m_41720_() == GTOItems.CONVERSION_SIMULATE_CARD.get());
        this.am = isLarge ? 64 : 4;
        this.poses = isLarge ? poses2 : poses1;
    }

    public void onPartScan(@NotNull IMultiPart part) {
        super.onPartScan(part);
        if (part instanceof BlockBusPartMachine) {
            BlockBusPartMachine busPartMachine;
            this.blockBusPartMachine = busPartMachine = (BlockBusPartMachine)part;
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.blockBusPartMachine = null;
    }

    public boolean onWorking() {
        block4: {
            int amount;
            block5: {
                if (!super.onWorking()) {
                    return false;
                }
                if (this.getOffsetTimer() % 20 != 0) break block4;
                amount = this.getTier() * this.am - 7;
                if (this.blockBusPartMachine == null || this.getStorageStack().m_41720_() != GTOItems.CONVERSION_SIMULATE_CARD.get()) break block5;
                CustomItemStackHandler stackTransfer = this.blockBusPartMachine.getInventory().storage;
                int a2 = amount;
                int slots = stackTransfer.getSlots();
                for (int i = 0; a2 > 0 && i < slots; ++i) {
                    BlockItem blockItem;
                    ItemStack itemStack = stackTransfer.getStackInSlot(i);
                    Item item = itemStack.m_41720_();
                    if (!(item instanceof BlockItem) || !COV_RECIPE.containsKey((blockItem = (BlockItem)item).m_40614_())) continue;
                    int count = itemStack.m_41613_();
                    a2 -= count;
                    stackTransfer.setStackInSlot(i, new ItemStack((ItemLike)COV_RECIPE.get(blockItem.m_40614_()).m_5456_(), count));
                }
                break block4;
            }
            Level level = this.getLevel();
            if (level == null) break block4;
            int[] pos = new int[]{};
            for (int i = 0; i < amount; ++i) {
                int[] pos_0 = this.poses.get((int)(Math.random() * (double)this.poses.size()));
                if (!Arrays.equals(pos_0, pos)) {
                    pos = pos_0;
                    BlockPos blockPos = this.getPos().m_7918_(pos[0], pos[1], pos[2]);
                    Block block = level.m_8055_(blockPos).m_60734_();
                    if (!COV_RECIPE.containsKey(block)) continue;
                    level.m_46597_(blockPos, COV_RECIPE.get(block).m_49966_());
                    continue;
                }
                --i;
            }
        }
        return true;
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.block_conversion_room.am", (Object[])new Object[]{this.getTier() * this.am - 7}));
    }

    @Nullable
    private Recipe getRecipe() {
        Recipe recipe = this.getRecipeBuilder().duration(400).EUt(this.getOverclockVoltage()).buildRawRecipe();
        if (RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
            return recipe;
        }
        return null;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe, true);
    }

    static {
        int k;
        int j;
        int i;
        poses1 = new ArrayList<int[]>();
        poses2 = new ArrayList<int[]>();
        for (i = -2; i <= 2; ++i) {
            for (j = -1; j >= -5; --j) {
                k = -2;
                while (k <= 2) {
                    poses1.add(new int[]{i, j, k++});
                }
            }
        }
        for (i = -4; i <= 4; ++i) {
            for (j = -1; j >= -7; --j) {
                k = -4;
                while (k <= 4) {
                    poses2.add(new int[]{i, j, k++});
                }
            }
        }
        ImmutableMap.Builder covRecipe = ImmutableMap.builder();
        covRecipe.put((Object)Blocks.f_50453_, (Object)((Block)GTOBlocks.ESSENCE_BLOCK.get()));
        covRecipe.put((Object)Blocks.f_49999_, (Object)Blocks.f_50695_);
        covRecipe.put((Object)Blocks.f_50001_, (Object)Blocks.f_50686_);
        covRecipe.put((Object)ChemicalHelper.getBlock((TagPrefix)TagPrefix.block, (Material)GTMaterials.Calcium), (Object)Blocks.f_50453_);
        covRecipe.put((Object)Blocks.f_152544_, (Object)Blocks.f_220855_);
        covRecipe.put((Object)Blocks.f_50440_, (Object)Blocks.f_152544_);
        covRecipe.put((Object)((Block)GTOBlocks.INFUSED_OBSIDIAN.get()), (Object)((Block)GTOBlocks.DRACONIUM_BLOCK_CHARGED.get()));
        covRecipe.put((Object)((Block)ModBlocks.ORGANIC_COMPOST.get()), (Object)((Block)ModBlocks.RICH_SOIL.get()));
        COV_RECIPE = covRecipe.build();
    }
}

