/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.monitor;

import com.fast.fastcollection.OpenCacheHashSet;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gtocore.client.renderer.machine.MonitorRenderer;
import com.gtocore.common.machine.monitor.DisplayComponentList;
import com.gtocore.common.machine.monitor.IDisplayComponent;
import com.gtocore.common.machine.monitor.IInformationProvider;
import com.gtocore.config.GTOConfig;
import com.gtolib.api.network.NetworkPack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Manager {
    private static final Queue<Runnable> Loading = new LinkedList<Runnable>();
    private static final Map<GridFacedPoint, GridNetwork> gridToNetwork = new ConcurrentHashMap<GridFacedPoint, GridNetwork>();
    private static final NetworkPack MONITOR_CHANGED = NetworkPack.registerS2C((String)"monitorUpdateC2S", (p, buf) -> {
        CompoundTag tag = new CompoundTag();
        AtomicInteger i = new AtomicInteger(0);
        gridToNetwork.values().forEach(network -> {
            CompoundTag networkTag = network.serializeNBT();
            tag.m_128365_(String.valueOf(i.getAndIncrement()), (Tag)networkTag);
        });
        buf.m_130079_(tag);
    }, (p, b2) -> {
        CompoundTag monitorData = b2.m_130260_();
        if (monitorData != null && p.m_9236_().f_46443_) {
            Manager.onClientReceived(monitorData);
        }
    });

    private Manager() {
    }

    private static void requireQueue(Runnable runnable) {
        if (!Loading.contains(runnable)) {
            Loading.add(runnable);
        }
    }

    private static void poll() {
        while (!Loading.isEmpty()) {
            Loading.poll().run();
        }
    }

    static void addBlock(MetaMachine be) {
        Manager.addBlock(be.getBlockState(), be.getPos(), be.getLevel(), be.isPainted() ? be.getPaintingColor() : -1);
    }

    public static Direction getFrontFacing(BlockState state) {
        Block var3 = state.m_60734_();
        if (var3 instanceof MetaMachineBlock) {
            MetaMachineBlock machineBlock = (MetaMachineBlock)var3;
            return machineBlock.getFrontFacing(state);
        }
        throw new IllegalArgumentException("BlockState is not a MetaMachineBlock: " + String.valueOf(var3));
    }

    static void addBlock(BlockState blockState, BlockPos pos, @Nullable Level level, int color) {
        if (level == null || level.m_5776_() || !level.m_46749_(pos)) {
            return;
        }
        Manager.requireQueue(() -> {
            GridNetwork network = GridNetwork.fromBlock(Manager.getFrontFacing(blockState), pos, (ResourceKey<Level>)level.m_46472_(), color);
            network.merge();
            Manager.broadcast(level.m_7654_());
        });
    }

    static void addBlock(BlockState blockState, BlockPos pos, @Nullable Level level) {
        Manager.addBlock(blockState, pos, level, -1);
    }

    static void removeBlock(BlockState pState, BlockPos pPos, @Nullable Level pLevel) {
        if (pLevel != null && !pLevel.f_46443_) {
            Manager.requireQueue(() -> {
                Direction facing = Manager.getFrontFacing(pState);
                GridFacedPoint point = GridFacing.of(facing, pLevel, GridFacing.getThirdValue(facing, pPos)).getPoint(pPos);
                GridNetwork network = gridToNetwork.get(point);
                if (network != null) {
                    network.split(point);
                }
                Manager.broadcast(pLevel.m_7654_());
            });
        }
    }

    static void removeBlock(MetaMachine be) {
        if (be.getLevel() != null && !be.getLevel().m_5776_()) {
            Manager.removeBlock(be.getBlockState(), be.getPos(), be.getLevel());
        }
    }

    static void updateAllNetworkDisplayMachines(Level level) {
        if (level == null) {
            return;
        }
        MonitorRenderer.gridToNetworkCLIENT.values().forEach(network -> network.refreshDisplayingMachine(level));
    }

    private static void clearCache(Level level) {
        Map<GridFacedPoint, GridNetwork> grid2Network = level.f_46443_ ? MonitorRenderer.gridToNetworkCLIENT : gridToNetwork;
        grid2Network.entrySet().removeIf(entry -> {
            GridFacedPoint point = (GridFacedPoint)entry.getKey();
            return point.facing.level != level.m_46472_() || !level.m_46749_(point.toBlockPos());
        });
    }

    private static void debugCheckValid() {
        for (GridNetwork network : gridToNetwork.values()) {
            network.points().forEach(point -> {
                GridNetwork otherNetwork = gridToNetwork.get(point);
                if (otherNetwork != network) {
                    throw new IllegalStateException("GridNetwork " + String.valueOf(network) + " contains point " + String.valueOf(point) + " which belongs to another network: " + String.valueOf(otherNetwork));
                }
            });
        }
    }

    private static void broadcast(MinecraftServer server) {
        MONITOR_CHANGED.send(new Object[]{server});
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onClientReceived(CompoundTag tag) {
        MonitorRenderer.gridToNetworkCLIENT.clear();
        for (String key : tag.m_128431_()) {
            CompoundTag networkTag = tag.m_128469_(key);
            GridNetwork network = GridNetwork.deserializeNBT(networkTag);
            for (GridFacedPoint point : network.points()) {
                MonitorRenderer.gridToNetworkCLIENT.put(point, network);
            }
        }
    }

    public static class GridNetwork {
        int fromX;
        int toX;
        int fromY;
        int toY;
        int color = -1;
        final GridFacing facing;
        @Nullable
        GridListener listener;
        private static final Lock gridToNetworkLock = new ReentrantLock();
        private final List<IInformationProvider> informationProviders = new ArrayList<IInformationProvider>();
        private final List<IDisplayComponent> displayComponentCache = new ArrayList<IDisplayComponent>();
        private long lastRefreshTime = 0L;

        private GridNetwork(GridFacing facing) {
            this.facing = facing;
        }

        static GridNetwork fromBlock(Direction facing, BlockPos pos, ResourceKey<Level> level, int color) {
            GridFacing axis = GridFacing.of(facing, level, GridFacing.getThirdValue(facing, pos));
            GridFacedPoint point = axis.getPoint(pos);
            if (gridToNetwork.containsKey(point)) {
                return gridToNetwork.get(point);
            }
            return GridNetwork.createSingleBlockNetwork(facing, pos, level, color);
        }

        Set<GridFacedPoint> points() {
            OpenCacheHashSet points = new OpenCacheHashSet();
            for (int i = this.fromX; i <= this.toX; ++i) {
                for (int j = this.fromY; j <= this.toY; ++j) {
                    points.add(new GridFacedPoint(this.facing, i, j));
                }
            }
            return points;
        }

        static GridNetwork createSingleBlockNetwork(Direction facing, BlockPos pos, ResourceKey<Level> level, int color) {
            GridFacing axis = GridFacing.of(facing, level, GridFacing.getThirdValue(facing, pos));
            GridFacedPoint point = axis.getPoint(pos);
            if (gridToNetwork.containsKey(point)) {
                throw new IllegalStateException("GridNetwork already exists for point: " + String.valueOf(point));
            }
            GridNetwork network = new GridNetwork(axis);
            network.fromX = point.x;
            network.toX = point.x;
            network.fromY = point.y;
            network.toY = point.y;
            network.color = color;
            GridNetwork.put(point, network);
            return network;
        }

        @OnlyIn(value=Dist.CLIENT)
        @Nullable
        public static GridNetwork fromClientBlock(Direction facing, BlockPos pos, Level level) {
            GridFacing axis = GridFacing.of(facing, level, GridFacing.getThirdValue(facing, pos));
            GridFacedPoint point = axis.getPoint(pos);
            if (MonitorRenderer.gridToNetworkCLIENT.containsKey(point)) {
                return MonitorRenderer.gridToNetworkCLIENT.get(point);
            }
            return null;
        }

        public void setListener(@Nullable GridListener listener) {
            this.listener = listener;
        }

        public int width() {
            return this.toX - this.fromX + 1;
        }

        public int height() {
            return this.toY - this.fromY + 1;
        }

        public int width3D() {
            BlockPos blockPos1 = this.getOriginPos();
            BlockPos blockPos2 = new GridFacedPoint(this.facing, this.toX, this.toY).toBlockPos();
            return this.facing.facing.m_122434_() == Direction.Axis.X ? Math.abs(blockPos1.m_123343_() - blockPos2.m_123343_()) + 1 : Math.abs(blockPos1.m_123341_() - blockPos2.m_123341_()) + 1;
        }

        public int height3D() {
            BlockPos blockPos1 = this.getOriginPos();
            BlockPos blockPos2 = new GridFacedPoint(this.facing, this.toX, this.toY).toBlockPos();
            return this.facing.facing.m_122434_() == Direction.Axis.Y ? Math.abs(blockPos1.m_123341_() - blockPos2.m_123341_()) + 1 : Math.abs(blockPos1.m_123342_() - blockPos2.m_123342_()) + 1;
        }

        public BlockPos getOriginPos() {
            return new GridFacedPoint(this.facing, this.fromX, this.fromY).toBlockPos();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void merge() {
            Map<GridFacedPoint, GridNetwork> map = gridToNetwork;
            synchronized (map) {
                boolean success;
                boolean bl = success = this.tryMerge(Direction2D.UP) || this.tryMerge(Direction2D.DOWN) || this.tryMerge(Direction2D.LEFT) || this.tryMerge(Direction2D.RIGHT);
                while (success) {
                    success = this.tryMerge(Direction2D.UP) || this.tryMerge(Direction2D.DOWN) || this.tryMerge(Direction2D.LEFT) || this.tryMerge(Direction2D.RIGHT);
                }
            }
        }

        private boolean canMerge(GridNetwork other, Direction2D facing2D) {
            int maxMonitorSize = GTOConfig.INSTANCE.maxMonitorSize;
            return other != null && other.facing == this.facing && other.color == this.color && (facing2D.isHorizontal ? other.height() == this.height() && other.width() + this.width() <= maxMonitorSize : other.width() == this.width() && other.height() + this.height() <= maxMonitorSize);
        }

        private boolean tryMerge(Direction2D direction) {
            boolean canMerge;
            Predicate<GridFacedPoint> pointPredicate = switch (direction.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> point -> point.y == this.toY;
                case 1 -> point -> point.y == this.fromY;
                case 2 -> point -> point.x == this.fromX;
                case 3 -> point -> point.x == this.toX;
            };
            List<GridFacedPoint> shiftedPoints = this.points().stream().filter(pointPredicate).map(point -> point.shift(direction)).toList();
            if (shiftedPoints.isEmpty()) {
                return false;
            }
            GridNetwork otherNetwork = gridToNetwork.get(shiftedPoints.getFirst());
            boolean bl = canMerge = shiftedPoints.stream().allMatch(newPoint -> gridToNetwork.get(newPoint) == otherNetwork) && this.canMerge(otherNetwork, direction);
            if (canMerge) {
                int fromX1 = Math.min(this.fromX, otherNetwork.fromX);
                int toX1 = Math.max(this.toX, otherNetwork.toX);
                int fromY1 = Math.min(this.fromY, otherNetwork.fromY);
                int toY1 = Math.max(this.toY, otherNetwork.toY);
                if (this.listener != null) {
                    this.listener.onGridChanged(this, otherNetwork);
                }
                this.fromX = fromX1;
                this.toX = toX1;
                this.fromY = fromY1;
                this.toY = toY1;
                for (GridFacedPoint point2 : this.points()) {
                    GridNetwork.put(point2, this);
                }
                if (GTOConfig.INSTANCE.dev) {
                    if (gridToNetwork.keySet().stream().filter(p -> p.facing == this.facing && p.x >= this.fromX && p.x <= this.toX && p.y >= this.fromY && p.y <= this.toY).anyMatch(p -> gridToNetwork.get(p) != this)) {
                        throw new IllegalStateException("GridNetwork still has points after split: " + String.valueOf(otherNetwork));
                    }
                    Manager.debugCheckValid();
                }
            }
            return canMerge;
        }

        private static GridNetwork put(GridFacedPoint point, GridNetwork network) {
            gridToNetworkLock.lock();
            try {
                GridNetwork gridNetwork = gridToNetwork.put(point, network);
                return gridNetwork;
            }
            finally {
                gridToNetworkLock.unlock();
            }
        }

        private static GridNetwork remove(GridFacedPoint point) {
            gridToNetworkLock.lock();
            try {
                GridNetwork gridNetwork = gridToNetwork.remove(point);
                return gridNetwork;
            }
            finally {
                gridToNetworkLock.unlock();
            }
        }

        private void split(GridFacedPoint point) {
            GridNetwork.remove(point);
            if (this.points().size() <= 1) {
                return;
            }
            int fromX = this.fromX;
            int toX = this.toX;
            int fromY = this.fromY;
            int toY = this.toY;
            ArrayList<GridFacedPoint> created = new ArrayList<GridFacedPoint>();
            ArrayList<GridFacedPoint> oldPoints = new ArrayList<GridFacedPoint>(this.points());
            for (Direction2D direction : Direction2D.values()) {
                GridFacedPoint shifted = point.shift(direction);
                if (!oldPoints.contains(shifted)) continue;
                int newFromX = fromX;
                int newToX = toX;
                int newFromY = fromY;
                int newToY = toY;
                switch (direction.ordinal()) {
                    case 0: {
                        newFromY = shifted.y;
                        break;
                    }
                    case 1: {
                        newToY = shifted.y;
                        break;
                    }
                    case 2: {
                        newToX = shifted.x;
                        newFromY = shifted.y;
                        newToY = shifted.y;
                        break;
                    }
                    case 3: {
                        newFromX = shifted.x;
                        newFromY = shifted.y;
                        newToY = shifted.y;
                    }
                }
                GridNetwork network1 = new GridNetwork(this.facing);
                network1.fromX = newFromX;
                network1.toX = newToX;
                network1.fromY = newFromY;
                network1.toY = newToY;
                network1.points().forEach(newPoint -> GridNetwork.put(newPoint, network1));
                if (this.listener != null) {
                    this.listener.onGridChanged(network1, null);
                }
                created.add(shifted);
            }
            if (GTOConfig.INSTANCE.dev) {
                if (gridToNetwork.keySet().stream().anyMatch(p -> gridToNetwork.get(p) == this)) {
                    throw new IllegalStateException("GridNetwork still has points after split: " + String.valueOf(this));
                }
                Manager.debugCheckValid();
            }
            for (GridFacedPoint p2 : created) {
                gridToNetwork.get(p2).merge();
            }
        }

        public AABB aabb() {
            BlockPos pointFrom = new GridFacedPoint(this.facing, this.fromX, this.fromY).toBlockPos();
            BlockPos pointTo = new GridFacedPoint(this.facing, this.toX, this.toY).toBlockPos();
            return new AABB((double)pointFrom.m_123341_(), (double)pointFrom.m_123342_(), (double)pointFrom.m_123343_(), (double)(pointTo.m_123341_() + 1), (double)(pointTo.m_123342_() + 1), (double)(pointTo.m_123343_() + 1));
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("fromX", this.fromX);
            tag.m_128405_("toX", this.toX);
            tag.m_128405_("fromY", this.fromY);
            tag.m_128405_("toY", this.toY);
            tag.m_128405_("facing", this.facing.facing.ordinal());
            tag.m_128405_("theThirdValue", this.facing.theThirdValue);
            tag.m_128359_("level", this.facing.level().m_135782_().toString());
            return tag;
        }

        static GridNetwork deserializeNBT(CompoundTag tag) {
            int fromX = tag.m_128451_("fromX");
            int toX = tag.m_128451_("toX");
            int fromY = tag.m_128451_("fromY");
            int toY = tag.m_128451_("toY");
            Direction facingDirection = Direction.values()[tag.m_128451_("facing")];
            int theThirdValue = tag.m_128451_("theThirdValue");
            ResourceKey level = Optional.of(ResourceLocation.parse((String)tag.m_128461_("level"))).map(rl -> ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)rl)).orElseThrow(() -> new IllegalArgumentException("Invalid level dimension: " + tag.m_128461_("level")));
            GridFacing facing = GridFacing.of(facingDirection, (ResourceKey<Level>)level, theThirdValue);
            GridNetwork network = new GridNetwork(facing);
            network.fromX = fromX;
            network.toX = toX;
            network.fromY = fromY;
            network.toY = toY;
            return network;
        }

        private void refreshDisplayingMachine(Level level) {
            if (level == null) {
                return;
            }
            if (level.m_46467_() - this.lastRefreshTime >= 10L) {
                this.lastRefreshTime = level.m_46467_();
                this.informationProviders.clear();
                for (GridFacedPoint point : this.points()) {
                    MetaMachineBlockEntity be;
                    MetaMachine metaMachine;
                    BlockEntity blockEntity = level.m_7702_(point.toBlockPos());
                    if (!(blockEntity instanceof MetaMachineBlockEntity) || !((metaMachine = (be = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof IInformationProvider)) continue;
                    IInformationProvider provider = (IInformationProvider)metaMachine;
                    this.informationProviders.add(provider);
                }
                this.displayComponentCache.clear();
                this.informationProviders.stream().sorted(Comparator.comparingLong(IInformationProvider::getPriority).reversed()).map(IInformationProvider::provideInformation).map(DisplayComponentList::sortInner).forEachOrdered(this.displayComponentCache::addAll);
            }
        }

        @NotNull
        public List<IDisplayComponent> getForDisplay() {
            return new ArrayList<IDisplayComponent>(this.displayComponentCache);
        }
    }

    public record GridFacedPoint(GridFacing facing, int x, int y) {
        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridFacedPoint that = (GridFacedPoint)o;
            return this.x() == that.x() && this.y() == that.y() && Objects.equals(this.facing(), that.facing());
        }

        @Override
        public int hashCode() {
            return (this.facing().hashCode() * 31 + this.x()) * 1048575 + this.y();
        }

        @Contract(value="_, _ -> new")
        private GridFacedPoint shift(int dx, int dy) {
            return new GridFacedPoint(this.facing(), this.x() + dx, this.y() + dy);
        }

        @Contract(value="_ -> new")
        private GridFacedPoint shift(Direction2D direction) {
            return switch (direction.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.shift(0, 1);
                case 1 -> this.shift(0, -1);
                case 2 -> this.shift(-1, 0);
                case 3 -> this.shift(1, 0);
            };
        }

        private BlockPos toBlockPos() {
            return switch (this.facing.facing.m_122434_()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.Y -> new BlockPos(this.y, this.facing.theThirdValue, this.x);
                case Direction.Axis.X -> new BlockPos(this.facing.theThirdValue, this.x, this.y);
                case Direction.Axis.Z -> new BlockPos(this.x, this.y, this.facing.theThirdValue);
            };
        }
    }

    record GridFacing(Direction facing, ResourceKey<Level> level, int theThirdValue) {
        private static final Map<Long, GridFacing> GRID_AXES = new ConcurrentHashMap<Long, GridFacing>();

        static GridFacing of(Direction facing, Level level, int theThirdValue) {
            return GridFacing.of(facing, (ResourceKey<Level>)level.m_46472_(), theThirdValue);
        }

        static GridFacing of(Direction facing, ResourceKey<Level> level, int theThirdValue) {
            GridFacing gridFacing = new GridFacing(facing, level, theThirdValue);
            long key = gridFacing.hashCode();
            return GRID_AXES.computeIfAbsent(key, k -> gridFacing);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridFacing gridFacing = (GridFacing)o;
            return Objects.equals(this.level(), gridFacing.level()) && this.facing() == gridFacing.facing() && this.theThirdValue() == gridFacing.theThirdValue();
        }

        @Override
        public int hashCode() {
            return (this.facing().ordinal() * 31 + this.level().hashCode()) * 1048575 + this.theThirdValue();
        }

        static int getThirdValue(Direction facing, BlockPos pos) {
            return switch (facing.m_122434_()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> pos.m_123341_();
                case Direction.Axis.Y -> pos.m_123342_();
                case Direction.Axis.Z -> pos.m_123343_();
            };
        }

        GridFacedPoint getPoint(BlockPos pos) {
            switch (this.facing.m_122434_()) {
                case X: {
                    return new GridFacedPoint(this, pos.m_123342_(), pos.m_123343_());
                }
                case Y: {
                    return new GridFacedPoint(this, pos.m_123343_(), pos.m_123341_());
                }
                case Z: {
                    return new GridFacedPoint(this, pos.m_123341_(), pos.m_123342_());
                }
            }
            throw new IllegalArgumentException("Unsupported Direction Axis: " + String.valueOf(this.facing.m_122434_()));
        }
    }

    public static enum MonitorCTM {
        NONE,
        SINGLE_ROW_LEFT,
        SINGLE_ROW_CENTER,
        SINGLE_ROW_RIGHT,
        SINGLE_COLUMN_TOP,
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        SINGLE_COLUMN_CENTER,
        LEFT,
        CENTER,
        RIGHT,
        SINGLE_COLUMN_BOTTOM,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT;

        private final int u = this.ordinal() % 4 << 4;
        private final int v = this.ordinal() / 4 << 4;

        @OnlyIn(value=Dist.CLIENT)
        @NotNull
        public static MonitorCTM getConnection(Direction facing, BlockPos pos, @Nullable Level level) {
            if (level == null) {
                return NONE;
            }
            GridFacing axis = GridFacing.of(facing, level, GridFacing.getThirdValue(facing, pos));
            GridFacedPoint point = axis.getPoint(pos);
            GridNetwork network = MonitorRenderer.gridToNetworkCLIENT.get(point);
            if (network == null) {
                return NONE;
            }
            ToIntFunction<BlockPos> mappingX = pos0 -> {
                switch (facing) {
                    case NORTH: {
                        return -pos0.m_123341_();
                    }
                    case SOUTH: {
                        return pos0.m_123341_();
                    }
                    case WEST: {
                        return pos0.m_123343_();
                    }
                    case EAST: {
                        return -pos0.m_123343_();
                    }
                }
                throw new IllegalArgumentException("Vertical Direction: " + String.valueOf(facing) + "is not supported yet");
            };
            int x = mappingX.applyAsInt(point.toBlockPos());
            int y = point.toBlockPos().m_123342_();
            BlockPos topLeft = new GridFacedPoint(axis, network.fromX, network.fromY).toBlockPos();
            BlockPos topRight = new GridFacedPoint(axis, network.toX, network.toY).toBlockPos();
            int fromX = Stream.of(topLeft, topRight).mapToInt(mappingX).min().orElse(network.fromX);
            int toX = Stream.of(topLeft, topRight).mapToInt(mappingX).max().orElse(network.toX);
            int fromY = Stream.of(topLeft, topRight).mapToInt(Vec3i::m_123342_).max().orElse(network.fromY);
            int toY = Stream.of(topLeft, topRight).mapToInt(Vec3i::m_123342_).min().orElse(network.toY);
            int width = toX - fromX + 1;
            int height = toY - fromY + 1;
            if (height == 1) {
                if (width == 1) {
                    return NONE;
                }
                if (x == fromX) {
                    return SINGLE_ROW_LEFT;
                }
                if (x == toX) {
                    return SINGLE_ROW_RIGHT;
                }
                return SINGLE_ROW_CENTER;
            }
            if (width == 1) {
                if (y == fromY) {
                    return SINGLE_COLUMN_TOP;
                }
                if (y == toY) {
                    return SINGLE_COLUMN_BOTTOM;
                }
                return SINGLE_COLUMN_CENTER;
            }
            if (x == fromX && y == fromY) {
                return TOP_LEFT;
            }
            if (x == toX && y == fromY) {
                return TOP_RIGHT;
            }
            if (x == fromX && y == toY) {
                return BOTTOM_LEFT;
            }
            if (x == toX && y == toY) {
                return BOTTOM_RIGHT;
            }
            if (y == fromY) {
                return TOP;
            }
            if (y == toY) {
                return BOTTOM;
            }
            if (x == fromX) {
                return LEFT;
            }
            if (x == toX) {
                return RIGHT;
            }
            return CENTER;
        }

        @Generated
        public int getU() {
            return this.u;
        }

        @Generated
        public int getV() {
            return this.v;
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    static class Factory {
        Factory() {
        }

        @SubscribeEvent
        public static void onServerStopped(ServerStoppedEvent event) {
            gridToNetwork.clear();
            Loading.clear();
            GridFacing.GRID_AXES.clear();
        }

        @SubscribeEvent
        public static void onWorldUnload(LevelEvent.Unload event) {
            Manager.clearCache((Level)event.getLevel());
            Loading.clear();
        }

        @SubscribeEvent
        public static void onLoad(LevelEvent.Load event) {
            Manager.clearCache((Level)event.getLevel());
        }

        @SubscribeEvent
        public static void onSave(LevelEvent.Save event) {
        }

        @SubscribeEvent
        public static void onTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                Manager.poll();
            }
        }

        @SubscribeEvent
        public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                Manager.broadcast(sp.m_20194_());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                Manager.broadcast(sp.m_20194_());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                Manager.broadcast(sp.m_20194_());
            }
        }
    }

    @FunctionalInterface
    public static interface GridListener {
        public void onGridChanged(GridNetwork var1, @Nullable GridNetwork var2);
    }

    static enum Direction2D {
        UP(false, true),
        DOWN(false, false),
        LEFT(true, false),
        RIGHT(true, true);

        final boolean isHorizontal;
        final boolean isPositive;

        private Direction2D(boolean isHorizontal, boolean isPositive) {
            this.isHorizontal = isHorizontal;
            this.isPositive = isPositive;
        }
    }
}

