/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.monitor;

import appeng.api.networking.IManagedGridNode;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.integration.ae2.machine.feature.IGridConnectedMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.GridNodeHolder;
import com.gtocore.common.machine.monitor.AbstractInfoProviderMonitor;
import com.gtocore.common.machine.monitor.DisplayComponentList;
import com.gtocore.common.machine.monitor.DisplayRegistry;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAEInfoMonitor
extends AbstractInfoProviderMonitor
implements IGridConnectedMachine {
    @DescSynced
    @NotNull
    protected State state = State.NO_GRID;
    int lastUpdateTime = 0;
    @Persisted
    final GridNodeHolder nodeHolder = new GridNodeHolder((IGridConnectedMachine)this);
    @DescSynced
    protected boolean isOnline;

    AbstractAEInfoMonitor(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.getMainNode().setExposedOnSides(EnumSet.allOf(Direction.class));
    }

    public void onRotated(@NotNull Direction oldFacing, @NotNull Direction newFacing) {
        super.onRotated(oldFacing, newFacing);
        if (oldFacing != newFacing) {
            this.getMainNode().setExposedOnSides(EnumSet.allOf(Direction.class));
        }
    }

    public IManagedGridNode getMainNode() {
        return this.nodeHolder.getMainNode();
    }

    public void setOnline(boolean isOnline) {
        this.isOnline = isOnline;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    @Override
    public DisplayComponentList provideInformation() {
        DisplayComponentList infoList = super.provideInformation();
        switch (this.state.ordinal()) {
            case 0: {
                infoList.addIfAbsent(DisplayRegistry.AE_ERROR.id(), Component.m_237115_((String)"gtocore.machine.monitor.ae.status.no_grid").m_130940_(ChatFormatting.RED).m_7532_());
                break;
            }
            case 1: {
                infoList.addIfAbsent(DisplayRegistry.AE_ERROR.id(), Component.m_237115_((String)"gtocore.machine.monitor.ae.status.no_config").m_130940_(ChatFormatting.RED).m_7532_());
            }
        }
        return infoList;
    }

    @Override
    public List<ResourceLocation> getAvailableRLs() {
        List rls = super.getAvailableRLs();
        rls.add(DisplayRegistry.AE_ERROR.id());
        return rls;
    }

    @Override
    public abstract void syncInfoFromServer();

    protected static enum State {
        NO_GRID,
        NO_CONFIG,
        NORMAL;

    }
}

