/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gtocore.common.machine.mana.part.ManaHatchPartMachine;
import com.gtolib.api.GTOValues;
import com.gtolib.api.machine.mana.trait.NotifiableManaContainer;
import com.gtolib.api.machine.mana.trait.NotifiableWirelessManaContainer;
import com.hepdd.gtmthings.api.capability.IBindable;
import com.hepdd.gtmthings.utils.TeamUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public final class WirelessManaHatchPartMachine
extends ManaHatchPartMachine
implements IInteractedMachine,
IBindable {
    public WirelessManaHatchPartMachine(MetaMachineBlockEntity holder, int tier, IO io, int rate) {
        super(holder, tier, io, rate);
    }

    @Override
    NotifiableManaContainer createManaContainer(int rate) {
        int tierMana = GTOValues.MANA[this.tier] * rate;
        if (this.io == IO.OUT) {
            return new NotifiableWirelessManaContainer((MetaMachine)this, IO.OUT, 256L * (long)tierMana, 4L * (long)tierMana);
        }
        return new NotifiableWirelessManaContainer((MetaMachine)this, IO.IN, 256L * (long)tierMana, 4L * (long)tierMana);
    }

    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_150930_(GTItems.TOOL_DATA_STICK.m_5456_())) {
            this.setOwnerUUID(player.m_20148_());
            if (this.isRemote()) {
                player.m_213846_((Component)Component.m_237110_((String)"gtmthings.machine.wireless_energy_hatch.tooltip.bind", (Object[])new Object[]{TeamUtil.GetName((Player)player)}));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean onLeftClick(Player player, Level world, InteractionHand hand, BlockPos pos, Direction direction) {
        if (player.m_21120_(hand).m_150930_(GTItems.TOOL_DATA_STICK.m_5456_())) {
            this.setOwnerUUID(null);
            if (this.isRemote()) {
                player.m_213846_((Component)Component.m_237115_((String)"gtmthings.machine.wireless_energy_hatch.tooltip.unbind"));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public UUID getUUID() {
        return ((NotifiableWirelessManaContainer)this.getManaContainer()).getUUID();
    }
}

