/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana.part;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.WorkableTieredIOPartMachine;
import com.gtolib.api.GTOValues;
import com.gtolib.api.machine.ManaDistributorMachine;
import com.gtolib.api.machine.mana.feature.IManaMachine;
import com.gtolib.api.machine.mana.trait.NotifiableManaContainer;
import com.gtolib.utils.MathUtil;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaHatchPartMachine
extends WorkableTieredIOPartMachine
implements IManaMachine {
    TickableSubscription tickSubs;
    @Persisted
    private final NotifiableManaContainer manaContainer;

    public ManaHatchPartMachine(MetaMachineBlockEntity holder, int tier, IO io, int rate) {
        super(holder, tier, io);
        this.manaContainer = this.createManaContainer(rate);
        this.manaContainer.setAcceptDistributor(io == IO.IN);
    }

    NotifiableManaContainer createManaContainer(int rate) {
        int tierMana = GTOValues.MANA[this.tier] * rate;
        if (this.io == IO.OUT) {
            return new NotifiableManaContainer((MetaMachine)this, IO.OUT, 256L * (long)tierMana, 4L * (long)tierMana);
        }
        return new NotifiableManaContainer((MetaMachine)this, IO.IN, 256L * (long)tierMana, 4L * (long)tierMana);
    }

    public void addedToController(@NotNull IMultiController controller) {
        super.addedToController(controller);
        if (controller instanceof ManaDistributorMachine) {
            this.manaContainer.setAcceptDistributor(false);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote() && this.io == IO.OUT) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tickUpdate, 20);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    void tickUpdate() {
        if (this.isWorkingEnabled()) {
            BlockPos frontPos = this.getPos().m_121945_(this.getFrontFacing());
            Level level = this.getLevel();
            if (level == null) {
                return;
            }
            ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(level, frontPos, null);
            if (receiver != null && !receiver.isFull()) {
                int mana = MathUtil.saturatedCast((long)this.manaContainer.getCurrentMana());
                if (receiver instanceof ManaCollector) {
                    ManaCollector collector = (ManaCollector)receiver;
                    mana = Math.min(mana, collector.getMaxMana() - collector.getCurrentMana());
                } else if (receiver instanceof ManaPool) {
                    ManaPool pool = (ManaPool)receiver;
                    mana = Math.min(mana, pool.getMaxMana() - pool.getCurrentMana());
                }
                int change = MathUtil.saturatedCast((long)this.manaContainer.removeMana((long)mana, 20, false));
                if (change > 0) {
                    receiver.receiveMana(change);
                    this.manaContainer.notifyListeners();
                }
            }
            for (ISpecialSourceProvider provider : SourceUtil.canGiveSource((BlockPos)frontPos, (Level)level, (int)0)) {
                long removedMana;
                int sourceToAdd;
                ISourceTile iSourceTile = provider.getSource();
                if (!(iSourceTile instanceof SourceJarTile)) continue;
                SourceJarTile jarTile = (SourceJarTile)iSourceTile;
                if (!jarTile.canAcceptSource()) {
                    return;
                }
                int availableSpace = jarTile.getMaxSource() - jarTile.getSource();
                if (availableSpace <= 0 || (sourceToAdd = Math.min((int)(this.manaContainer.getCurrentMana() * 4L), availableSpace)) <= 0 || (removedMana = this.manaContainer.removeMana((long)((sourceToAdd + 3) / 4), 20, false)) <= 0L) break;
                jarTile.addSource((int)(removedMana * 4L));
                this.manaContainer.notifyListeners();
                break;
            }
        }
    }

    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return false;
    }

    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    public boolean canReceiveManaFromBursts() {
        return this.io == IO.IN;
    }

    @NotNull
    public NotifiableManaContainer getManaContainer() {
        return this.manaContainer;
    }
}

