/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gtocore.common.machine.mana.part.ManaHatchPartMachine;
import com.gtocore.utils.ManaUnification;
import com.gtolib.api.machine.mana.feature.IManaMachine;
import com.gtolib.utils.MathUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.xplat.XplatAbstractions;

public final class ManaExtractHatchPartMachine
extends ManaHatchPartMachine {
    public ManaExtractHatchPartMachine(MetaMachineBlockEntity holder, int tier) {
        super(holder, tier, IO.IN, 4);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tickUpdate, 20);
        }
    }

    @Override
    void tickUpdate() {
        if (this.isWorkingEnabled()) {
            BlockPos frontPos = this.getPos().m_121945_(this.getFrontFacing());
            Level level = this.getLevel();
            if (!this.isFull()) {
                BlockEntity blockEntity;
                ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(level, frontPos, null);
                if (receiver instanceof ManaPool || receiver instanceof IManaMachine) {
                    int change = MathUtil.saturatedCast((long)this.getManaContainer().addMana((long)receiver.getCurrentMana(), 20, false));
                    if (change <= 0) {
                        return;
                    }
                    receiver.receiveMana(-change);
                }
                if (level != null && (blockEntity = level.m_7702_(frontPos)) instanceof SourceJarTile) {
                    SourceJarTile jarTile = (SourceJarTile)blockEntity;
                    int sourceAmount = jarTile.getSource();
                    int change = Math.toIntExact(this.getManaContainer().addMana(ManaUnification.sourceToMana(sourceAmount), 20, false) * 4L);
                    if (change <= 0) {
                        return;
                    }
                    SourceUtil.takeSource((BlockPos)frontPos, (Level)level, (int)0, (int)change);
                }
            }
        }
    }
}

