/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana.multiblock;

import com.fast.fastcollection.O2IOpenCacheHashMap;
import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.fast.fastcollection.OpenCacheHashSet;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.item.ApothItem;
import com.gtocore.common.machine.mana.multiblock.ManaMultiblockMachine;
import com.gtocore.data.record.ApotheosisAffixRecord;
import com.gtocore.data.record.EnchantmentRecord;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.ItemUtils;
import com.gtolib.utils.holder.IntHolder;
import com.gtolib.utils.holder.LongHolder;
import com.gtolib.utils.holder.ObjectHolder;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ThePrimordialReconstructor
extends ManaMultiblockMachine {
    private static int circuit = 0;
    private static final Map<String, Item> RARITY_MATERIAL_MAP = Map.of("apotheosis:ancient", (Item)Adventure.Items.ANCIENT_MATERIAL.get(), "apotheosis:mythic", (Item)Adventure.Items.MYTHIC_MATERIAL.get(), "apotheosis:epic", (Item)Adventure.Items.EPIC_MATERIAL.get(), "apotheosis:rare", (Item)Adventure.Items.RARE_MATERIAL.get(), "apotheosis:uncommon", (Item)Adventure.Items.UNCOMMON_MATERIAL.get(), "apotheosis:common", (Item)Adventure.Items.COMMON_MATERIAL.get());
    private static final Map<String, Integer> RARITY_TO_DUST_COUNT = Map.of("apotheosis:common", 2, "apotheosis:uncommon", 3, "apotheosis:rare", 4, "apotheosis:epic", 5, "apotheosis:mythic", 6, "apotheosis:ancient", 10);
    private static final String[] RARITIES = new String[]{"apotheosis:common", "apotheosis:uncommon", "apotheosis:rare", "apotheosis:epic", "apotheosis:mythic", "apotheosis:ancient"};

    public ThePrimordialReconstructor(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.model", (Object[])new Object[]{circuit}));
        textList.add((Component)Component.m_237115_((String)("gtocore.machine.the_primordial_reconstructor.mode." + circuit)));
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }

    private Recipe getRecipe() {
        circuit = this.checkingCircuit(false);
        Recipe recipe = null;
        switch (circuit) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                recipe = this.getDisassembleRecipe();
                break;
            }
            case 5: {
                recipe = this.getEnchantmentsLoadRecipe();
                break;
            }
            case 6: {
                recipe = this.getEnchantedBooksMergeRecipe();
                break;
            }
            case 7: {
                recipe = this.getAffixCanvasLoadRecipe();
                break;
            }
            case 8: {
                recipe = this.getGemSynthesisRecipe();
                break;
            }
            case 9: {
                recipe = this.getGemCrushingRecipe();
                break;
            }
            case 10: {
                recipe = this.getForcedEnchantmentRecipe();
                break;
            }
            case 11: {
                recipe = this.getForcedAffixRecipe();
                break;
            }
            case 12: {
                recipe = this.getForcedRarityUpRecipe();
                break;
            }
            case 13: {
                recipe = this.getForcedAddSocketRecipe();
                break;
            }
            case 14: {
                recipe = this.getForcedMosaicGemRecipe();
            }
        }
        if (recipe != null && RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
            return recipe;
        }
        return null;
    }

    private Recipe getDisassembleRecipe() {
        block3: {
            ArrayList outputsItems;
            ArrayList inputsItems;
            RecipeBuilder disassembleRecipeBuilder;
            block2: {
                disassembleRecipeBuilder = this.getRecipeBuilder();
                inputsItems = new ArrayList();
                outputsItems = new ArrayList();
                this.forEachInputItems((stack, amount) -> {
                    CompoundTag nbt = stack.m_41783_();
                    if (nbt != null) {
                        if (nbt.m_128441_("affix_data") || nbt.m_128441_("Enchantments")) {
                            if (ThePrimordialReconstructor.disassembleEquipment(nbt, inputsItems, outputsItems)) {
                                inputsItems.add(stack);
                            }
                        } else if (circuit == 4 && nbt.m_128441_("Damage")) {
                            inputsItems.add(stack);
                        }
                        if ((circuit == 2 || circuit == 4) && stack.m_41720_() == Items.f_42690_.m_5456_() && ThePrimordialReconstructor.disassembleEnchantments(nbt, outputsItems)) {
                            inputsItems.add(stack);
                            outputsItems.add(new ItemStack((ItemLike)Items.f_42517_));
                        }
                        if ((circuit == 3 || circuit == 4) && stack.m_41720_() == GTOItems.AFFIX_CANVAS.m_5456_() && ThePrimordialReconstructor.disassembleAffixCanvas(nbt, outputsItems)) {
                            inputsItems.add(stack);
                            outputsItems.add(new ItemStack(GTOItems.AFFIX_CANVAS));
                        }
                    }
                    return false;
                });
                if (!inputsItems.isEmpty()) break block2;
                if (outputsItems.isEmpty()) break block3;
            }
            inputsItems.forEach(arg_0 -> ((RecipeBuilder)disassembleRecipeBuilder).inputItems(arg_0));
            outputsItems.forEach(arg_0 -> ((RecipeBuilder)disassembleRecipeBuilder).outputItems(arg_0));
            disassembleRecipeBuilder.duration(20);
            return disassembleRecipeBuilder.buildRawRecipe();
        }
        return null;
    }

    private static boolean disassembleEquipment(CompoundTag nbt, List<ItemStack> inputsItems, List<ItemStack> outputsItems) {
        boolean find = false;
        if (circuit == 1 || circuit == 3) {
            if (ThePrimordialReconstructor.extractEnchantments1(nbt, outputsItems)) {
                inputsItems.add(new ItemStack((ItemLike)Items.f_42517_));
                find = true;
            }
        } else if ((circuit == 2 || circuit == 4) && ThePrimordialReconstructor.extractEnchantments2(nbt, outputsItems)) {
            find = true;
        }
        if (circuit == 1 || circuit == 2) {
            if (ThePrimordialReconstructor.extractAffix1(nbt, outputsItems)) {
                inputsItems.add(new ItemStack(GTOItems.AFFIX_CANVAS));
                find = true;
            }
        } else if ((circuit == 3 || circuit == 4) && ThePrimordialReconstructor.extractAffix2(nbt, outputsItems)) {
            find = true;
        }
        if (ThePrimordialReconstructor.extractGems(nbt, outputsItems)) {
            inputsItems.add(new ItemStack((ItemLike)Adventure.Items.SIGIL_OF_WITHDRAWAL.get()));
            find = true;
        }
        if (circuit == 4) {
            find = true;
        }
        return ThePrimordialReconstructor.generateMaterials(nbt, outputsItems) || find;
    }

    private static boolean extractEnchantments1(CompoundTag nbt, List<ItemStack> outputsItems) {
        ListTag enchantments;
        Object v = nbt.f_128329_.get("Enchantments");
        if (v instanceof ListTag && !(enchantments = (ListTag)v).isEmpty()) {
            int enchantmentCount = enchantments.size();
            ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
            CompoundTag bookTag = new CompoundTag();
            ListTag storedEnchantments = new ListTag();
            for (int i = 0; i < enchantmentCount; ++i) {
                CompoundTag enchantment = enchantments.m_128728_(i);
                storedEnchantments.add((Object)enchantment.m_6426_());
            }
            bookTag.m_128365_("StoredEnchantments", (Tag)storedEnchantments);
            enchantedBook.m_41751_(bookTag);
            outputsItems.add(enchantedBook);
            return true;
        }
        return false;
    }

    private static boolean extractEnchantments2(CompoundTag nbt, List<ItemStack> outputsItems) {
        ListTag enchantments;
        Object v = nbt.f_128329_.get("Enchantments");
        if (v instanceof ListTag && !(enchantments = (ListTag)v).isEmpty()) {
            int enchantmentCount = enchantments.size();
            for (int i = 0; i < enchantmentCount; ++i) {
                CompoundTag enchantment = enchantments.m_128728_(i);
                if (!enchantment.m_128425_("id", 8) || !enchantment.m_128425_("lvl", 2)) continue;
                int lvl = 1 << enchantment.m_128448_("lvl") - 1;
                ItemEntry<ApothItem> essence = GTOItems.ENCHANTMENT_ESSENCE.get(enchantment.m_128461_("id"));
                if (essence == null) {
                    essence = GTOItems.ENCHANTMENT_ESSENCE.get("original");
                }
                outputsItems.add(new ItemStack(essence, lvl));
            }
            return true;
        }
        return false;
    }

    private static boolean extractGems(CompoundTag nbt, List<ItemStack> outputsItems) {
        Object v = nbt.f_128329_.get("affix_data");
        if (v instanceof CompoundTag) {
            CompoundTag data = (CompoundTag)v;
            v = data.f_128329_.get("gems");
            if (v instanceof ListTag) {
                ListTag gems = (ListTag)v;
                for (int i = 0; i < gems.size(); ++i) {
                    CompoundTag gemData = gems.m_128728_(i);
                    ItemStack gemStack = ((Item)Adventure.Items.GEM.get()).m_7968_();
                    Object v2 = gemData.f_128329_.get("tag");
                    if (v2 instanceof CompoundTag) {
                        CompoundTag tag = (CompoundTag)v2;
                        gemStack.m_41751_(tag.m_6426_());
                    }
                    outputsItems.add(gemStack);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean extractAffix1(CompoundTag nbt, List<ItemStack> outputsItems) {
        CompoundTag affixes;
        CompoundTag affixData = nbt.m_128469_("affix_data");
        if (!affixData.m_128456_() && !(affixes = affixData.m_128469_("affixes")).m_128456_()) {
            Set affixKeys = affixes.m_128431_();
            ItemStack affixCanvas = new ItemStack(GTOItems.AFFIX_CANVAS);
            CompoundTag affixTag = new CompoundTag();
            ListTag affixList = new ListTag();
            for (String affixKey : affixKeys) {
                CompoundTag affixEntry = new CompoundTag();
                affixEntry.m_128359_("id", affixKey);
                affixList.add((Object)affixEntry);
            }
            affixTag.m_128365_("affix_list", (Tag)affixList);
            affixCanvas.m_41751_(affixTag);
            outputsItems.add(affixCanvas);
            return true;
        }
        return false;
    }

    private static boolean extractAffix2(CompoundTag nbt, List<ItemStack> outputsItems) {
        CompoundTag affixes;
        CompoundTag affixData = nbt.m_128469_("affix_data");
        if (!affixData.m_128456_() && !(affixes = affixData.m_128469_("affixes")).m_128456_()) {
            for (String affixKey : affixes.m_128431_()) {
                outputsItems.add(new ItemStack((ItemLike)GTOItems.AFFIX_ESSENCE.get(affixKey)));
            }
            return true;
        }
        return false;
    }

    private static boolean generateMaterials(CompoundTag nbt, List<ItemStack> outputsItems) {
        Object v = nbt.f_128329_.get("affix_data");
        if (v instanceof CompoundTag) {
            CompoundTag data = (CompoundTag)v;
            v = data.f_128329_.get("rarity");
            if (v instanceof StringTag) {
                StringTag tag = (StringTag)v;
                Item materialType = RARITY_MATERIAL_MAP.getOrDefault(tag.m_7916_(), RARITY_MATERIAL_MAP.get("default"));
                outputsItems.add(new ItemStack((ItemLike)materialType, 2));
                return true;
            }
        }
        return false;
    }

    private static boolean disassembleEnchantments(CompoundTag nbt, List<ItemStack> outputsItems) {
        ListTag enchantments;
        Object v = nbt.f_128329_.get("StoredEnchantments");
        if (v instanceof ListTag && !(enchantments = (ListTag)v).isEmpty()) {
            int enchantmentCount = enchantments.size();
            for (int i = 0; i < enchantmentCount; ++i) {
                CompoundTag enchantment = enchantments.m_128728_(i);
                int lvl = 1 << enchantment.m_128451_("lvl") - 1;
                ItemEntry<ApothItem> essence = GTOItems.ENCHANTMENT_ESSENCE.get(enchantment.m_128461_("id"));
                if (essence == null) {
                    essence = GTOItems.ENCHANTMENT_ESSENCE.get("original");
                }
                outputsItems.add(new ItemStack(essence, lvl));
            }
            return true;
        }
        return false;
    }

    private static boolean disassembleAffixCanvas(CompoundTag nbt, List<ItemStack> outputsItems) {
        ListTag affixes;
        Object v = nbt.f_128329_.get("affix_list");
        if (v instanceof ListTag && !(affixes = (ListTag)v).isEmpty()) {
            int affixCount = affixes.size();
            for (int i = 0; i < affixCount; ++i) {
                CompoundTag affix = affixes.m_128728_(i);
                outputsItems.add(new ItemStack((ItemLike)GTOItems.AFFIX_ESSENCE.get(affix.m_128461_("id"))));
            }
            return true;
        }
        return false;
    }

    private static String getPath(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        int lastColonIndex = text.lastIndexOf(58);
        if (lastColonIndex == -1) {
            return text;
        }
        return text.substring(lastColonIndex + 1);
    }

    private static String getPrefix(String text) {
        int lastUnderscoreIndex = text.lastIndexOf(95);
        if (lastUnderscoreIndex == -1) {
            return text;
        }
        return text.substring(0, lastUnderscoreIndex);
    }

    private Recipe getEnchantmentsLoadRecipe() {
        RecipeBuilder enchantmentsLoadRecipeBuilder = this.getRecipeBuilder();
        ObjectHolder essence = new ObjectHolder(null);
        LongHolder count = new LongHolder(0L);
        this.forEachInputItems((stack, amount) -> {
            EnchantmentRecord enchantment;
            Item stackItem = stack.m_41720_();
            if (essence.value == null && (enchantment = EnchantmentRecord.ENCHANTMENT_ITEM_MAP.get(stackItem)) != null) {
                essence.value = stackItem;
            }
            if (essence.value != null && essence.value == stackItem) {
                count.value += amount;
            }
            return false;
        });
        int lvl = Math.min(64 - Long.numberOfLeadingZeros(count.value), 30);
        if (essence.value != null && lvl > 0) {
            EnchantmentRecord enchantment = EnchantmentRecord.ENCHANTMENT_ITEM_MAP.get(essence.value);
            enchantmentsLoadRecipeBuilder.inputItems(Items.f_42517_);
            enchantmentsLoadRecipeBuilder.inputItems((Item)essence.value, 1 << lvl - 1);
            enchantmentsLoadRecipeBuilder.outputItems(EnchantmentRecord.getEnchantedBookByEnchantmentId(enchantment.enchantmentId(), (short)lvl));
            enchantmentsLoadRecipeBuilder.duration(20);
            enchantmentsLoadRecipeBuilder.MANAt(256L);
            return enchantmentsLoadRecipeBuilder.buildRawRecipe();
        }
        return null;
    }

    private Recipe getEnchantedBooksMergeRecipe() {
        boolean changed;
        RecipeBuilder mergeRecipeBuilder = this.getRecipeBuilder();
        ArrayList<AbstractObject2IntMap.BasicEntry> allEnchantments = new ArrayList<AbstractObject2IntMap.BasicEntry>();
        IntHolder totalBooks = new IntHolder(0);
        this.forEachInputItems((stack, amount) -> {
            if (stack.m_41720_() == Items.f_42690_) {
                ++totalBooks.value;
                CompoundTag tag = stack.m_41783_();
                if (tag != null && tag.m_128425_("StoredEnchantments", 9)) {
                    ListTag enchantmentsList = tag.m_128437_("StoredEnchantments", 10);
                    for (int i = 0; i < enchantmentsList.size(); ++i) {
                        CompoundTag enchantTag = enchantmentsList.m_128728_(i);
                        String enchantId = enchantTag.m_128461_("id");
                        short level = enchantTag.m_128448_("lvl");
                        allEnchantments.add(new AbstractObject2IntMap.BasicEntry((Object)enchantId, (int)level));
                    }
                    mergeRecipeBuilder.inputItems(stack);
                }
            }
            return false;
        });
        if (totalBooks.value < 2 || allEnchantments.isEmpty()) {
            return null;
        }
        do {
            String enchantId;
            changed = false;
            O2OOpenCacheHashMap enchantmentLevelCounts = new O2OOpenCacheHashMap();
            for (Object2IntMap.Entry entry : allEnchantments) {
                enchantId = (String)entry.getKey();
                int level = entry.getIntValue();
                Int2IntMap levelCounts = (Int2IntMap)enchantmentLevelCounts.computeIfAbsent((Object)enchantId, k -> new Int2IntOpenHashMap());
                levelCounts.put(level, levelCounts.getOrDefault(level, 0) + 1);
            }
            allEnchantments.clear();
            for (Object2ObjectMap.Entry entry : enchantmentLevelCounts.object2ObjectEntrySet()) {
                enchantId = (String)entry.getKey();
                Int2IntMap levelCounts = (Int2IntMap)entry.getValue();
                for (Int2IntMap.Entry levelEntry : levelCounts.int2IntEntrySet()) {
                    int level = levelEntry.getIntKey();
                    int count = levelEntry.getIntValue();
                    if (count >= 2) {
                        int pairs = count / 2;
                        int remainder = count % 2;
                        for (int i = 0; i < pairs; ++i) {
                            allEnchantments.add(new AbstractObject2IntMap.BasicEntry((Object)enchantId, level + 1));
                            changed = true;
                        }
                        if (remainder <= 0) continue;
                        allEnchantments.add(new AbstractObject2IntMap.BasicEntry((Object)enchantId, level));
                        continue;
                    }
                    allEnchantments.add(new AbstractObject2IntMap.BasicEntry((Object)enchantId, level));
                }
            }
        } while (changed);
        ArrayList<ItemStack> outputBooks = new ArrayList<ItemStack>();
        ArrayList remainingEnchantments = new ArrayList(allEnchantments);
        while (!remainingEnchantments.isEmpty()) {
            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42690_);
            CompoundTag bookTag = itemStack.m_41784_();
            ListTag storedEnchantments = new ListTag();
            OpenCacheHashSet addedEnchantments = new OpenCacheHashSet();
            Iterator iterator = remainingEnchantments.iterator();
            while (iterator.hasNext()) {
                Object2IntMap.Entry enchantment = (Object2IntMap.Entry)iterator.next();
                String enchantId = (String)enchantment.getKey();
                if (addedEnchantments.contains(enchantId)) continue;
                CompoundTag enchantTag = new CompoundTag();
                enchantTag.m_128359_("id", enchantId);
                enchantTag.m_128376_("lvl", (short)enchantment.getIntValue());
                storedEnchantments.add((Object)enchantTag);
                addedEnchantments.add(enchantId);
                iterator.remove();
            }
            bookTag.m_128365_("StoredEnchantments", (Tag)storedEnchantments);
            itemStack.m_41751_(bookTag);
            outputBooks.add(itemStack);
        }
        for (ItemStack outputBookItem : outputBooks) {
            mergeRecipeBuilder.outputItems(outputBookItem);
        }
        int n = totalBooks.value - outputBooks.size();
        if (n > 0) {
            mergeRecipeBuilder.outputItems(Items.f_42517_, n);
        } else if (n < 0) {
            mergeRecipeBuilder.inputItems(Items.f_42517_, -n);
        }
        mergeRecipeBuilder.duration(20);
        mergeRecipeBuilder.MANAt(512L);
        return mergeRecipeBuilder.buildRawRecipe();
    }

    private Recipe getAffixCanvasLoadRecipe() {
        RecipeBuilder affixCanvasLoadRecipeBuilder = this.getRecipeBuilder();
        ReferenceOpenHashSet uniqueItems = new ReferenceOpenHashSet();
        this.forEachInputItems((arg_0, arg_1) -> ThePrimordialReconstructor.lambda$getAffixCanvasLoadRecipe$4((Set)uniqueItems, arg_0, arg_1));
        if (uniqueItems.isEmpty()) {
            return null;
        }
        ItemStack affixCanvas = new ItemStack(GTOItems.AFFIX_CANVAS);
        CompoundTag affixTag = new CompoundTag();
        ListTag affixList = new ListTag();
        for (Item item : uniqueItems) {
            CompoundTag affixEntry = new CompoundTag();
            affixEntry.m_128359_("id", ApotheosisAffixRecord.AFFIX_ITEM_MAP.get(item).affixId());
            affixList.add((Object)affixEntry);
            affixCanvasLoadRecipeBuilder.inputItems(item);
        }
        affixTag.m_128365_("affix_list", (Tag)affixList);
        affixCanvas.m_41751_(affixTag);
        affixCanvasLoadRecipeBuilder.inputItems(GTOItems.AFFIX_CANVAS);
        affixCanvasLoadRecipeBuilder.outputItems(affixCanvas);
        affixCanvasLoadRecipeBuilder.duration(20);
        affixCanvasLoadRecipeBuilder.MANAt(512L);
        return affixCanvasLoadRecipeBuilder.buildRawRecipe();
    }

    private Recipe getGemSynthesisRecipe() {
        int i;
        RecipeBuilder GemSynthesisRecipeBuilder = this.getRecipeBuilder();
        ArrayList inputsGems = new ArrayList();
        this.forEachInputItems((stack, amount) -> {
            if (stack.m_41720_() == Adventure.Items.GEM.get()) {
                inputsGems.add(stack);
            }
            return false;
        });
        if (inputsGems.isEmpty()) {
            return null;
        }
        O2IOpenCacheHashMap nbtCountMap = new O2IOpenCacheHashMap();
        for (ItemStack stack2 : inputsGems) {
            CompoundTag nbt = stack2.m_41783_() != null ? stack2.m_41783_() : new CompoundTag();
            int count = stack2.m_41613_();
            nbtCountMap.addTo((Object)nbt, count);
        }
        ArrayList<ItemStack> mergedGems = new ArrayList<ItemStack>();
        for (Object2IntMap.Entry entry : nbtCountMap.object2IntEntrySet()) {
            ItemStack mergedStack = new ItemStack((ItemLike)Adventure.Items.GEM.get(), entry.getIntValue());
            CompoundTag nbt = (CompoundTag)entry.getKey();
            if (!nbt.m_128456_()) {
                mergedStack.m_41751_(nbt.m_6426_());
            }
            mergedGems.add(mergedStack);
        }
        Iterator iterator = mergedGems.iterator();
        while (iterator.hasNext()) {
            ItemStack stack3 = (ItemStack)iterator.next();
            int count = stack3.m_41613_();
            if (count % 2 == 0) continue;
            if (count > 1) {
                stack3.m_41764_(count - 1);
                continue;
            }
            iterator.remove();
        }
        if (mergedGems.isEmpty()) {
            return null;
        }
        ArrayList[] gemsByRarity = new ArrayList[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            gemsByRarity[i2] = new ArrayList();
        }
        block4: for (ItemStack gem : mergedGems) {
            String rarity = ThePrimordialReconstructor.getGemRarity(gem);
            if ("apotheosis:ancient".equals(rarity)) continue;
            for (int i3 = 0; i3 < RARITIES.length; ++i3) {
                if (!RARITIES[i3].equals(rarity)) continue;
                gemsByRarity[i3].add(gem);
                continue block4;
            }
        }
        for (i = 0; i < 5 && gemsByRarity[i].isEmpty(); ++i) {
            if (i != 4) continue;
            return null;
        }
        for (i = 0; i < 5; ++i) {
            ArrayList gems = gemsByRarity[i];
            if (gems.isEmpty()) continue;
            for (ItemStack gem : gems) {
                CompoundTag tag;
                int count = gem.m_41613_() / 2;
                Item materialType = RARITY_MATERIAL_MAP.getOrDefault(RARITIES[i], RARITY_MATERIAL_MAP.get("default"));
                GemSynthesisRecipeBuilder.inputItems(gem);
                GemSynthesisRecipeBuilder.inputItems(materialType, count * 3);
                GemSynthesisRecipeBuilder.inputItems((Item)Adventure.Items.GEM_DUST.get(), count * (i * 2 + 1));
                String originalRarity = ThePrimordialReconstructor.getGemRarity(gem);
                int currentIndex = -1;
                for (int k = 0; k < RARITIES.length; ++k) {
                    if (!RARITIES[k].equals(originalRarity)) continue;
                    currentIndex = k;
                    break;
                }
                String upgradedRarity = RARITIES[currentIndex + 1];
                ItemStack upgradedGem = new ItemStack((ItemLike)Adventure.Items.GEM.get(), 1);
                if (gem.m_41783_() != null) {
                    upgradedGem.m_41751_(gem.m_41783_().m_6426_());
                }
                if ((tag = upgradedGem.m_41783_()) != null) {
                    CompoundTag affixData = tag.m_128469_("affix_data");
                    affixData.m_128359_("rarity", upgradedRarity);
                }
                GemSynthesisRecipeBuilder.outputItems((Object)upgradedGem, count);
            }
        }
        GemSynthesisRecipeBuilder.duration(20);
        return GemSynthesisRecipeBuilder.buildRawRecipe();
    }

    private Recipe getGemCrushingRecipe() {
        RecipeBuilder gemCrushingRecipeBuilder = this.getRecipeBuilder();
        ArrayList inputsItems = new ArrayList();
        LongHolder totalDustCount = new LongHolder(0L);
        this.forEachInputItems((stack, amount) -> {
            if (stack.m_41720_() == Adventure.Items.GEM.get()) {
                int stackDust = stack.m_41613_() * RARITY_TO_DUST_COUNT.getOrDefault(ThePrimordialReconstructor.getGemRarity(stack), 1);
                inputsItems.add(stack);
                if (totalDustCount.value + (long)stackDust >= Integer.MAX_VALUE) {
                    totalDustCount.value = Integer.MAX_VALUE;
                    return true;
                }
                totalDustCount.value += (long)stackDust;
            }
            return false;
        });
        if (inputsItems.isEmpty() || totalDustCount.value <= 0L) {
            return null;
        }
        inputsItems.forEach(arg_0 -> ((RecipeBuilder)gemCrushingRecipeBuilder).inputItems(arg_0));
        gemCrushingRecipeBuilder.outputItems((Item)Adventure.Items.GEM_DUST.get(), (int)totalDustCount.value);
        gemCrushingRecipeBuilder.duration(10);
        return gemCrushingRecipeBuilder.buildRawRecipe();
    }

    private Recipe getForcedEnchantmentRecipe() {
        CompoundTag targetTag;
        RecipeBuilder forcedEnchantmentRecipeBuilder = this.getRecipeBuilder();
        ObjectHolder EnchantedBook = new ObjectHolder(null);
        ObjectHolder NonEnchantedItem = new ObjectHolder(null);
        this.forEachInputItems((stack, amount) -> {
            Item stackItem = stack.m_41720_();
            if (stackItem == GTItems.PROGRAMMED_CIRCUIT.m_5456_()) {
                return false;
            }
            if (EnchantedBook.value == null && stackItem == Items.f_42690_) {
                CompoundTag tag = stack.m_41783_();
                if (tag != null && tag.m_128425_("StoredEnchantments", 9)) {
                    EnchantedBook.value = stack;
                }
                return false;
            }
            if (NonEnchantedItem.value == null && stackItem != Items.f_42690_) {
                NonEnchantedItem.value = stack;
                return false;
            }
            return EnchantedBook.value != null && NonEnchantedItem.value != null;
        });
        if (EnchantedBook.value == null || NonEnchantedItem.value == null) {
            return null;
        }
        ItemStack inputBook = ((ItemStack)EnchantedBook.value).m_41777_();
        ItemStack inputItem = ((ItemStack)NonEnchantedItem.value).m_41777_();
        forcedEnchantmentRecipeBuilder.inputItems((Object)inputBook, 1);
        forcedEnchantmentRecipeBuilder.inputItems((Object)inputItem, 1);
        CompoundTag bookTag = inputBook.m_41783_();
        ListTag enchantmentsList = null;
        if (bookTag != null) {
            enchantmentsList = bookTag.m_128437_("StoredEnchantments", 10);
        }
        ListTag targetEnchantments = (targetTag = inputItem.m_41784_()).m_128425_("Enchantments", 9) ? targetTag.m_128437_("Enchantments", 10) : new ListTag();
        if (enchantmentsList != null) {
            for (int i = 0; i < enchantmentsList.size(); ++i) {
                CompoundTag enchantmentTag = enchantmentsList.m_128728_(i);
                targetEnchantments.add((Object)enchantmentTag);
            }
        }
        targetTag.m_128365_("Enchantments", (Tag)targetEnchantments);
        inputItem.m_41751_(targetTag);
        forcedEnchantmentRecipeBuilder.outputItems((Object)inputItem, 1);
        forcedEnchantmentRecipeBuilder.outputItems(Items.f_42517_);
        forcedEnchantmentRecipeBuilder.duration(5);
        forcedEnchantmentRecipeBuilder.MANAt(512L);
        return forcedEnchantmentRecipeBuilder.buildRawRecipe();
    }

    private Recipe getForcedAffixRecipe() {
        RecipeBuilder forcedAffixRecipeBuilder = this.getRecipeBuilder();
        ObjectHolder affixCanvas = new ObjectHolder(null);
        ObjectHolder NonAffixItem = new ObjectHolder(null);
        this.forEachInputItems((stack, amount) -> {
            Item stackItem = stack.m_41720_();
            if (stackItem == GTItems.PROGRAMMED_CIRCUIT.m_5456_()) {
                return false;
            }
            if (affixCanvas.value == null && stackItem == GTOItems.AFFIX_CANVAS.m_5456_()) {
                CompoundTag tag = stack.m_41783_();
                if (tag != null && tag.m_128425_("affix_list", 9)) {
                    affixCanvas.value = stack;
                }
                return false;
            }
            if (NonAffixItem.value == null && stackItem != GTOItems.AFFIX_CANVAS.m_5456_()) {
                NonAffixItem.value = stack;
                return false;
            }
            return affixCanvas.value != null && NonAffixItem.value != null;
        });
        if (affixCanvas.value == null || NonAffixItem.value == null) {
            return null;
        }
        ItemStack inputAffixCanvas = ((ItemStack)affixCanvas.value).m_41777_();
        ItemStack inputItem = ((ItemStack)NonAffixItem.value).m_41777_();
        forcedAffixRecipeBuilder.inputItems((Object)inputAffixCanvas, 1);
        forcedAffixRecipeBuilder.inputItems((Object)inputItem, 1);
        if (inputAffixCanvas.m_41619_() || !inputAffixCanvas.m_41782_() || inputAffixCanvas.m_41783_() == null || !inputAffixCanvas.m_41783_().m_128425_("affix_list", 9)) {
            return null;
        }
        ThePrimordialReconstructor.ensureAffixData(inputItem);
        CompoundTag targetNbt = inputItem.m_41784_();
        CompoundTag affixData = targetNbt.m_128469_("affix_data");
        CompoundTag affixes = affixData.m_128469_("affixes");
        ListTag affixList = inputAffixCanvas.m_41783_().m_128437_("affix_list", 10);
        for (int i = 0; i < affixList.size(); ++i) {
            CompoundTag affixEntry = affixList.m_128728_(i);
            if (!affixEntry.m_128425_("id", 8)) continue;
            String affixId = affixEntry.m_128461_("id");
            affixes.m_128350_(affixId, 1.0f);
        }
        forcedAffixRecipeBuilder.outputItems((Object)inputItem, 1);
        forcedAffixRecipeBuilder.outputItems(GTOItems.AFFIX_CANVAS);
        forcedAffixRecipeBuilder.duration(5);
        forcedAffixRecipeBuilder.MANAt(512L);
        return forcedAffixRecipeBuilder.buildRawRecipe();
    }

    private Recipe getForcedRarityUpRecipe() {
        RecipeBuilder ForcedRarityUpRecipeBuilder = this.getRecipeBuilder();
        ObjectHolder rarityUpItem = new ObjectHolder(null);
        ObjectHolder materialItem = new ObjectHolder(null);
        this.forEachInputItems((stack, amount) -> {
            Item stackItem = stack.m_41720_();
            if (stackItem == GTItems.PROGRAMMED_CIRCUIT.m_5456_() || stackItem == Adventure.Items.SIGIL_OF_REBIRTH.get()) {
                return false;
            }
            if (rarityUpItem.value == null && stackItem != Adventure.Items.COMMON_MATERIAL.get() && stackItem != Adventure.Items.UNCOMMON_MATERIAL.get() && stackItem != Adventure.Items.RARE_MATERIAL.get() && stackItem != Adventure.Items.EPIC_MATERIAL.get() && stackItem != Adventure.Items.MYTHIC_MATERIAL.get() && stackItem != Adventure.Items.ANCIENT_MATERIAL.get()) {
                rarityUpItem.value = stack;
            }
            if (materialItem.value == null && (stackItem == Adventure.Items.COMMON_MATERIAL.get() || stackItem == Adventure.Items.UNCOMMON_MATERIAL.get() || stackItem == Adventure.Items.RARE_MATERIAL.get() || stackItem == Adventure.Items.EPIC_MATERIAL.get() || stackItem == Adventure.Items.MYTHIC_MATERIAL.get() || stackItem == Adventure.Items.ANCIENT_MATERIAL.get())) {
                materialItem.value = stack;
            }
            return rarityUpItem.value != null && materialItem.value != null;
        });
        if (rarityUpItem.value == null || materialItem.value == null) {
            return null;
        }
        String rarity = "apotheosis:" + ThePrimordialReconstructor.getPrefix(ItemUtils.getIdLocation((Item)((ItemStack)materialItem.value).m_41720_()).m_135815_());
        ItemStack inputRarityUpItem = ((ItemStack)rarityUpItem.value).m_41777_();
        ItemStack inputMaterialItem = ((ItemStack)materialItem.value).m_41777_();
        ForcedRarityUpRecipeBuilder.inputItems((Object)inputRarityUpItem, 1);
        ForcedRarityUpRecipeBuilder.inputItems((Object)inputMaterialItem, 2);
        ForcedRarityUpRecipeBuilder.inputItems((Item)Adventure.Items.SIGIL_OF_REBIRTH.get());
        ThePrimordialReconstructor.ensureAffixData(inputRarityUpItem);
        CompoundTag nbt = inputRarityUpItem.m_41784_();
        CompoundTag affixData = nbt.m_128469_("affix_data");
        affixData.m_128359_("rarity", rarity);
        ForcedRarityUpRecipeBuilder.outputItems((Object)inputRarityUpItem, 1);
        ForcedRarityUpRecipeBuilder.duration(5);
        ForcedRarityUpRecipeBuilder.MANAt(512L);
        return ForcedRarityUpRecipeBuilder.buildRawRecipe();
    }

    private Recipe getForcedAddSocketRecipe() {
        RecipeBuilder ForcedAddSocketRecipeBuilder = this.getRecipeBuilder();
        ObjectHolder addSocketItem = new ObjectHolder(null);
        IntHolder sigilCount = new IntHolder(0);
        this.forEachInputItems((stack, amount) -> {
            Item stackItem = stack.m_41720_();
            if (stackItem == GTItems.PROGRAMMED_CIRCUIT.m_5456_()) {
                return false;
            }
            if (stackItem == Adventure.Items.SIGIL_OF_SOCKETING.get()) {
                sigilCount.value += (int)amount;
                return false;
            }
            if (addSocketItem.value == null && stackItem != Adventure.Items.COMMON_MATERIAL.get() && stackItem != Adventure.Items.UNCOMMON_MATERIAL.get() && stackItem != Adventure.Items.RARE_MATERIAL.get() && stackItem != Adventure.Items.EPIC_MATERIAL.get() && stackItem != Adventure.Items.MYTHIC_MATERIAL.get() && stackItem != Adventure.Items.ANCIENT_MATERIAL.get()) {
                addSocketItem.value = stack;
            }
            return addSocketItem.value != null && sigilCount.value != 0;
        });
        if (addSocketItem.value == null || sigilCount.value == 0) {
            return null;
        }
        ItemStack inputAddSocketItem = ((ItemStack)addSocketItem.value).m_41777_();
        ForcedAddSocketRecipeBuilder.inputItems((Object)inputAddSocketItem, 1);
        ThePrimordialReconstructor.ensureAffixData(inputAddSocketItem);
        CompoundTag nbt = inputAddSocketItem.m_41784_();
        CompoundTag affixData = nbt.m_128469_("affix_data");
        int currentSockets = affixData.m_128451_("sockets");
        if (currentSockets >= 16) {
            return null;
        }
        int costSigil = Math.min(16 - currentSockets, sigilCount.value);
        affixData.m_128405_("sockets", currentSockets + costSigil);
        ForcedAddSocketRecipeBuilder.inputItems((Item)Adventure.Items.SIGIL_OF_SOCKETING.get(), costSigil);
        ForcedAddSocketRecipeBuilder.outputItems((Object)inputAddSocketItem, 1);
        ForcedAddSocketRecipeBuilder.duration(5);
        ForcedAddSocketRecipeBuilder.MANAt(512L);
        return ForcedAddSocketRecipeBuilder.buildRawRecipe();
    }

    private Recipe getForcedMosaicGemRecipe() {
        RecipeBuilder ForcedMosaicGemRecipeBuilder = this.getRecipeBuilder();
        ObjectHolder addGemItem = new ObjectHolder(null);
        ArrayList gemItems = new ArrayList();
        this.forEachInputItems((stack, amount) -> {
            Item stackItem = stack.m_41720_();
            if (stackItem == GTItems.PROGRAMMED_CIRCUIT.m_5456_()) {
                return false;
            }
            if (addGemItem.value == null && stackItem != Adventure.Items.GEM.get()) {
                addGemItem.value = stack;
            }
            if (gemItems.size() < 16 && stackItem == Adventure.Items.GEM.get()) {
                gemItems.add(stack);
            }
            return addGemItem.value != null && gemItems.size() > 16;
        });
        if (addGemItem.value == null || gemItems.isEmpty()) {
            return null;
        }
        ItemStack inputAddGemItem = ((ItemStack)addGemItem.value).m_41777_();
        ForcedMosaicGemRecipeBuilder.inputItems((Object)inputAddGemItem, 1);
        ThePrimordialReconstructor.ensureAffixData(inputAddGemItem);
        CompoundTag nbt = inputAddGemItem.m_41784_();
        CompoundTag affixData = nbt.m_128469_("affix_data");
        ListTag gems = affixData.m_128437_("gems", 10);
        int socketCount = affixData.m_128451_("sockets");
        while (gems.size() < socketCount) {
            CompoundTag airTag = new CompoundTag();
            airTag.m_128344_("Count", (byte)1);
            airTag.m_128359_("id", "minecraft:air");
            gems.add((Object)airTag);
        }
        while (gems.size() > socketCount) {
            gems.removeLast();
        }
        ArrayList<ItemStack> inputGemItems = new ArrayList<ItemStack>();
        boolean full = false;
        for (ItemStack inputGemItem : gemItems) {
            int stackCount = inputGemItem.m_41613_();
            for (int i = 0; i < stackCount; ++i) {
                int emptySlot = -1;
                for (int k = 0; k < gems.size(); ++k) {
                    CompoundTag gemTag = gems.m_128728_(k);
                    if (!gemTag.m_128441_("id") || !gemTag.m_128461_("id").equals("minecraft:air")) continue;
                    emptySlot = k;
                    break;
                }
                if (emptySlot == -1) {
                    full = true;
                    break;
                }
                CompoundTag gemTag = new CompoundTag();
                gemTag.m_128344_("Count", (byte)1);
                gemTag.m_128359_("id", "apotheosis:gem");
                if (inputGemItem.m_41783_() != null) {
                    gemTag.m_128365_("tag", (Tag)inputGemItem.m_41783_().m_6426_());
                }
                gems.set(emptySlot, (Tag)gemTag);
                inputGemItems.add(inputGemItem.m_255036_(1));
            }
            if (!full) continue;
            break;
        }
        for (ItemStack inputGemItem : inputGemItems) {
            ForcedMosaicGemRecipeBuilder.inputItems((Object)inputGemItem, 1);
        }
        ForcedMosaicGemRecipeBuilder.outputItems((Object)inputAddGemItem, 1);
        ForcedMosaicGemRecipeBuilder.duration(5);
        ForcedMosaicGemRecipeBuilder.MANAt(512L);
        return ForcedMosaicGemRecipeBuilder.buildRawRecipe();
    }

    private static void ensureAffixData(ItemStack itemStack) {
        CompoundTag affixData;
        CompoundTag tag = itemStack.m_41784_();
        if (!tag.m_128441_("affix_data")) {
            affixData = new CompoundTag();
            tag.m_128365_("affix_data", (Tag)affixData);
        }
        affixData = tag.m_128469_("affix_data");
        ThePrimordialReconstructor.ensureAffixSubTags(affixData);
    }

    private static void ensureAffixSubTags(CompoundTag affixData) {
        if (!affixData.m_128441_("affixes")) {
            CompoundTag affixes = new CompoundTag();
            affixData.m_128365_("affixes", (Tag)affixes);
        }
        if (!affixData.m_128441_("gems")) {
            ListTag gems = new ListTag();
            affixData.m_128365_("gems", (Tag)gems);
        }
        if (!affixData.m_128441_("name")) {
            MutableComponent nameComponent = Component.m_237110_((String)"%2$s", (Object[])new Object[]{"", ""});
            affixData.m_128359_("name", Component.Serializer.m_130703_((Component)nameComponent));
        }
        if (!affixData.m_128441_("rarity")) {
            affixData.m_128359_("rarity", "apotheosis:common");
        }
        if (!affixData.m_128441_("sockets")) {
            affixData.m_128405_("sockets", 0);
        }
    }

    private static String getGemRarity(ItemStack gemStack) {
        CompoundTag affixData;
        CompoundTag tag;
        if (gemStack.m_41782_() && (tag = gemStack.m_41783_()) != null && !(affixData = tag.m_128469_("affix_data")).m_128456_()) {
            String rarity = affixData.m_128461_("rarity");
            return !rarity.isEmpty() ? rarity : "apotheosis:common";
        }
        return "apotheosis:common";
    }

    public static ItemStack getGem(int rarity, String gem) {
        if (rarity > 5) {
            rarity = 0;
        }
        ItemStack gemStack = new ItemStack((ItemLike)Adventure.Items.GEM.get());
        CompoundTag rootTag = new CompoundTag();
        CompoundTag affixData = new CompoundTag();
        affixData.m_128359_("rarity", RARITIES[rarity]);
        rootTag.m_128365_("affix_data", (Tag)affixData);
        rootTag.m_128359_("gem", gem);
        gemStack.m_41751_(rootTag);
        return gemStack;
    }

    private static /* synthetic */ boolean lambda$getAffixCanvasLoadRecipe$4(Set uniqueItems, ItemStack stack, long amount) {
        Item stackItem = stack.m_41720_();
        ApotheosisAffixRecord affix = ApotheosisAffixRecord.AFFIX_ITEM_MAP.get(stackItem);
        if (affix != null) {
            uniqueItems.add(stackItem);
        }
        return false;
    }
}

