/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana.multiblock;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.machine.mana.multiblock.ManaMultiblockMachine;
import com.gtolib.api.machine.feature.multiblock.IStorageMultiblock;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.utils.RegistriesUtils;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResonanceFlowerMachine
extends ManaMultiblockMachine
implements IStorageMultiblock,
IDropSaveMachine {
    @Persisted
    private double timeFluctuationCoefficient = 1.0;
    @Persisted
    private double elementalFluctuationCoefficient = 1.0;
    @Persisted
    private int stableTime = 0;
    @Persisted
    private final List<CompoundTag> recipeIncremental = new ArrayList<CompoundTag>();
    private static final int MAX_SIZE = 10;
    private static final String NBT_KEY_RECIPE_INCREMENTAL = "RecipeIncremental";
    @Persisted
    private int frequency = Integer.MAX_VALUE;
    @Persisted
    private ItemStack resonanceItem = ItemStack.f_41583_;
    @Persisted
    private FluidStack resonanceFluid = FluidStack.EMPTY;
    @Persisted
    protected final NotifiableItemStackHandler machineStorage = this.createMachineStorage(i -> i.m_41720_() == Items.f_42686_ || i.m_41720_() == GTOItems.STABILIZER_CORE.m_5456_());
    private static final String KEY_TYPE = "type";
    private static final String KEY_FREQUENCY = "frequency";
    private static final String KEY_STACK = "stack";
    private static final String KEY_AMOUNT = "Amount";
    private static final String TYPE_ITEM = "item";
    private static final String TYPE_FLUID = "fluid";

    public ResonanceFlowerMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public NotifiableItemStackHandler getMachineStorage() {
        return this.machineStorage;
    }

    @NotNull
    public Widget createUIWidget() {
        return super.createUIWidget(super.createUIWidget());
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        this.resetResonance();
        String id = recipe.id.m_135815_();
        Object[] tierEffect = this.getTierEffect(id);
        if (recipe.data.m_128441_("resonance")) {
            Object[] resonance = ResonanceFlowerMachine.fromResonanceTag(recipe.data.m_128469_("resonance"));
            Object object = resonance[0];
            if (object instanceof ItemStack) {
                ItemStack itemStack;
                this.resonanceItem = itemStack = (ItemStack)object;
                this.resonanceFluid = FluidStack.EMPTY;
            } else {
                object = resonance[0];
                if (object instanceof FluidStack) {
                    FluidStack fluidStack = (FluidStack)object;
                    this.resonanceItem = ItemStack.f_41583_;
                    this.resonanceFluid = fluidStack;
                }
            }
            this.frequency = (Integer)resonance[1];
        }
        double durationMultiplier = (double)recipe.duration * this.timeFluctuationCoefficient * (double)((Float)tierEffect[0]).floatValue();
        recipe.duration = (int)Math.max(1.0, durationMultiplier);
        long maxContentParallel = Math.min(ParallelLogic.getMaxContentParallel((IRecipeLogicMachine)this, (Recipe)recipe), (Long)tierEffect[1]);
        this.addEntry(id, maxContentParallel);
        this.upgradeEntry(id);
        this.updateStableTime();
        return ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)maxContentParallel);
    }

    public void onRecipeFinish() {
        super.onRecipeFinish();
        this.resetResonance();
        this.updateStableTime();
        if (this.stableTime > 0) {
            --this.stableTime;
        } else {
            this.triggerFluctuation();
        }
    }

    public boolean onWorking() {
        if (super.onWorking()) {
            if (this.frequency > 0 && this.getRecipeLogic().getProgress() % this.frequency == 0 && this.getRecipeLogic().getProgress() != 0) {
                if (!this.resonanceFluid.isEmpty()) {
                    return this.inputFluid(new FluidStack[]{this.resonanceFluid});
                }
                if (!this.resonanceItem.m_41619_()) {
                    return this.inputItem(new ItemStack[]{this.resonanceItem});
                }
            }
            return true;
        }
        return false;
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.resonance_flower.stable_operation_times", (Object[])new Object[]{this.stableTime}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.resonance_flower.time_fluctuation_coefficient", (Object[])new Object[]{String.format("%.6f", this.timeFluctuationCoefficient)}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.resonance_flower.elemental_fluctuation_coefficient", (Object[])new Object[]{String.format("%.6f", this.elementalFluctuationCoefficient)}));
    }

    public void saveToItem(CompoundTag tag) {
        ListTag tagList = new ListTag();
        tagList.addAll(this.recipeIncremental);
        tag.m_128365_(NBT_KEY_RECIPE_INCREMENTAL, (Tag)tagList);
    }

    public void loadFromItem(CompoundTag tag) {
        if (tag.m_128425_(NBT_KEY_RECIPE_INCREMENTAL, 9)) {
            ListTag tagList = tag.m_128437_(NBT_KEY_RECIPE_INCREMENTAL, 10);
            tagList.forEach(itemTag -> this.recipeIncremental.add((CompoundTag)itemTag));
        }
    }

    private void resetResonance() {
        this.resonanceItem = ItemStack.f_41583_;
        this.resonanceFluid = FluidStack.EMPTY;
        this.frequency = Integer.MAX_VALUE;
    }

    private void updateStableTime() {
        if (this.stableTime >= 100000000) {
            return;
        }
        ItemStack stack = this.machineStorage.getStackInSlot(0);
        if (stack.m_41619_()) {
            return;
        }
        if (stack.m_41720_() == GTOItems.STABILIZER_CORE.m_5456_()) {
            this.stableTime += 10000000;
            stack.m_41774_(1);
            this.machineStorage.setStackInSlot(0, stack);
        } else if (stack.m_41720_() == Items.f_42686_) {
            this.stableTime += 5 * stack.m_41613_();
            this.machineStorage.setStackInSlot(0, ItemStack.f_41583_);
        }
    }

    public static CompoundTag toResonanceTag(Object stack, int frequency) {
        CompoundTag root = new CompoundTag();
        root.m_128405_(KEY_FREQUENCY, frequency);
        if (stack instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)stack;
            root.m_128359_(KEY_TYPE, TYPE_ITEM);
            CompoundTag stackTag = new CompoundTag();
            itemStack.m_41739_(stackTag);
            root.m_128365_(KEY_STACK, (Tag)stackTag);
        } else if (stack instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)stack;
            root.m_128359_(KEY_TYPE, TYPE_FLUID);
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128359_("FluidName", Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)fluidStack.getFluid())).toString());
            stackTag.m_128405_(KEY_AMOUNT, fluidStack.getAmount());
            if (fluidStack.hasTag()) {
                stackTag.m_128365_("tag", (Tag)fluidStack.getTag().m_6426_());
            }
            root.m_128365_(KEY_STACK, (Tag)stackTag);
        }
        return root;
    }

    public static Object[] fromResonanceTag(CompoundTag tag) {
        Fluid fluid;
        int frequency = tag.m_128451_(KEY_FREQUENCY);
        String type = tag.m_128461_(KEY_TYPE);
        if (!tag.m_128425_(KEY_STACK, 10)) {
            return new Object[]{null, frequency};
        }
        CompoundTag stackTag = tag.m_128469_(KEY_STACK);
        ItemStack stack = null;
        if (type.equals(TYPE_ITEM)) {
            stack = ItemStack.m_41712_((CompoundTag)stackTag);
        } else if (type.equals(TYPE_FLUID) && (fluid = RegistriesUtils.getFluid((String)stackTag.m_128461_("FluidName"))) != null && fluid != Fluids.f_76191_) {
            int amount = stackTag.m_128451_(KEY_AMOUNT);
            CompoundTag extraTag = stackTag.m_128425_("tag", 10) ? stackTag.m_128469_("tag") : null;
            stack = new FluidStack(fluid, amount, extraTag);
        }
        return new Object[]{stack, frequency};
    }

    public void triggerFluctuation() {
        double newTimeMultiplier = this.timeFluctuationCoefficient * (0.2 + LDLib.random.nextDouble() * 2.4);
        this.timeFluctuationCoefficient = Mth.m_14008_((double)newTimeMultiplier, (double)0.05, (double)20.0);
        double newElemMultiplier = this.elementalFluctuationCoefficient * (0.5 + LDLib.random.nextDouble() * 1.3);
        this.elementalFluctuationCoefficient = Mth.m_14008_((double)newElemMultiplier, (double)0.1, (double)16.0);
    }

    public void addEntry(String id, long frequency) {
        if (id == null || id.isEmpty()) {
            return;
        }
        CompoundTag oldEntry = null;
        for (int i = 0; i < this.recipeIncremental.size(); ++i) {
            CompoundTag entryTag = this.recipeIncremental.get(i);
            if (!id.equals(entryTag.m_128461_("id"))) continue;
            oldEntry = entryTag;
            this.recipeIncremental.remove(i);
            break;
        }
        CompoundTag newEntry = new CompoundTag();
        newEntry.m_128359_("id", id);
        if (oldEntry != null) {
            newEntry.m_128376_("tier", oldEntry.m_128448_("tier"));
            newEntry.m_128356_(KEY_FREQUENCY, oldEntry.m_128454_(KEY_FREQUENCY) + frequency);
        } else {
            newEntry.m_128376_("tier", (short)1);
            newEntry.m_128356_(KEY_FREQUENCY, frequency);
        }
        this.recipeIncremental.add(newEntry);
        while (this.recipeIncremental.size() > 10) {
            this.recipeIncremental.removeFirst();
        }
    }

    public CompoundTag getEntryById(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (CompoundTag entryTag : this.recipeIncremental) {
            if (!id.equals(entryTag.m_128461_("id"))) continue;
            return entryTag;
        }
        return null;
    }

    public void upgradeEntry(String id) {
        long upgradeRequirement;
        CompoundTag entry = this.getEntryById(id);
        if (entry == null) {
            return;
        }
        short currentTier = entry.m_128448_("tier");
        if (currentTier >= 256) {
            return;
        }
        long currentFrequency = entry.m_128454_(KEY_FREQUENCY);
        if (currentFrequency < (upgradeRequirement = this.calculateUpgradeRequirement(currentTier))) {
            return;
        }
        entry.m_128356_(KEY_FREQUENCY, currentFrequency - upgradeRequirement);
        entry.m_128376_("tier", (short)(currentTier + 1));
    }

    private long calculateUpgradeRequirement(short currentTier) {
        if (currentTier >= 256) {
            return Long.MAX_VALUE;
        }
        if (currentTier <= 0) {
            return 10L;
        }
        if (currentTier <= 4) {
            return 10L + (long)currentTier * 100L;
        }
        if (currentTier <= 8) {
            return 410L + (long)(currentTier - 4) * 200L;
        }
        if (currentTier <= 16) {
            return 1210L + (long)(currentTier - 8) * 400L;
        }
        if (currentTier <= 32) {
            return 4410L + (long)(currentTier - 16) * 800L;
        }
        if (currentTier <= 48) {
            return 17210L + (long)(currentTier - 32) * 2600L;
        }
        if (currentTier <= 64) {
            return 58900L + (long)(currentTier - 48) * 9400L;
        }
        if (currentTier <= 96) {
            return 360000L + (long)(currentTier - 64) * 5000000L;
        }
        if (currentTier <= 128) {
            return 180000000L + (long)(currentTier - 96) * 64000000L;
        }
        if (currentTier <= 192) {
            return 2400000000L + (long)(currentTier - 128) * 800000000000000L;
        }
        return 52000000000000000L + (long)(currentTier - 192) * 140000000000000000L;
    }

    public Object[] getTierEffect(String id) {
        CompoundTag entry = this.getEntryById(id);
        short tier = entry == null ? (short)0 : entry.m_128448_("tier");
        return new Object[]{Float.valueOf(this.getTimeMultiplier(tier)), this.getMaxParallel(tier)};
    }

    public float getTimeMultiplier(short tier) {
        if (tier >= 64) {
            return 0.1f;
        }
        if (tier <= 0) {
            return 1.0f;
        }
        return tier <= 8 ? 1.0f - (float)tier * 0.025f : 0.8f - (float)(tier - 8) * 0.0125f;
    }

    public long getMaxParallel(short tier) {
        if (tier >= 256) {
            return Long.MAX_VALUE;
        }
        if (tier <= 0) {
            return 1L;
        }
        if (tier <= 4) {
            return 1L + (long)tier * 10L;
        }
        if (tier <= 8) {
            return 50L + (long)(tier - 4) * 20L;
        }
        if (tier <= 16) {
            return 200L + (long)(tier - 8) * 40L;
        }
        if (tier <= 32) {
            return 800L + (long)(tier - 16) * 80L;
        }
        if (tier <= 48) {
            return 2400L + (long)(tier - 32) * 250L;
        }
        if (tier <= 64) {
            return 8000L + (long)(tier - 48) * 800L;
        }
        if (tier <= 96) {
            return 24000L + (long)(tier - 64) * 50000L;
        }
        if (tier <= 128) {
            return 1800000L + (long)(tier - 96) * 600000L;
        }
        if (tier <= 192) {
            return 42000000L + (long)(tier - 128) * 800000000L;
        }
        return 52000000000L + (long)(tier - 192) * 140000000000L;
    }
}

