/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana.multiblock;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gtolib.api.machine.mana.feature.IManaMultiblock;
import com.gtolib.api.machine.mana.trait.ManaTrait;
import com.gtolib.api.machine.multiblock.CoilCustomParallelMultiblockMachine;
import com.gtolib.api.misc.ManaContainerList;
import com.gtolib.api.recipe.Recipe;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.item.BotaniaItems;

public final class ManaAlloyBlastSmelterMachine
extends CoilCustomParallelMultiblockMachine
implements IManaMultiblock {
    private static final Map<Integer, Item> RUNES = Map.of(1, BotaniaItems.runeWater, 2, BotaniaItems.runeFire, 3, BotaniaItems.runeAir, 4, BotaniaItems.runeEarth, 5, BotaniaItems.runeSpring, 6, BotaniaItems.runeSummer, 7, BotaniaItems.runeAutumn, 8, BotaniaItems.runeWinter);
    @Persisted
    private int tick;
    @Persisted
    private int time;
    @Persisted
    private int signal;
    private int mana;
    private final ManaTrait manaTrait = new ManaTrait((IManaMultiblock)this);

    public static Component getRunes() {
        MutableComponent c = Component.m_237119_();
        for (int i = 1; i <= 8; ++i) {
            c.m_130946_(i + ": ").m_7220_(RUNES.get(i).m_41466_()).m_130946_("\n");
        }
        return c;
    }

    public ManaAlloyBlastSmelterMachine(MetaMachineBlockEntity holder) {
        super(holder, true, true, true, m -> 16L);
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.mana = 1 << this.getTier();
    }

    public int getOutputSignal(@Nullable Direction side) {
        return this.signal;
    }

    public boolean onWorking() {
        if (super.onWorking()) {
            ++this.tick;
            if (this.time > 1) {
                --this.time;
                if (this.signal > 0) {
                    Item item = RUNES.get(this.signal);
                    AtomicBoolean success = new AtomicBoolean(false);
                    this.forEachInputItems((stack, amount) -> {
                        if (stack.m_150930_(item) && this.inputItem((ItemLike)item, 1L)) {
                            success.set(true);
                            return true;
                        }
                        return false;
                    });
                    if (success.get()) {
                        this.signal = 0;
                        this.updateSignal();
                        this.mana = 1 << this.getTier();
                        this.time = 0;
                    }
                }
            } else if (this.time == 1) {
                this.mana <<= 2;
                this.time = 0;
            }
            if (this.tick > 1200) {
                this.tick = 0;
                this.signal = GTValues.RNG.m_188503_(8) + 1;
                this.time = 200;
                this.updateSignal();
            }
            return this.removeMana(this.mana, 1, false) == (long)this.mana;
        }
        return false;
    }

    protected boolean beforeWorking(@NotNull Recipe recipe) {
        return super.beforeWorking(recipe) && this.removeMana(this.mana, 1, false) == (long)this.mana;
    }

    public void afterWorking() {
        this.signal = 0;
        this.updateSignal();
        super.afterWorking();
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237115_((String)"gtocore.recipe.mana_consumption").m_130946_(": ").m_130946_(String.valueOf(this.mana)));
    }

    @NotNull
    public ManaContainerList getManaContainer() {
        return this.manaTrait.getManaContainers();
    }

    public boolean isGeneratorMana() {
        return false;
    }
}

