/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IWailaDisplayProvider;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gtocore.common.machine.mana.CelestialHandler;
import com.gtolib.api.machine.SimpleNoEnergyMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class CelestialCondenser
extends SimpleNoEnergyMachine
implements IWailaDisplayProvider {
    private final CelestialHandler celestialHandler;
    @Persisted
    private long solaris = 0L;
    @Persisted
    private long lunara = 0L;
    @Persisted
    private long voidflux = 0L;
    @Persisted
    private long stellarm = 0L;
    private static final long MAX_CAPACITY = 1000000L;
    private CelestialHandler.Mode mode = CelestialHandler.Mode.OVERWORLD;
    private int timing;
    private boolean clearSky;
    private TickableSubscription tickSubs;

    public CelestialCondenser(MetaMachineBlockEntity holder) {
        super(holder, 1, t -> 16000, new Object[0]);
        this.celestialHandler = new CelestialHandler(1000000L);
    }

    public boolean beforeWorking(@NotNull GTRecipe recipe) {
        int solarisCost = recipe.data.m_128451_("solaris");
        int lunaraCost = recipe.data.m_128451_("lunara");
        int voidfluxCost = recipe.data.m_128451_("voidflux");
        int stellarmCost = recipe.data.m_128451_("stellarm");
        int anyCost = recipe.data.m_128451_("any");
        CelestialHandler.ResourceResult deductResult = null;
        if (solarisCost > 0) {
            deductResult = this.celestialHandler.deductResource("solaris", solarisCost, 1L, this.solaris, this.lunara, this.voidflux, this.stellarm);
        } else if (lunaraCost > 0) {
            deductResult = this.celestialHandler.deductResource("lunara", lunaraCost, 1L, this.solaris, this.lunara, this.voidflux, this.stellarm);
        } else if (voidfluxCost > 0) {
            deductResult = this.celestialHandler.deductResource("voidflux", voidfluxCost, 1L, this.solaris, this.lunara, this.voidflux, this.stellarm);
        } else if (stellarmCost > 0) {
            deductResult = this.celestialHandler.deductResource("stellarm", stellarmCost, 1L, this.solaris, this.lunara, this.voidflux, this.stellarm);
        } else if (anyCost > 0) {
            deductResult = this.celestialHandler.deductResource("ANY", anyCost, 1L, this.solaris, this.lunara, this.voidflux, this.stellarm);
        }
        if (deductResult == null || !deductResult.success()) {
            return false;
        }
        this.solaris = deductResult.solaris();
        this.lunara = deductResult.lunara();
        this.voidflux = deductResult.voidflux();
        this.stellarm = deductResult.stellarm();
        return true;
    }

    public void onLoad() {
        super.onLoad();
        this.mode = this.celestialHandler.initMode(this.getLevel());
        if (!this.isRemote()) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tickUpdate, 10);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    private void tickUpdate() {
        Level world = this.getLevel();
        if (world == null) {
            return;
        }
        BlockPos pos = this.getPos();
        if (this.timing == 0) {
            this.getRecipeLogic().updateTickSubscription();
            this.clearSky = CelestialCondenser.hasClearSky(world, pos);
            this.timing = 40;
        } else if (this.timing % 10 == 0) {
            this.clearSky = CelestialCondenser.hasClearSky(world, pos);
            --this.timing;
        } else {
            --this.timing;
        }
        if (this.clearSky) {
            CelestialHandler.Resource updatedResources = this.celestialHandler.increase(world, 1, this.solaris, this.lunara, this.voidflux, this.stellarm, this.mode);
            this.solaris = updatedResources.solaris();
            this.lunara = updatedResources.lunara();
            this.voidflux = updatedResources.voidflux();
            this.stellarm = updatedResources.stellarm();
        }
    }

    private static boolean hasClearSky(Level world, BlockPos pos) {
        BlockPos checkPos = pos.m_7494_();
        if (!CelestialCondenser.canSeeSky(world, pos)) {
            return false;
        }
        if (world.m_46472_() == Level.f_46430_) {
            return true;
        }
        Biome biome = (Biome)world.m_204166_(checkPos).m_203334_();
        boolean hasPrecipitation = world.m_46471_() && (biome.m_198906_(checkPos) || biome.m_198904_(checkPos));
        return !hasPrecipitation;
    }

    private static boolean canSeeSky(Level world, BlockPos blockPos) {
        int maxY = world.m_151558_();
        BlockPos.MutableBlockPos checkPos = blockPos.m_122032_().m_122173_(Direction.UP);
        while (checkPos.m_123342_() < maxY) {
            if (!world.m_8055_((BlockPos)checkPos).m_60734_().equals(Blocks.f_50016_)) {
                return false;
            }
            checkPos.m_122173_(Direction.UP);
        }
        return true;
    }

    public void appendWailaTooltip(CompoundTag data, ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        long solaris = data.m_128454_("solaris");
        long lunara = data.m_128454_("lunara");
        long voidflux = data.m_128454_("voidflux");
        long stellarm = data.m_128454_("stellarm");
        long maxCapacity = data.m_128454_("max_capacity");
        if (solaris > 0L) {
            iTooltip.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.solaris", (Object[])new Object[]{solaris + "/" + maxCapacity}));
        }
        if (lunara > 0L) {
            iTooltip.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.lunara", (Object[])new Object[]{lunara + "/" + maxCapacity}));
        }
        if (voidflux > 0L) {
            iTooltip.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.voidflux", (Object[])new Object[]{voidflux + "/" + maxCapacity}));
        }
        if (stellarm > 0L) {
            iTooltip.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.stellarm", (Object[])new Object[]{stellarm + "/" + maxCapacity}));
        }
    }

    public void appendWailaData(CompoundTag data, BlockAccessor blockAccessor) {
        data.m_128356_("solaris", this.solaris);
        data.m_128356_("lunara", this.lunara);
        data.m_128356_("voidflux", this.voidflux);
        data.m_128356_("stellarm", this.stellarm);
        data.m_128356_("max_capacity", 1000000L);
    }

    @Generated
    public long getSolaris() {
        return this.solaris;
    }

    @Generated
    public long getLunara() {
        return this.lunara;
    }

    @Generated
    public long getVoidflux() {
        return this.voidflux;
    }

    @Generated
    public long getStellarm() {
        return this.stellarm;
    }
}

