/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.generator;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gtolib.api.annotation.Scanned;
import com.gtolib.api.annotation.dynamic.DynamicInitialValue;
import com.gtolib.utils.GTOUtils;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Scanned
public final class LightningRodMachine
extends TieredEnergyMachine {
    private TickableSubscription energySubs;
    @DynamicInitialValue(typeKey="probability", key="lightning_rod.break_probability", easyValue="0.2D", normalValue="0.3D", expertValue="0.4D", cn="\u96f7\u51fb\u6746\u7834\u574f\u6982\u7387", cnComment="\u96f7\u51fb\u6746\u88ab\u96f7\u51fb\u540e\uff0c\u88ab\u7834\u574f\u7684\u6982\u7387\u4e3a%s\u3002", en="Lightning Rod Break Probability", enComment="Probability of the lightning rod being destroyed after being struck by lightning: %s.")
    private static double breakProbability = 1.0;

    public LightningRodMachine(MetaMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, args);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.energySubs = this.subscribeServerTick(this.energySubs, this::checkEnergy, 10);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.energySubs != null) {
            this.energySubs.unsubscribe();
            this.energySubs = null;
        }
    }

    private void checkEnergy() {
        BlockState state = Objects.requireNonNull(this.getLevel()).m_8055_(this.getPos().m_7918_(0, 1, 0));
        if (state.m_60734_() == Blocks.f_152587_ && state.m_61143_((Property)BlockStateProperties.f_61372_) == Direction.UP && ((Boolean)state.m_61143_((Property)LightningRodBlock.f_153703_)).booleanValue()) {
            if (this.energyContainer.getEnergyStored() == this.getCharge()) {
                this.doExplosion(this.getTier());
            } else {
                this.energyContainer.addEnergy(this.getCharge() / 2L + (long)GTValues.RNG.m_188502_());
            }
            if (GTOUtils.probability((double)breakProbability)) {
                this.getLevel().m_46597_(this.getPos().m_7918_(0, 1, 0), Blocks.f_50016_.m_49966_());
            }
        }
    }

    protected boolean isEnergyEmitter() {
        return true;
    }

    protected long getMaxInputOutputAmperage() {
        return 256L;
    }

    private long getCharge() {
        return 24414L * (1L << 2 * this.getTier());
    }

    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        NotifiableEnergyContainer energyContainer = NotifiableEnergyContainer.emitterContainer((MetaMachine)this, (long)this.getCharge(), (long)GTValues.V[this.getTier() - 1], (long)this.getMaxInputOutputAmperage());
        energyContainer.setSideOutputCondition(side -> !this.hasFrontFacing() || side == this.getFrontFacing());
        return energyContainer;
    }

    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    public static double getBreakProbability() {
        return breakProbability;
    }
}

