/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.WorkableTieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.api.machine.feature.IHeaterMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.gtolib.api.machine.trait.NotifiableSafeEnergyContainer;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import net.minecraft.core.Direction;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ElectricHeaterMachine
extends WorkableTieredMachine
implements IHeaterMachine {
    public static final int MaxTemperature = 1200;
    @Persisted
    @DescSynced
    @RequireRerender
    private int temperature = 273;
    private TickableSubscription tickSubs;

    public ElectricHeaterMachine(MetaMachineBlockEntity holder) {
        super(holder, 1, t -> 8000, new Object[0]);
    }

    @NotNull
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        long tierVoltage = GTValues.V[this.tier];
        return new NotifiableSafeEnergyContainer((MetaMachine)this, tierVoltage << 6, tierVoltage, this.getMaxInputOutputAmperage());
    }

    @NotNull
    protected NotifiableFluidTank createImportFluidHandler(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 0, 0, IO.IN);
    }

    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        return null;
    }

    @Nullable
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        return null;
    }

    @Nullable
    private Recipe getRecipe() {
        if (this.temperature >= 1200) {
            return null;
        }
        Recipe recipe = IEnhancedRecipeLogic.of((RecipeLogic)this.getRecipeLogic()).gtolib$getRecipeBuilder().duration(20).EUt(30L).buildRawRecipe();
        if (RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
            return recipe;
        }
        return null;
    }

    @NotNull
    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }

    @NotNull
    public GTRecipeType getRecipeType() {
        return GTORecipeTypes.MANA_HEATER_RECIPES;
    }

    public int getOutputSignal(@Nullable Direction side) {
        return this.getSignal(side);
    }

    public boolean canConnectRedstone(@NotNull Direction side) {
        return true;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, () -> {
                this.tickUpdate();
                this.getRecipeLogic().updateTickSubscription();
            }, 20);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    public boolean onWorking() {
        if (super.onWorking()) {
            if (this.getOffsetTimer() % 10 == 0 && 1200 > this.temperature + 4) {
                this.raiseTemperature(4);
            }
            return true;
        }
        return false;
    }

    public int getHeatCapacity() {
        return 6;
    }

    public int getMaxTemperature() {
        return 1200;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    public int getTemperature() {
        return this.temperature;
    }
}

