/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gtocore.api.gui.graphic.GTOToolTipComponent;
import com.gtocore.api.gui.graphic.GTOTooltipComponentItem;
import com.gtocore.api.gui.graphic.impl.GTOComponentTooltipComponent;
import com.gtocore.api.lang.ComponentListSupplier;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.translation.GTOItemTooltips;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.feature.IUpgradeMachine;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.NotNull;

@DataGeneratorScanned
public final class UpgradeModuleItem
extends Item
implements GTOTooltipComponentItem {
    @RegisterLanguage(cn="\u9700\u898110\u7ea7\u7ecf\u9a8c", en="Requires 10 levels of experience")
    public static final String experience_not_enough = "gtocore.machine.upgrade.experience_not_enough";

    public UpgradeModuleItem(Item.Properties properties) {
        super(properties);
    }

    private static ItemStack speed(int tier) {
        ItemStack item = ((UpgradeModuleItem)GTOItems.SPEED_UPGRADE_MODULE.get()).m_7968_();
        item.m_41784_().m_128347_("speed", UpgradeModuleItem.randomMultiple(tier));
        return item;
    }

    private static ItemStack energy(int tier) {
        ItemStack item = ((UpgradeModuleItem)GTOItems.ENERGY_UPGRADE_MODULE.get()).m_7968_();
        item.m_41784_().m_128347_("energy", UpgradeModuleItem.randomMultiple(tier));
        return item;
    }

    private static double randomMultiple(int tier) {
        return 1.0 - GTValues.RNG.m_188500_() / (20.0 / (double)tier);
    }

    @NotNull
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player instanceof ServerPlayer) {
            ItemStack item = player.m_21120_(context.m_43724_());
            CompoundTag tag = item.m_41783_();
            if (tag != null) {
                IUpgradeMachine upgradeMachine;
                MetaMachine machine = MetaMachine.getMachine((BlockGetter)context.m_43725_(), (BlockPos)context.m_8083_());
                if (machine instanceof IUpgradeMachine && (upgradeMachine = (IUpgradeMachine)machine).gtolib$canUpgraded()) {
                    if (tag.m_128441_("speed")) {
                        double speed = upgradeMachine.gtolib$getSpeed();
                        speed = speed < 1.0 ? Math.max(speed, UpgradeModuleItem.randomMultiple(10)) * tag.m_128459_("speed") : tag.m_128459_("speed");
                        upgradeMachine.gtolib$setSpeed(Math.max(0.5, speed));
                        player.m_21008_(context.m_43724_(), item.m_255036_(item.m_41613_() - 1));
                        return InteractionResult.CONSUME;
                    }
                    if (tag.m_128441_("energy")) {
                        double energy = upgradeMachine.gtolib$getEnergy();
                        energy = energy < 1.0 ? Math.max(energy, UpgradeModuleItem.randomMultiple(10)) * tag.m_128459_("energy") : tag.m_128459_("energy");
                        upgradeMachine.gtolib$setEnergy(Math.max(0.5, energy));
                        player.m_21008_(context.m_43724_(), item.m_255036_(item.m_41613_() - 1));
                        return InteractionResult.CONSUME;
                    }
                }
            } else if (player.f_36078_ > 10) {
                player.m_21008_(context.m_43724_(), item.m_255036_(item.m_41613_() - 1));
                ItemStack itemStack = this == GTOItems.SPEED_UPGRADE_MODULE.get() ? UpgradeModuleItem.speed(Math.min(10, player.f_36078_ / 10)) : UpgradeModuleItem.energy(Math.min(10, player.f_36078_ / 10));
                player.f_36078_ = 0;
                player.f_36079_ = 0;
                context.m_43725_().m_7967_((Entity)new ItemEntity(context.m_43725_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), itemStack));
            } else {
                player.m_213846_((Component)Component.m_237115_((String)experience_not_enough));
                return InteractionResult.PASS;
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    @Override
    public void attachGTOTooltip(ItemStack itemStack, List<GTOToolTipComponent> tooltips) {
        block8: {
            block7: {
                CompoundTag tag = itemStack.m_41783_();
                if (tag == null) break block7;
                if (tag.m_128441_("speed")) {
                    for (Component component : ((ComponentListSupplier)GTOItemTooltips.INSTANCE.getSpeedUpgradeModuleTooltips().invoke((Object)Math.max(0.5, tag.m_128459_("speed")), (Object)tag.m_128459_("speed"))).getArray()) {
                        tooltips.add(new GTOComponentTooltipComponent(component));
                    }
                }
                if (!tag.m_128441_("energy")) break block8;
                for (Component component : ((ComponentListSupplier)GTOItemTooltips.INSTANCE.getEnergyUpgradeModuleTooltips().invoke((Object)Math.max(0.5, tag.m_128459_("energy")), (Object)tag.m_128459_("energy"))).getArray()) {
                    tooltips.add(new GTOComponentTooltipComponent(component));
                }
                break block8;
            }
            if (this == GTOItems.SPEED_UPGRADE_MODULE.get()) {
                for (Component component : ((ComponentListSupplier)GTOItemTooltips.INSTANCE.getSpeedUpgradeModuleTooltips().invoke((Object)0.0, (Object)0.0)).getArray()) {
                    tooltips.add(new GTOComponentTooltipComponent(component));
                }
            } else {
                for (Component component : ((ComponentListSupplier)GTOItemTooltips.INSTANCE.getEnergyUpgradeModuleTooltips().invoke((Object)0.0, (Object)0.0)).getArray()) {
                    tooltips.add(new GTOComponentTooltipComponent(component));
                }
            }
        }
    }

    static {
        if (GTCEu.isDataGen()) {
            ((ComponentListSupplier)GTOItemTooltips.INSTANCE.getSpeedUpgradeModuleTooltips().invoke((Object)0.0, (Object)0.0)).getArray();
            ((ComponentListSupplier)GTOItemTooltips.INSTANCE.getEnergyUpgradeModuleTooltips().invoke((Object)0.0, (Object)0.0)).getArray();
        }
    }
}

