/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import appeng.util.InteractionUtil;
import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gtocore.common.machine.tesseract.ITesseractMarkerInteractable;
import com.gtocore.common.machine.tesseract.TesseractDirectedTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class TesseractTargetMarker
implements IInteractionItem {
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        if (TesseractTargetMarker.isTesseractTargetMarker(itemStack)) {
            Player player = context.m_43723_();
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            Direction face = context.m_43719_();
            if (level.m_5776_() || player == null) {
                return InteractionResult.PASS;
            }
            if (player.m_6144_()) {
                if (!TesseractTargetMarker.removePatternFace(itemStack, (ResourceKey<Level>)level.m_46472_(), pos, face)) {
                    return InteractionResult.PASS;
                }
            } else {
                TesseractTargetMarker.addPatternFace(itemStack, (ResourceKey<Level>)level.m_46472_(), pos, face, true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(itemStack, context);
    }

    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack;
        if (player.m_6144_() && InteractionUtil.rayTrace((Player)player, (boolean)true, (boolean)false).m_6662_() == HitResult.Type.MISS && TesseractTargetMarker.isTesseractTargetMarker(itemStack = player.m_21120_(usedHand))) {
            TesseractTargetMarker.clearAllPatternFaces(itemStack);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        return super.use(item, level, player, usedHand);
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack itemStack = event.getEntity().m_21205_();
        if (TesseractTargetMarker.isTesseractTargetMarker(itemStack)) {
            Player player = event.getEntity();
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            Direction face = event.getFace();
            event.setCanceled(true);
            if (level.m_5776_() || player == null) {
                event.setCancellationResult(InteractionResult.PASS);
                return;
            }
            if (player.m_6144_()) {
                ITesseractMarkerInteractable interactable;
                MetaMachineBlockEntity mbe;
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof MetaMachineBlockEntity && (blockEntity = (mbe = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof ITesseractMarkerInteractable && (interactable = (ITesseractMarkerInteractable)blockEntity).onMarkerInteract(player, TesseractTargetMarker.getAllPatternFaces(itemStack))) {
                    event.setCancellationResult(InteractionResult.SUCCESS);
                } else {
                    event.setCancellationResult(InteractionResult.PASS);
                }
                return;
            }
            TesseractTargetMarker.addPatternFace(itemStack, (ResourceKey<Level>)level.m_46472_(), pos, face, false);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    public static boolean isTesseractTargetMarker(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ComponentItem) {
            ComponentItem c = (ComponentItem)item;
            return c.getComponents().stream().anyMatch(comp -> comp instanceof TesseractTargetMarker);
        }
        return false;
    }

    private static List<PatternFaceUnindexed> getFromNBT(ItemStack stack, boolean positive) {
        String key = positive ? "positive" : "negative";
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_(key)) {
            ListTag list = nbt.m_128437_(key, 10);
            ArrayList<PatternFaceUnindexed> result = new ArrayList<PatternFaceUnindexed>();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entry = list.m_128728_(i);
                ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.parse((String)entry.m_128461_("dim")));
                BlockPos pos = BlockPos.m_122022_((long)entry.m_128454_("pos"));
                Direction face = Direction.m_122376_((int)entry.m_128451_("face"));
                result.add(new PatternFaceUnindexed(GlobalPos.m_122643_((ResourceKey)dim, (BlockPos)pos), face));
            }
            return result;
        }
        return new ArrayList<PatternFaceUnindexed>();
    }

    private static void putToNBT(ItemStack stack, boolean positive, List<PatternFaceUnindexed> patternFaces) {
        String key = positive ? "positive" : "negative";
        CompoundTag nbt = stack.m_41784_();
        ListTag list = new ListTag();
        for (PatternFaceUnindexed pf : patternFaces) {
            CompoundTag entry = new CompoundTag();
            entry.m_128359_("dim", pf.pos().m_122640_().m_135782_().toString());
            entry.m_128356_("pos", pf.pos().m_122646_().m_121878_());
            entry.m_128405_("face", pf.face().m_122411_());
            list.add((Object)entry);
        }
        nbt.m_128365_(key, (Tag)list);
    }

    public static void addPatternFace(ItemStack stack, ResourceKey<Level> dimension, BlockPos pos, Direction face, boolean addToPositive) {
        GlobalPos globalPos = GlobalPos.m_122643_(dimension, (BlockPos)pos);
        PatternFaceUnindexed patternFace = new PatternFaceUnindexed(globalPos, face);
        List<PatternFaceUnindexed> patternFaces = TesseractTargetMarker.getFromNBT(stack, addToPositive);
        List<PatternFaceUnindexed> patternFacesF = TesseractTargetMarker.getFromNBT(stack, !addToPositive);
        if (!patternFaces.contains(patternFace) && !patternFacesF.contains(patternFace)) {
            patternFaces.add(patternFace);
            TesseractTargetMarker.putToNBT(stack, addToPositive, patternFaces);
        }
    }

    public static boolean removePatternFace(ItemStack stack, ResourceKey<Level> dimension, BlockPos pos, Direction face) {
        boolean removed;
        GlobalPos globalPos = GlobalPos.m_122643_(dimension, (BlockPos)pos);
        PatternFaceUnindexed patternFace = new PatternFaceUnindexed(globalPos, face);
        List<PatternFaceUnindexed> patternFacesPositive = TesseractTargetMarker.getFromNBT(stack, true);
        List<PatternFaceUnindexed> patternFacesNegative = TesseractTargetMarker.getFromNBT(stack, false);
        boolean bl = removed = patternFacesPositive.remove(patternFace) || patternFacesNegative.remove(patternFace);
        if (removed) {
            TesseractTargetMarker.putToNBT(stack, true, patternFacesPositive);
            TesseractTargetMarker.putToNBT(stack, false, patternFacesNegative);
        }
        return removed;
    }

    public static void clearAllPatternFaces(ItemStack stack) {
        TesseractTargetMarker.putToNBT(stack, true, new ArrayList<PatternFaceUnindexed>());
        TesseractTargetMarker.putToNBT(stack, false, new ArrayList<PatternFaceUnindexed>());
    }

    public static List<TesseractDirectedTarget> getAllPatternFaces(ItemStack stack) {
        ImmutableList.Builder result = ImmutableList.builder();
        int index = 0;
        for (PatternFaceUnindexed pf : TesseractTargetMarker.getFromNBT(stack, true)) {
            result.add((Object)new TesseractDirectedTarget(pf.pos(), pf.face(), ++index));
        }
        index = 0;
        for (PatternFaceUnindexed pf : TesseractTargetMarker.getFromNBT(stack, false)) {
            result.add((Object)new TesseractDirectedTarget(pf.pos(), pf.face(), -(++index)));
        }
        return result.build();
    }

    private record PatternFaceUnindexed(GlobalPos pos, Direction face) implements Comparable<PatternFaceUnindexed>
    {
        @Override
        public int compareTo(@NotNull PatternFaceUnindexed o) {
            int i = this.pos.m_122646_().compareTo((Vec3i)o.pos.m_122646_());
            if (i != 0) {
                return i;
            }
            return Integer.compare(this.face.ordinal(), o.face.ordinal());
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatternFaceUnindexed that = (PatternFaceUnindexed)o;
            return Objects.equals(this.pos(), that.pos()) && this.face() == that.face();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.pos(), this.face());
        }
    }
}

