/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.api.gui.widget.ProspectingMapWidget;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IItemLifeCycle;
import com.gregtechceu.gtceu.api.item.component.forge.IComponentCapability;
import com.gregtechceu.gtceu.common.item.ProspectorScannerBehavior;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.handler.BotaniaSounds;

public final class ManaProspectorBehavior
extends ProspectorScannerBehavior
implements IComponentCapability,
IItemLifeCycle,
IDurabilityBar {
    private static final String MANA_KEY = "mana";
    private static final int CONSUMPTION_PER_TICK = 40;
    private static final int CONSUMPTION_PER_CHUNK = 500;
    private final int radius;
    private int maxMana;
    private double costMultiplier;
    public static final Tier ULV = new Tier(1, new ProspectorMode[]{ProspectorMode.ORE}, 500000, 1.0);
    public static final Tier LV = new Tier(2, new ProspectorMode[]{ProspectorMode.ORE, ProspectorMode.FLUID}, 2000000, 0.8);
    public static final Tier HV = new Tier(3, new ProspectorMode[]{ProspectorMode.ORE, ProspectorMode.FLUID, ProspectorMode.BEDROCK_ORE}, 8000000, 0.6);

    private ManaProspectorBehavior(int radius, ProspectorMode<?> ... modes) {
        super(radius, 0L, modes);
        this.radius = radius;
    }

    public static ManaProspectorBehavior create(Tier tier) {
        ManaProspectorBehavior behavior = new ManaProspectorBehavior(tier.radius, tier.modes);
        behavior.maxMana = tier.maxMana;
        behavior.costMultiplier = tier.manaCostMultiplier;
        return behavior;
    }

    private static int getMana(ItemStack stack) {
        return stack.m_41784_().m_128451_(MANA_KEY);
    }

    private static void addMana(ItemStack stack, int mana) {
        stack.m_41784_().m_128405_(MANA_KEY, Math.max(0, ManaProspectorBehavior.getMana(stack) + mana));
    }

    private static boolean checkAndConsumeMana(ItemStack stack, int consumption) {
        if (ManaProspectorBehavior.getMana(stack) < consumption) {
            return false;
        }
        ManaProspectorBehavior.addMana(stack, -consumption);
        return true;
    }

    private static void preCancelScan(Player player, ItemStack stack) {
        player.m_5496_(BotaniaSounds.gaiaTeleport, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
        player.m_213846_((Component)Component.m_237115_((String)"behavior.prospector.not_enough_energy"));
        player.m_6915_();
    }

    public boolean drainEnergy(@NotNull ItemStack stack, boolean simulate) {
        int consumption = (int)(500.0 * this.costMultiplier);
        if (ManaProspectorBehavior.getMana(stack) < consumption) {
            return false;
        }
        if (!simulate) {
            ManaProspectorBehavior.addMana(stack, -consumption);
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!player.m_6144_() && (double)ManaProspectorBehavior.getMana(stack) < 500.0 * this.costMultiplier * (double)this.radius * (double)this.radius) {
            ManaProspectorBehavior.preCancelScan(player, stack);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return super.use(item, level, player, usedHand);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        AbstractContainerMenu abstractContainerMenu;
        Player player;
        if (level.m_46467_() % 10L != 0L || level.m_5776_()) {
            return;
        }
        if (entity instanceof Player && !(player = (Player)entity).m_7500_() && isSelected && (abstractContainerMenu = player.f_36096_) instanceof ModularUIContainer) {
            ModularUIContainer ui = (ModularUIContainer)abstractContainerMenu;
            if (ui.getModularUI().getFlatVisibleWidgetCollection().stream().anyMatch(ProspectingMapWidget.class::isInstance) && !ManaProspectorBehavior.checkAndConsumeMana(stack, (int)(400.0 * this.costMultiplier))) {
                ManaProspectorBehavior.preCancelScan(player, stack);
                player.m_6915_();
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(final ItemStack itemStack, @NotNull Capability<T> cap) {
        if (cap == BotaniaForgeCapabilities.MANA_ITEM) {
            return BotaniaForgeCapabilities.MANA_ITEM.orEmpty(cap, LazyOptional.of(() -> new ManaItem(){

                public int getMana() {
                    return ManaProspectorBehavior.getMana(itemStack);
                }

                public int getMaxMana() {
                    return ManaProspectorBehavior.this.maxMana;
                }

                public void addMana(int mana) {
                    ManaProspectorBehavior.addMana(itemStack, mana);
                }

                public boolean canReceiveManaFromPool(BlockEntity pool) {
                    return true;
                }

                public boolean canReceiveManaFromItem(ItemStack otherStack) {
                    return true;
                }

                public boolean canExportManaToPool(BlockEntity pool) {
                    return false;
                }

                public boolean canExportManaToItem(ItemStack otherStack) {
                    return false;
                }

                public boolean isNoExport() {
                    return true;
                }
            }));
        }
        return LazyOptional.empty();
    }

    public void appendTooltips(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendTooltips(stack, level, tooltipComponents, isAdvanced);
        int mana = ManaProspectorBehavior.getMana(stack);
        String formattedManaPool = String.format("%.2f", (double)mana / 1000000.0);
        String formattedMaxMana = String.format("%.2f", (double)this.maxMana / 1000000.0);
        tooltipComponents.add((Component)Component.m_237110_((String)"gtocore.tooltip.item.prospector.mana.1", (Object[])new Object[]{FormattingUtil.formatNumbers((int)mana), FormattingUtil.formatNumbers((int)this.maxMana)}));
        tooltipComponents.add((Component)Component.m_237110_((String)"gtocore.tooltip.item.prospector.mana.2", (Object[])new Object[]{formattedManaPool, formattedMaxMana}));
    }

    public float getDurabilityForDisplay(ItemStack stack) {
        return Mth.m_14036_((float)((float)ManaProspectorBehavior.getMana(stack) / (float)this.maxMana), (float)0.0f, (float)1.0f);
    }

    public int getMaxDurability(ItemStack stack) {
        return this.maxMana;
    }

    public int getBarColor(ItemStack stack) {
        return 10022399;
    }

    public record Tier(int radius, ProspectorMode<?>[] modes, int maxMana, double manaCostMultiplier) {
    }
}

