/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.fast.fastcollection.O2IOpenCacheHashMap;
import com.gregtechceu.gtceu.core.mixins.StrictNBTIngredientAccessor;
import com.gtocore.api.placeholder.IPlaceholder;
import com.gtolib.IItem;
import com.gtolib.api.recipe.lookup.IngredientConverter;
import com.gtolib.api.recipe.lookup.MapIngredient;
import com.gtolib.utils.FluidUtils;
import com.gtolib.utils.ItemUtils;
import com.gtolib.utils.RLUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import kotlin.Unit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public final class DiscItem
extends Item
implements IPlaceholder<Object, ItemStack, Unit> {
    private static Item DATA_DISC;
    private static final Object2IntOpenHashMap<String> NBTS;
    public static final IngredientConverter<Ingredient> INGREDIENT_CONVERTER;
    public static final IngredientConverter<ItemStack> ITEM_CONVERTER;
    private static final Object EMPTY_CONTENT;

    public DiscItem(Item.Properties properties) {
        super(properties);
        DATA_DISC = this;
    }

    public ItemStack getDisc(ItemStack itemStack) {
        ItemStack stack = this.m_7968_();
        ResourceLocation id = ItemUtils.getIdLocation((Item)itemStack.m_41720_());
        stack.m_41784_().m_128359_("i", id.m_135827_());
        stack.m_41784_().m_128359_("n", id.m_135815_());
        NBTS.computeIfAbsent((Object)id.m_135815_(), k -> MapIngredient.getCount(null));
        return stack;
    }

    public ItemStack getDisc(Fluid fluid) {
        ItemStack stack = this.m_7968_();
        ResourceLocation id = FluidUtils.getIdLocation((Fluid)fluid);
        stack.m_41784_().m_128359_("f", id.m_135827_());
        stack.m_41784_().m_128359_("n", id.m_135815_());
        NBTS.computeIfAbsent((Object)id.m_135815_(), k -> MapIngredient.getCount(null));
        return stack;
    }

    private static Optional<Item> getStoredItem(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Optional.empty();
        }
        String namespace = tag.m_128461_("i");
        if (!namespace.isEmpty()) {
            ResourceLocation id = RLUtils.fromNamespaceAndPath((String)namespace, (String)tag.m_128461_("n"));
            return Optional.ofNullable((Item)ForgeRegistries.ITEMS.getValue(id)).filter(item -> item != Items.f_41852_);
        }
        return Optional.empty();
    }

    private static Optional<Fluid> getStoredFluid(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Optional.empty();
        }
        String namespace = tag.m_128461_("f");
        if (!namespace.isEmpty()) {
            ResourceLocation id = RLUtils.fromNamespaceAndPath((String)namespace, (String)tag.m_128461_("n"));
            return Optional.ofNullable((Fluid)ForgeRegistries.FLUIDS.getValue(id)).filter(fluid -> fluid != Fluids.f_76191_);
        }
        return Optional.empty();
    }

    @NotNull
    private static Object getStoredContent(ItemStack discStack) {
        Optional<Item> itemOpt = DiscItem.getStoredItem(discStack);
        if (itemOpt.isPresent()) {
            return ((IItem)itemOpt.get()).gtolib$getReadOnlyStack();
        }
        Optional<Fluid> fluidOpt = DiscItem.getStoredFluid(discStack);
        if (fluidOpt.isPresent()) {
            return new FluidStack(fluidOpt.get(), 1);
        }
        return EMPTY_CONTENT;
    }

    public void m_7373_(@NotNull ItemStack itemstack, @Nullable Level world, @NotNull List<Component> list, @NotNull TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        Optional<Item> storedItem = DiscItem.getStoredItem(itemstack);
        if (storedItem.isPresent()) {
            list.add((Component)Component.m_237110_((String)"item.gtocore.disc.data", (Object[])new Object[]{((IItem)storedItem.get()).gtolib$getReadOnlyStack().m_41611_()}));
        } else {
            DiscItem.getStoredFluid(itemstack).ifPresent(fluid -> list.add((Component)Component.m_237110_((String)"item.gtocore.disc.data", (Object[])new Object[]{"[" + new FluidStack(fluid, 1).getDisplayName().getString() + "]"})));
        }
    }

    @Override
    @NotNull
    public List<List<Object>> getTargetLists(@NotNull ItemStack sourceDisc) {
        Object content = DiscItem.getStoredContent(sourceDisc);
        if (content.equals(EMPTY_CONTENT)) {
            return Collections.emptyList();
        }
        return List.of(List.of(content));
    }

    @Override
    @Nullable
    public Object getCurrentTarget(@NotNull ItemStack sourceDisc, Unit context) {
        Object content = DiscItem.getStoredContent(sourceDisc);
        if (content.equals(EMPTY_CONTENT)) {
            return null;
        }
        return content;
    }

    static {
        NBTS = new O2IOpenCacheHashMap();
        INGREDIENT_CONVERTER = (ingredient, amount, map) -> {
            Object patt0$temp;
            StrictNBTIngredientAccessor nbtIngredient;
            CompoundTag nbt;
            if (ingredient instanceof StrictNBTIngredientAccessor && (nbt = (nbtIngredient = (StrictNBTIngredientAccessor)ingredient).getStack().m_41783_()) != null && nbtIngredient.getStack().m_41720_() == DATA_DISC && (patt0$temp = nbt.f_128329_.get("n")) instanceof StringTag) {
                StringTag stringTag = (StringTag)patt0$temp;
                int in = NBTS.getInt((Object)stringTag.m_7916_());
                map.add(in, amount);
                return;
            }
            MapIngredient.INGREDIENT_CONVERTER.convert(ingredient, amount, map);
        };
        ITEM_CONVERTER = (stack, amount, map) -> {
            Object patt0$temp;
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null && stack.m_41720_() == DATA_DISC && (patt0$temp = nbt.f_128329_.get("n")) instanceof StringTag) {
                StringTag stringTag = (StringTag)patt0$temp;
                map.add(NBTS.getInt((Object)stringTag.m_7916_()), amount);
                return;
            }
            MapIngredient.ITEM_CONVERTER.convert(stack, amount, map);
        };
        EMPTY_CONTENT = ItemStack.f_41583_;
    }
}

