/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.fast.fastcollection.O2IOpenCacheHashMap;
import com.gregtechceu.gtceu.api.data.DimensionMarker;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.core.mixins.StrictNBTIngredientAccessor;
import com.gtolib.api.recipe.lookup.IngredientConverter;
import com.gtolib.api.recipe.lookup.MapIngredient;
import com.gtolib.utils.RLUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public final class DimensionDataItem
extends Item {
    private static Item DIMENSION_DATA;
    private static final Object2IntOpenHashMap<String> NBTS;
    public static final IngredientConverter<Ingredient> INGREDIENT_CONVERTER;
    public static final IngredientConverter<ItemStack> ITEM_CONVERTER;

    public DimensionDataItem(Item.Properties properties) {
        super(properties);
        DIMENSION_DATA = this;
    }

    public ItemStack getDimensionData(ResourceLocation resourceLocation) {
        ItemStack stack = this.m_7968_();
        stack.m_41784_().m_128359_("dim", resourceLocation.toString());
        NBTS.computeIfAbsent((Object)resourceLocation.toString(), k -> MapIngredient.getCount(null));
        return stack;
    }

    public static ResourceLocation getDimension(ItemStack stack) {
        return RLUtils.parse((String)stack.m_41784_().m_128461_("dim"));
    }

    public static DimensionMarker getDimensionMarker(ItemStack stack) {
        ResourceLocation resourceLocation = DimensionDataItem.getDimension(stack);
        return (DimensionMarker)GTRegistries.DIMENSION_MARKERS.getOrDefault((Object)resourceLocation, (Object)new DimensionMarker(99, () -> Blocks.f_50375_, resourceLocation.toString()));
    }

    public void m_7373_(@NotNull ItemStack itemstack, @Nullable Level world, @NotNull List<Component> list, @NotNull TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        if (itemstack.m_41782_()) {
            list.add((Component)Component.m_237110_((String)"recipe.condition.dimension.tooltip", (Object[])new Object[]{DimensionDataItem.getDimensionMarker(itemstack).getIcon().m_41611_()}));
        }
    }

    static {
        NBTS = new O2IOpenCacheHashMap();
        INGREDIENT_CONVERTER = (ingredient, amount, map) -> {
            Object patt0$temp;
            StrictNBTIngredientAccessor nbtIngredient;
            CompoundTag nbt;
            if (ingredient instanceof StrictNBTIngredientAccessor && (nbt = (nbtIngredient = (StrictNBTIngredientAccessor)ingredient).getStack().m_41783_()) != null && nbtIngredient.getStack().m_41720_() == DIMENSION_DATA && (patt0$temp = nbt.f_128329_.get("dim")) instanceof StringTag) {
                StringTag stringTag = (StringTag)patt0$temp;
                map.add(NBTS.getInt((Object)stringTag.m_7916_()), amount);
                return;
            }
            MapIngredient.INGREDIENT_CONVERTER.convert(ingredient, amount, map);
        };
        ITEM_CONVERTER = (stack, amount, map) -> {
            Object patt0$temp;
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null && stack.m_41720_() == DIMENSION_DATA && (patt0$temp = nbt.f_128329_.get("dim")) instanceof StringTag) {
                StringTag stringTag = (StringTag)patt0$temp;
                map.add(NBTS.getInt((Object)stringTag.m_7916_()), amount);
                return;
            }
            MapIngredient.ITEM_CONVERTER.convert(stack, amount, map);
        };
    }
}

