/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.forge;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.GTToolItem;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.WorkableTieredMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.memoization.GTMemoizer;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.data.GTOCommands;
import com.gtocore.common.data.GTOEffects;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.forge.AnimalsRevengeEvent;
import com.gtocore.common.forge.ServerLangHook;
import com.gtocore.common.item.ItemMap;
import com.gtocore.common.machine.multiblock.electric.voidseries.VoidTransporterMachine;
import com.gtocore.common.saved.DysonSphereSavaedData;
import com.gtocore.common.saved.RecipeRunLimitSavaedData;
import com.gtocore.common.saved.WirelessSavedData;
import com.gtocore.config.GTOConfig;
import com.gtocore.integration.Mods;
import com.gtocore.integration.botania.IEntropinnyum;
import com.gtocore.integration.ftbquests.AdditionalTeamData;
import com.gtocore.utils.OrganUtilsKt;
import com.gtolib.GTOCore;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.data.Dimension;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.machine.feature.IVacuumMachine;
import com.gtolib.api.player.IEnhancedPlayer;
import com.gtolib.utils.RLUtils;
import com.gtolib.utils.RegistriesUtils;
import com.gtolib.utils.ServerUtils;
import com.gtolib.utils.explosion.SphereExplosion;
import com.gtolib.utils.register.BlockRegisterUtils;
import com.mojang.brigadier.CommandDispatcher;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.spawn.enchantment.CapturingEnchant;
import earth.terrarium.adastra.common.entities.mob.GlacianRam;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;

@DataGeneratorScanned
public final class ForgeCommonEvent {
    @RegisterLanguage(valuePrefix="gtocore.lang", en="Channel mode command banned in expert", cn="\u5728\u4e13\u5bb6\u6a21\u5f0f\u4e0b\uff0c\u9891\u9053\u6a21\u5f0f\u547d\u4ee4\u88ab\u7981\u6b62")
    private static final String CHANNEL_MODE_COMMAND_BANNED = "banned";
    private static final Supplier<Map<String, Item>> AvaritiaItems = GTMemoizer.memoize(() -> ImmutableMap.builder().put((Object)"neutron_ingot", (Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTOMaterials.Neutron)).put((Object)"crystal_matrix_ingot", (Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTOMaterials.CrystalMatrix)).put((Object)"infinity_ingot", (Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTOMaterials.Infinity)).put((Object)"neutron_nugget", (Object)ChemicalHelper.getItem((TagPrefix)TagPrefix.nugget, (Material)GTOMaterials.Neutron)).put((Object)"singularity", (Object)GTOItems.INFINITY_SINGULARITY.m_5456_()).put((Object)"eternal_singularity", (Object)GTOItems.COSMIC_SINGULARITY.m_5456_()).put((Object)"infinity_catalyst", (Object)GTOItems.INFINITY_CATALYST.m_5456_()).build());
    private static final Supplier<Map<String, Block>> AvaritiaBlocks = GTMemoizer.memoize(() -> ImmutableMap.builder().put((Object)"infinity", (Object)ChemicalHelper.getBlock((TagPrefix)TagPrefix.block, (Material)GTOMaterials.Infinity)).put((Object)"crystal_matrix", (Object)ChemicalHelper.getBlock((TagPrefix)TagPrefix.block, (Material)GTOMaterials.CrystalMatrix)).put((Object)"neutron", (Object)ChemicalHelper.getBlock((TagPrefix)TagPrefix.block, (Material)GTOMaterials.Neutron)).build());

    public static void init() {
        MinecraftForge.EVENT_BUS.register(ForgeCommonEvent.class);
        MinecraftForge.EVENT_BUS.register(AnimalsRevengeEvent.class);
    }

    @SubscribeEvent
    public static void onDropsEvent(LivingDropsEvent e) {
        ((CapturingEnchant)Apoth.Enchantments.CAPTURING.get()).handleCapturing(e);
    }

    @SubscribeEvent
    public static void onPortalSpawnEvent(BlockEvent.PortalSpawnEvent event) {
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlockEntity) {
            FallingBlockEntity fallingBlock = (FallingBlockEntity)entity;
            fallingBlock.m_146870_();
        }
        if ((entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (event.getDimension() == Dimension.OTHERSIDE.getResourceKey()) {
                boolean othersidePass;
                boolean bl = othersidePass = IEnhancedPlayer.of((Player)player).getPlayerData().wardenState || player.m_150110_().f_35937_;
                if (!othersidePass) {
                    event.setCanceled(true);
                    player.m_213846_((Component)Component.m_237115_((String)"gtocore.message.otherside_pass_required").m_130940_(ChatFormatting.DARK_GRAY));
                    player.m_213846_((Component)Component.m_237115_((String)"gtocore.message.otherside_pass_required.1").m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        GlacianRam glacianRam;
        net.minecraft.world.level.Level level;
        MinecraftServer server;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof GlacianRam && (server = (level = (glacianRam = (GlacianRam)livingEntity).m_9236_()).m_7654_()) != null && glacianRam.m_217043_().m_188503_(20) == 1) {
            level.m_7967_((Entity)new ItemEntity(level, glacianRam.m_20185_(), glacianRam.m_20186_(), glacianRam.m_20189_(), GTOItems.GLACIO_SPIRIT.asStack()));
        }
    }

    @SubscribeEvent
    public static void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (livingEntity = (player = (ServerPlayer)livingEntity).m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)livingEntity;
            OrganUtilsKt.ktFreshOrganState(IEnhancedPlayer.of((Player)player).getPlayerData());
            Optional.ofNullable(player.m_21124_((MobEffect)GTOEffects.MYSTERIOUS_BOOST.get())).ifPresent(effect -> {
                WorkableTieredMachine machine;
                MetaMachine patt0$temp = MetaMachine.getMachine((BlockGetter)serverLevel, (BlockPos)player.m_20097_());
                if (patt0$temp instanceof WorkableTieredMachine && (machine = (WorkableTieredMachine)patt0$temp).getRecipeLogic().isWorking()) {
                    RecipeLogic recipeLogic = machine.getRecipeLogic();
                    int currentProgress = recipeLogic.getProgress();
                    int maxProgress = recipeLogic.getMaxProgress();
                    Optional.ofNullable(recipeLogic.getLastRecipe()).ifPresent(recipe -> {
                        int recipeEUtTier = RecipeHelper.getRecipeEUtTier((GTRecipe)recipe);
                        if (effect.m_19564_() >= recipeEUtTier) {
                            int progress = Math.min(currentProgress + Math.min((int)(1.0 / (double)GTValues.RNG.m_216339_(6, 10) * (double)maxProgress), 600), maxProgress - 1);
                            effect.f_19503_ -= progress - currentProgress;
                            recipeLogic.setProgress(progress);
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123815_, (double)machine.getPos().m_123341_(), (double)(machine.getPos().m_123342_() + 6), (double)machine.getPos().m_123343_(), 3, 0.3, 0.2, 0.3, 0.02);
                        }
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        IVacuumMachine vacuumMachine;
        MetaMachine metaMachine;
        InteractionHand hand;
        net.minecraft.world.level.Level level = event.getLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        ItemStack itemStack = player.m_21120_(hand = event.getHand());
        Item item = itemStack.m_41720_();
        if (item == GTOItems.RAW_VACUUM_TUBE.get() && player.m_6144_() && (metaMachine = MetaMachine.getMachine((BlockGetter)level, (BlockPos)pos)) instanceof IVacuumMachine && (vacuumMachine = (IVacuumMachine)metaMachine).getVacuumTier() > 0) {
            player.m_21008_(hand, itemStack.m_255036_(itemStack.m_41613_() - 1));
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), GTItems.VACUUM_TUBE.asStack()));
            return;
        }
        if (!GTOConfig.INSTANCE.disableChargeBomb) {
            if (item == GTItems.QUANTUM_STAR.get() && level.m_8055_(pos).m_60734_() == GTOBlocks.NAQUADRIA_CHARGE.get() && !IEntropinnyum.absorbBomb(level, pos, 1000000)) {
                SphereExplosion.explosion((BlockPos)pos, (net.minecraft.world.level.Level)level, (int)200, (boolean)true, (boolean)true);
                return;
            }
            if (item == GTItems.GRAVI_STAR.get() && level.m_8055_(pos).m_60734_() == GTOBlocks.LEPTONIC_CHARGE.get() && !IEntropinnyum.absorbBomb(level, pos, 4000000)) {
                SphereExplosion.explosion((BlockPos)pos, (net.minecraft.world.level.Level)level, (int)800, (boolean)true, (boolean)true);
                return;
            }
            if (item == GTOItems.UNSTABLE_STAR.get() && level.m_8055_(pos).m_60734_() == GTOBlocks.QUANTUM_CHROMODYNAMIC_CHARGE.get() && !IEntropinnyum.absorbBomb(level, pos, 10000000)) {
                SphereExplosion.explosion((BlockPos)pos, (net.minecraft.world.level.Level)level, (int)2000, (boolean)true, (boolean)true);
                return;
            }
        }
        if (player.m_6144_() && item == GTOItems.COMMAND_WAND.get()) {
            block = level.m_8055_(pos).m_60734_();
            if (block == Blocks.f_50272_) {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), Blocks.f_50272_.m_5456_().m_7968_()));
                return;
            }
            if (block == Blocks.f_50448_) {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), Blocks.f_50448_.m_5456_().m_7968_()));
                return;
            }
            if (block == Blocks.f_50447_) {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), Blocks.f_50447_.m_5456_().m_7968_()));
                return;
            }
        }
        if (player.m_21205_().m_41619_() && player.m_21206_().m_41619_()) {
            block = level.m_8055_(pos).m_60734_();
            MinecraftServer server = level.m_7654_();
            if (server == null) {
                return;
            }
            String dim = level.m_46472_().m_135782_().toString();
            CompoundTag data = player.getPersistentData();
            if (block == Blocks.f_50723_) {
                if (!Objects.equals(dim, "gtocore:flat")) {
                    if (VoidTransporterMachine.checkTransporter(pos, level, 0)) {
                        return;
                    }
                    ServerLevel serverLevel = server.m_129880_(GTODimensions.getDimensionKey((ResourceLocation)GTODimensions.FLAT));
                    if (serverLevel != null) {
                        int value = Objects.equals(dim, "gtocore:void") ? 1 : 10;
                        data.m_128347_("y_f", player.m_20186_() + 1.0);
                        data.m_128359_("dim_f", dim);
                        BlockPos blockPos = new BlockPos(pos.m_123341_() * value, 64, pos.m_123343_() * value);
                        serverLevel.m_46597_(blockPos.m_7918_(0, -1, 0), Blocks.f_50723_.m_49966_());
                        ServerUtils.teleportToDimension((ServerLevel)serverLevel, (Entity)player, (Vec3)blockPos.m_252807_());
                    }
                } else {
                    String dima = data.m_128461_("dim_f");
                    int value = "gtocore:void".equals(dima) ? 1 : 10;
                    ServerUtils.teleportToDimension((ServerLevel)server.m_129880_(GTODimensions.getDimensionKey((ResourceLocation)RLUtils.parse((String)dima))), (Entity)player, (Vec3)new Vec3((double)pos.m_123341_() / (double)value, data.m_128459_("y_f"), (double)pos.m_123343_() / (double)value));
                }
                return;
            }
            if (block == Blocks.f_50080_) {
                if (!Objects.equals(dim, "gtocore:void")) {
                    if (VoidTransporterMachine.checkTransporter(pos, level, 0)) {
                        return;
                    }
                    ServerLevel serverLevel = server.m_129880_(GTODimensions.getDimensionKey((ResourceLocation)GTODimensions.VOID));
                    if (serverLevel != null) {
                        int value = Objects.equals(dim, "gtocore:flat") ? 1 : 10;
                        data.m_128347_("y_v", player.m_20186_() + 1.0);
                        data.m_128359_("dim_v", dim);
                        BlockPos blockPos = new BlockPos(pos.m_123341_() * value, 64, pos.m_123343_() * value);
                        serverLevel.m_46597_(blockPos.m_7918_(0, -1, 0), Blocks.f_50080_.m_49966_());
                        ServerUtils.teleportToDimension((ServerLevel)serverLevel, (Entity)player, (Vec3)blockPos.m_252807_());
                    }
                } else {
                    String dima = data.m_128461_("dim_v");
                    int value = "gtocore:flat".equals(dima) ? 1 : 10;
                    ServerUtils.teleportToDimension((ServerLevel)server.m_129880_(GTODimensions.getDimensionKey((ResourceLocation)RLUtils.parse((String)dima))), (Entity)player, (Vec3)new Vec3((double)pos.m_123341_() / (double)value, data.m_128459_("y_v"), (double)pos.m_123343_() / (double)value));
                }
                return;
            }
            if (block == BlockRegisterUtils.REACTOR_CORE.get() && ("gtocore:ancient_world".equals(dim) || "minecraft:the_nether".equals(dim))) {
                int dimdata = "gtocore:ancient_world".equals(dim) ? 1 : 2;
                ServerUtils.teleportToDimension((MinecraftServer)server, (Entity)player, (ResourceLocation)RLUtils.parse((String)data.m_128461_("dim_" + dimdata)), (Vec3)new Vec3(data.m_128459_("pos_x_" + dimdata), data.m_128459_("pos_y_" + dimdata), data.m_128459_("pos_z_" + dimdata)));
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        net.minecraft.world.level.Level level = event.getLevel();
        if (level == null) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.m_41720_();
        Player player = event.getEntity();
        if (item == GTOItems.SCRAP_BOX.m_5456_()) {
            int count = itemStack.m_41613_();
            if (player.m_6144_()) {
                for (int i = 0; i < count; ++i) {
                    level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), ItemMap.getScrapItem().m_7968_()));
                }
                player.m_21008_(event.getHand(), ItemStack.f_41583_);
            } else {
                level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), ItemMap.getScrapItem().m_7968_()));
                player.m_21008_(event.getHand(), itemStack.m_255036_(count - 1));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!GTCEu.isDev()) {
                player2.m_5661_((Component)Component.m_237110_((String)"gtocore.gtm", (Object[])new Object[]{Component.m_237113_((String)"GitHub").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/GregTech-Odyssey/GregTech-Odyssey/issues")))}), false);
                player2.m_5661_((Component)Component.m_237110_((String)"gtocore.dev", (Object[])new Object[]{Component.m_237113_((String)"GitHub").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/GregTech-Odyssey/GregTech-Odyssey/issues")))}), false);
                Configurator.setRootLevel((Level)Level.INFO);
            }
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            ServerLevel serverLevel = level.m_7654_().m_129880_(net.minecraft.world.level.Level.f_46428_);
            if (serverLevel == null) {
                return;
            }
            DysonSphereSavaedData.INSTANCE = (DysonSphereSavaedData)serverLevel.m_8895_().m_164861_(DysonSphereSavaedData::new, DysonSphereSavaedData::new, "dyson_sphere_data");
            RecipeRunLimitSavaedData.INSTANCE = (RecipeRunLimitSavaedData)serverLevel.m_8895_().m_164861_(RecipeRunLimitSavaedData::new, RecipeRunLimitSavaedData::new, "recipe_run_limit_data");
            WirelessSavedData.Companion.setINSTANCE((WirelessSavedData)serverLevel.m_8895_().m_164861_(WirelessSavedData::initialize, WirelessSavedData::new, "wireless_saved_data_" + GTOConfig.INSTANCE.aeGridKey));
            if (Mods.FTBQUESTS.isLoaded()) {
                AdditionalTeamData.instance = (AdditionalTeamData)serverLevel.m_8895_().m_164861_(AdditionalTeamData::new, AdditionalTeamData::new, "ftb_quests_additional_team_data");
            }
        }
    }

    @SubscribeEvent
    public static void onCommandExecution(CommandEvent event) {
        String command = event.getParseResults().getReader().getString();
        if (command.contains("ae2") && command.contains("channelmode") && GTOCore.isExpert()) {
            event.setCanceled(true);
            if (((CommandSourceStack)event.getParseResults().getContext().getSource()).m_230897_()) {
                ServerPlayer player = ((CommandSourceStack)event.getParseResults().getContext().getSource()).m_230896_();
                player.m_213846_((Component)Component.m_237115_((String)"gtocore.lang.banned"));
            }
        }
    }

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        GTOCommands.init((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onGTToolRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Item item = event.getEntity().m_21205_().m_41720_();
        if (item instanceof GTToolItem) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void serverStarting(ServerStartingEvent event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
            if (Objects.equals(GTOConfig.INSTANCE.serverLang, "en_us")) {
                return;
            }
            ServerLangHook.gto$loadLanguage(GTOConfig.INSTANCE.serverLang, event.getServer());
        });
    }

    @SubscribeEvent
    public static void remapIds(MissingMappingsEvent event) {
        event.getMappings(Registries.f_256747_, "gtocore").forEach(mapping -> {
            if (mapping.getKey().equals((Object)GTOCore.id((String)"abs_rad_casing"))) {
                mapping.remap((Object)((Block)GTOBlocks.ABS_RED_CASING.get()));
            } else if (mapping.getKey().equals((Object)GTOCore.id((String)"spacetimecontinuumripper"))) {
                mapping.remap((Object)((Block)GTOBlocks.SPACETIME_CONTINUUM_RIPPER.get()));
            } else if (mapping.getKey().equals((Object)GTOCore.id((String)"spacetimebendingcore"))) {
                mapping.remap((Object)((Block)GTOBlocks.SPACETIME_BENDING_CORE.get()));
            } else if (mapping.getKey().equals((Object)GTOCore.id((String)"titanium_alloy_internal_frame"))) {
                mapping.remap((Object)((Block)GTOBlocks.TITANIUM_ALLOY_INTERNAL_FRAME.get()));
            }
        });
        event.getMappings(Registries.f_256913_, "gtocore").forEach(mapping -> {
            if (mapping.getKey().equals((Object)GTOCore.id((String)"abs_rad_casing"))) {
                mapping.remap((Object)GTOBlocks.ABS_RED_CASING.m_5456_());
            } else if (mapping.getKey().equals((Object)GTOCore.id((String)"spacetimecontinuumripper"))) {
                mapping.remap((Object)GTOBlocks.SPACETIME_CONTINUUM_RIPPER.m_5456_());
            } else if (mapping.getKey().equals((Object)GTOCore.id((String)"spacetimebendingcore"))) {
                mapping.remap((Object)GTOBlocks.SPACETIME_BENDING_CORE.m_5456_());
            } else if (mapping.getKey().equals((Object)GTOCore.id((String)"titanium_alloy_internal_frame"))) {
                mapping.remap((Object)GTOBlocks.TITANIUM_ALLOY_INTERNAL_FRAME.m_5456_());
            }
        });
        event.getMappings(Registries.f_256747_, "avaritia").forEach(mapping -> {
            if (AvaritiaBlocks.get().containsKey(mapping.getKey().m_135815_())) {
                mapping.remap((Object)AvaritiaBlocks.get().get(mapping.getKey().m_135815_()));
            }
        });
        event.getMappings(Registries.f_256747_, "enderio").forEach(mapping -> {
            Block block;
            if (mapping.getKey().m_135827_().equals("enderio") && (block = RegistriesUtils.getBlock((String)GTOCore.id((String)mapping.getKey().m_135815_()).toString())) != null && block != Blocks.f_50016_) {
                mapping.remap((Object)block);
            }
        });
        event.getMappings(Registries.f_256913_, "avaritia").forEach(mapping -> {
            if (AvaritiaItems.get().containsKey(mapping.getKey().m_135815_())) {
                mapping.remap((Object)AvaritiaItems.get().get(mapping.getKey().m_135815_()));
            }
        });
        event.getMappings(Registries.f_256913_, "enderio").forEach(mapping -> {
            if (mapping.getKey().m_135827_().equals("enderio")) {
                Item item = RegistriesUtils.getItem((ResourceLocation)GTOCore.id((String)mapping.getKey().m_135815_()));
                if (mapping.getKey().m_135815_().startsWith("powdered_")) {
                    Material mat = GTCEuAPI.materialManager.getMaterial(mapping.getKey().m_135815_().replace("powdered_", ""));
                    if (mat == null) {
                        return;
                    }
                    item = ChemicalHelper.getItem((TagPrefix)TagPrefix.dust, (Material)mat);
                }
                if (item != Items.f_41852_ && item != Items.f_42127_) {
                    mapping.remap((Object)item);
                }
            }
        });
        event.getMappings(Registries.f_256808_, "enderio").forEach(mapping -> {
            if (mapping.getKey().m_135827_().equals("enderio")) {
                Fluid fluid = RegistriesUtils.getFluid((ResourceLocation)GTOCore.id((String)mapping.getKey().m_135815_()));
                if (fluid != null && fluid != Fluids.f_76191_) {
                    mapping.remap((Object)fluid);
                }
                if (mapping.getKey().equals((Object)ResourceLocation.parse((String)"enderio:rocket_fuel"))) {
                    mapping.remap((Object)GTMaterials.RocketFuel.getFluid());
                }
            }
        });
    }
}

