/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gtolib.api.capability.IWirelessChargerInteraction;
import com.gtolib.api.machine.impl.WirelessChargerMachine;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public final class WirelessChargerCover
extends CoverBehavior
implements IWirelessChargerInteraction {
    private WirelessChargerMachine wirelessChargerMachine;
    private MetaMachine machine;
    private TickableSubscription subscription;
    private IItemHandlerModifiable handlerModifiable;

    public WirelessChargerCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    public boolean canAttach() {
        if (super.canAttach()) {
            this.machine = MetaMachine.getMachine((BlockEntity)this.coverHolder.holder());
            if (this.machine != null) {
                for (Direction direction : Direction.values()) {
                    if (!(this.machine.getCoverContainer().getCoverAtSide(direction) instanceof WirelessChargerCover)) continue;
                    return false;
                }
                this.handlerModifiable = this.machine.getItemHandlerCap(this.attachedSide, false);
                return this.handlerModifiable != null;
            }
        }
        return false;
    }

    public void onLoad() {
        super.onLoad();
        if (this.coverHolder.getLevel() instanceof ServerLevel) {
            this.subscription = this.coverHolder.subscribeServerTick(this.subscription, this::update, 20);
        }
    }

    public void onRemoved() {
        super.onRemoved();
        this.unsubscribe();
    }

    private void unsubscribe() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }

    private void update() {
        if (this.handlerModifiable == null) {
            if (this.machine == null) {
                this.machine = MetaMachine.getMachine((BlockEntity)this.coverHolder.holder());
            }
            if (this.machine == null) {
                this.unsubscribe();
                return;
            }
            this.handlerModifiable = this.machine.getItemHandlerCap(this.attachedSide, false);
            if (this.handlerModifiable == null) {
                return;
            }
        }
        int slots = this.handlerModifiable.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = this.handlerModifiable.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            IWirelessChargerInteraction.charge((WirelessChargerMachine)((WirelessChargerMachine)this.getNetMachine()), (ItemStack)stack);
        }
    }

    public BlockPos getPos() {
        return this.coverHolder.getPos();
    }

    @Nullable
    public Level getLevel() {
        return this.coverHolder.getLevel();
    }

    public WirelessChargerMachine getNetMachineCache() {
        return this.wirelessChargerMachine;
    }

    public void setNetMachineCache(WirelessChargerMachine cache) {
        this.wirelessChargerMachine = cache;
    }

    @Nullable
    public UUID getUUID() {
        return this.machine == null ? null : this.machine.getOwnerUUID();
    }
}

