/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.SimpleGeneratorMachineRenderer;
import com.gtocore.client.renderer.TurbineModel;
import com.gtocore.common.machine.generator.WindMillTurbineMachine;
import com.gtolib.GTOCore;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class WindMillTurbineRenderer
extends SimpleGeneratorMachineRenderer {
    private static final TurbineModel MODEL = new TurbineModel();
    private static final List<ResourceLocation> TEXTURES = List.of(GTOCore.id((String)"textures/block/generators/wind_mill_turbine/wood_turbine.png"), GTOCore.id((String)"textures/block/generators/wind_mill_turbine/metal_turbine.png"), GTOCore.id((String)"textures/block/generators/wind_mill_turbine/carbon_turbine.png"));

    public WindMillTurbineRenderer(int tier) {
        super(tier, GTOCore.id((String)"block/generators/wind_mill_turbine"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        WindMillTurbineMachine windMillTurbineMachine;
        MetaMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof MetaMachineBlockEntity && (metaMachine = (machineBlockEntity = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof WindMillTurbineMachine && (windMillTurbineMachine = (WindMillTurbineMachine)metaMachine).isHasRotor()) {
            Level level = blockEntity.m_58904_();
            if (level == null) {
                return;
            }
            BlockPos pos = blockEntity.m_58899_();
            Direction facing = windMillTurbineMachine.getFrontFacing().m_122424_();
            int renderLight = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos.m_121955_(facing.m_122436_()));
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)TEXTURES.get(windMillTurbineMachine.getMaterial())));
            stack.m_85836_();
            stack.m_85837_(0.5, 0.0, 0.5);
            stack.m_252781_(Axis.f_252436_.m_252977_(-facing.m_122428_().m_122435_() + 90.0f));
            stack.m_85837_(0.0, -1.0, -0.56);
            float spin = windMillTurbineMachine.getBladeAngle() + partialTicks * windMillTurbineMachine.getSpinSpeed();
            MODEL.setSpin(spin);
            MODEL.m_7695_(stack, vertexConsumer, renderLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            stack.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getViewDistance() {
        return 32;
    }
}

