/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.GTRenderTypes;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.util.BloomUtils;
import com.gtocore.client.renderer.RenderHelper;
import com.gtocore.client.renderer.StructurePattern;
import com.gtocore.client.renderer.StructureVBO;
import com.gtocore.client.renderer.TextureUpdateRequester;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.machine.multiblock.noenergy.GodForgeMachine;
import com.gtolib.GTOCore;
import com.gtolib.utils.ClientUtil;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.shimmer.client.shader.RenderUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.math.Axis;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public final class GodforgeRenderer
extends WorkableCasingMachineRenderer {
    private static final ResourceLocation NEUTRON_STAR_MODEL = GTOCore.id((String)"obj/neutron_star");
    private static boolean initialized = false;
    private VertexBuffer ringOne;
    private VertexBuffer ringTwo;
    private VertexBuffer ringThree;
    private TextureUpdateRequester textureUpdateRequester;

    public GodforgeRenderer() {
        super(GTOCore.id((String)"block/transcendentally_amplified_magnetic_confinement_casing"), GTCEu.id((String)"block/multiblock/fusion_reactor"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        GodForgeMachine machine;
        MetaMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (!initialized) {
            this.initRings();
            initialized = true;
        }
        if (blockEntity instanceof MetaMachineBlockEntity && (metaMachine = (machineBlockEntity = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof GodForgeMachine && (machine = (GodForgeMachine)metaMachine).isFormed() && (machine.isActive() || blockEntity.m_58904_() instanceof TrackedDummyWorld)) {
            float tick = (float)machine.getOffsetTimer() + partialTicks;
            if (GTCEu.Mods.isShimmerLoaded() && !(blockEntity.m_58904_() instanceof TrackedDummyWorld)) {
                PoseStack finalStack = RenderUtils.copyPoseStack((PoseStack)poseStack);
                BloomUtils.entityBloom(source -> GodforgeRenderer.renderAll(machine, tick, finalStack, source));
            } else {
                GodforgeRenderer.renderAll(machine, tick, poseStack, buffer);
            }
        }
        if (blockEntity instanceof MetaMachineBlockEntity && (metaMachine = (machineBlockEntity = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof GodForgeMachine) {
            machine = (GodForgeMachine)metaMachine;
            if (machine.rotation > 0L && !(blockEntity.m_58904_() instanceof TrackedDummyWorld)) {
                if (machine.isActive() || (long)machine.timer > machine.rotation) {
                    this.RenderRing(machine, poseStack, partialTicks);
                } else {
                    this.RenderRing(machine, poseStack, -partialTicks);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initRings() {
        StructureVBO ringStructure = new StructureVBO().addMapping('B', (Block)GTOBlocks.SINGULARITY_REINFORCED_STELLAR_SHIELDING_CASING.get()).addMapping('C', (Block)GTOBlocks.CELESTIAL_MATTER_GUIDANCE_CASING.get()).addMapping('D', (Block)GTOBlocks.BOUNDLESS_GRAVITATIONALLY_SEVERED_STRUCTURE_CASING.get()).addMapping('E', (Block)GTOBlocks.TRANSCENDENTALLY_AMPLIFIED_MAGNETIC_CONFINEMENT_CASING.get()).addMapping('F', (Block)GTOBlocks.STELLAR_ENERGY_SIPHON_CASING.get()).addMapping('1', (Block)GTOBlocks.REMOTE_GRAVITON_FLOW_MODULATOR.get()).addMapping('2', (Block)GTOBlocks.MEDIAL_GRAVITON_FLOW_MODULATOR.get()).addMapping('3', (Block)GTOBlocks.CENTRAL_GRAVITON_FLOW_MODULATOR.get()).addMapping('H', (Block)GTOBlocks.SPATIALLY_TRANSCENDENT_GRAVITATIONAL_LENS_BLOCK.get());
        this.ringOne = ringStructure.assignStructure(StructurePattern.ringOne).build();
        this.ringTwo = ringStructure.assignStructure(StructurePattern.ringTwo).build();
        this.ringThree = ringStructure.assignStructure(StructurePattern.ringThree).build();
        this.textureUpdateRequester = ringStructure.getTextureUpdateRequestor();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void RenderRing(GodForgeMachine machine, PoseStack poseStack, float partialTicks) {
        VertexBuffer ring = this.ringOne;
        if (machine.tier == 2) {
            ring = this.ringTwo;
        } else if (machine.tier == 3) {
            ring = this.ringThree;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::m_172640_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        this.textureUpdateRequester.requestUpdate();
        poseStack.m_85836_();
        switch (machine.getFrontFacing()) {
            case NORTH: {
                poseStack.m_252880_(0.5f, 0.5f, 121.5f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case SOUTH: {
                poseStack.m_252880_(0.5f, 0.5f, -120.5f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case WEST: {
                poseStack.m_252880_(121.5f, 0.5f, 0.5f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                break;
            }
            case EAST: {
                poseStack.m_252880_(-120.5f, 0.5f, 0.5f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            }
        }
        poseStack.m_252781_(new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, ((float)machine.rotation + partialTicks) % 360.0f));
        ring.m_85921_();
        ring.m_253207_(poseStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        VertexBuffer.m_85931_();
        poseStack.m_85849_();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderAll(GodForgeMachine machine, float tick, PoseStack poseStack, MultiBufferSource buffer) {
        float color = machine.color;
        poseStack.m_85836_();
        switch (machine.getFrontFacing()) {
            case NORTH: {
                poseStack.m_85837_(0.5, 0.5, 61.5);
                poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
                GodforgeRenderer.renderCurvedCone(poseStack, buffer, color);
                GodforgeRenderer.renderStar(tick, poseStack, buffer);
                break;
            }
            case SOUTH: {
                poseStack.m_85837_(0.5, 0.5, -60.5);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                GodforgeRenderer.renderCurvedCone(poseStack, buffer, color);
                GodforgeRenderer.renderStar(tick, poseStack, buffer);
                break;
            }
            case WEST: {
                poseStack.m_85837_(61.5, 0.5, 0.5);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                GodforgeRenderer.renderCurvedCone(poseStack, buffer, color);
                GodforgeRenderer.renderStar(tick, poseStack, buffer);
                break;
            }
            case EAST: {
                poseStack.m_85837_(-60.5, 0.5, 0.5);
                poseStack.m_252781_(Axis.f_252393_.m_252977_(90.0f));
                GodforgeRenderer.renderCurvedCone(poseStack, buffer, color);
                GodforgeRenderer.renderStar(tick, poseStack, buffer);
            }
        }
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderCurvedCone(PoseStack poseStack, MultiBufferSource buffer, float color) {
        RenderHelper.renderCone(poseStack, buffer.m_6299_(GTRenderTypes.getLightRing()), 0.5f, 2.0f, 61.0f, 10.0f, 20, color, color, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderStar(float tick, PoseStack poseStack, MultiBufferSource buffer) {
        poseStack.m_252880_(0.0f, -61.0f, 0.0f);
        poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        poseStack.m_252781_(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 1.0f, tick % 360.0f));
        ClientUtil.modelRenderer().renderModel(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_110466_()), null, ClientUtil.getBakedModel((ResourceLocation)NEUTRON_STAR_MODEL), 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110451_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onAdditionalModel(Consumer<ResourceLocation> registry) {
        super.onAdditionalModel(registry);
        registry.accept(NEUTRON_STAR_MODEL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getViewDistance() {
        return 256;
    }
}

