/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gtocore.client.renderer.StructurePattern;
import com.gtocore.client.renderer.StructureVBO;
import com.gtocore.client.renderer.TextureUpdateRequester;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.machine.mana.multiblock.CosmicCelestialSpireOfConvergence;
import com.gtolib.GTOCore;
import com.gtolib.utils.RegistriesUtils;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

public class CosmicCelestialSpireOfConvergenceRenderer
extends WorkableCasingMachineRenderer {
    private VertexBuffer vbo;
    private static boolean initialized = false;
    private TextureUpdateRequester textureUpdateRequester;

    public CosmicCelestialSpireOfConvergenceRenderer() {
        super(GTOCore.id((String)"block/casings/spell_prism_casing"), GTCEu.id((String)"block/multiblock/gcym/large_centrifuge"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        MetaMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (!initialized) {
            this.initVBO();
            initialized = true;
        }
        if (blockEntity instanceof MetaMachineBlockEntity && (metaMachine = (machineBlockEntity = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof CosmicCelestialSpireOfConvergence) {
            CosmicCelestialSpireOfConvergence machine = (CosmicCelestialSpireOfConvergence)metaMachine;
            if (!(blockEntity.m_58904_() instanceof TrackedDummyWorld) && machine.isFormed()) {
                if (machine.isActive()) {
                    this.renderVBO(machine, poseStack, 0.1f, partialTicks);
                } else {
                    this.renderVBO(machine, poseStack, -0.04f, -partialTicks);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initVBO() {
        StructureVBO ringStructure = new StructureVBO().addMapping('X', (Block)GTOBlocks.THE_SOLARIS_LENS.get()).addMapping('[', RegistriesUtils.getBlock((String)"botania:bifrost_perm"));
        this.vbo = ringStructure.assignStructure(StructurePattern.tinyLight).offset(-1.0f, 0.0f, 0.0f).build();
        this.textureUpdateRequester = ringStructure.getTextureUpdateRequestor();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderVBO(CosmicCelestialSpireOfConvergence machine, PoseStack poseStack, float rotSpeed, float partialTicks) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::m_172640_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        this.textureUpdateRequester.requestUpdate();
        poseStack.m_85836_();
        switch (machine.getFrontFacing()) {
            case NORTH: {
                poseStack.m_252880_(0.5f, 8.5f, 5.5f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case SOUTH: {
                poseStack.m_252880_(0.5f, 8.5f, -4.5f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case WEST: {
                poseStack.m_252880_(5.5f, 8.5f, 0.5f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                break;
            }
            case EAST: {
                poseStack.m_252880_(-4.5f, 8.5f, 0.5f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            }
        }
        float ticks = ((float)machine.getOffsetTimer() + partialTicks) * rotSpeed;
        poseStack.m_252781_(new Quaternionf().fromAxisAngleDeg(1.0f, 1.0f, 1.0f, ticks % 360.0f));
        poseStack.m_252781_(new Quaternionf().fromAxisAngleDeg(-1.0f, 2.0f, 0.0f, ticks * ticks / 16.0f % 360.0f));
        poseStack.m_252781_(new Quaternionf().fromAxisAngleDeg(-2.0f, -1.0f, 3.0f, ticks / 2.0f % 360.0f));
        this.vbo.m_85921_();
        this.vbo.m_253207_(poseStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        VertexBuffer.m_85931_();
        poseStack.m_85849_();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }
}

