/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer;

import com.gtocore.client.renderer.FaceCulledRenderBlocks;
import com.gtocore.client.renderer.TextureUpdateRequester;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class StructureVBO {
    private String[][] structure;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float offsetZ = 0.0f;
    public final Char2ObjectOpenHashMap<Block> mapper = new Char2ObjectOpenHashMap();

    public StructureVBO assignStructure(String[][] structure) {
        this.structure = structure;
        return this;
    }

    public StructureVBO addMapping(char letter, Block block) {
        this.mapper.put(letter, (Object)block);
        return this;
    }

    public StructureVBO offset(float x, float y, float z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    public TextureUpdateRequester getTextureUpdateRequestor() {
        TextureUpdateRequester textureUpdateRequester = new TextureUpdateRequester();
        for (Block block : this.mapper.values()) {
            textureUpdateRequester.add(block);
        }
        return textureUpdateRequester;
    }

    private boolean isOpaqueAt(int x, int y, int z) {
        char letter = this.structure[x][y].charAt(z);
        if (letter == ' ') {
            return false;
        }
        Block block = (Block)this.mapper.get(letter);
        if (block == null) {
            return false;
        }
        if (block == Blocks.f_50016_) {
            return false;
        }
        return block.m_49966_().m_60804_((BlockGetter)Minecraft.m_91087_().f_91073_, BlockPos.f_121853_);
    }

    private List<Direction> getVisibleFaces(int x, int y, int z) {
        ArrayList<Direction> visibility = new ArrayList<Direction>();
        int maxX = this.structure.length - 1;
        int maxY = this.structure[0].length - 1;
        int maxZ = this.structure[0][0].length() - 1;
        if (x <= 0 || !this.isOpaqueAt(x - 1, y, z) && this.structure[x][y].charAt(z) != this.structure[x - 1][y].charAt(z)) {
            visibility.add(Direction.EAST);
        }
        if (x >= maxX || !this.isOpaqueAt(x + 1, y, z) && this.structure[x][y].charAt(z) != this.structure[x + 1][y].charAt(z)) {
            visibility.add(Direction.WEST);
        }
        if (y <= 0 || !this.isOpaqueAt(x, y - 1, z) && this.structure[x][y].charAt(z) != this.structure[x][y - 1].charAt(z)) {
            visibility.add(Direction.DOWN);
        }
        if (y >= maxY || !this.isOpaqueAt(x, y + 1, z) && this.structure[x][y].charAt(z) != this.structure[x][y + 1].charAt(z)) {
            visibility.add(Direction.UP);
        }
        if (z <= 0 || !this.isOpaqueAt(x, y, z - 1) && this.structure[x][y].charAt(z) != this.structure[x][y].charAt(z - 1)) {
            visibility.add(Direction.NORTH);
        }
        if (z >= maxZ || !this.isOpaqueAt(x, y, z + 1) && this.structure[x][y].charAt(z) != this.structure[x][y].charAt(z + 1)) {
            visibility.add(Direction.SOUTH);
        }
        return visibility;
    }

    public VertexBuffer build() {
        VertexBuffer buffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        Minecraft mc = Minecraft.m_91087_();
        FaceCulledRenderBlocks renderer = new FaceCulledRenderBlocks(mc, mc.m_91097_(), mc.m_91304_(), mc.getItemColors(), mc.m_91291_().getBlockEntityRenderer());
        PoseStack poseStack = new PoseStack();
        for (int x = 0; x < this.structure.length; ++x) {
            String[] plane = this.structure[x];
            for (int y = 0; y < plane.length; ++y) {
                String row = plane[y];
                for (int z = 0; z < row.length(); ++z) {
                    List<Direction> faceInfo;
                    Block block;
                    char letter = row.charAt(z);
                    if (letter == ' ' || (block = (Block)this.mapper.get(letter)) == null || block == Blocks.f_50016_ || (faceInfo = this.getVisibleFaces(x, y, z)).isEmpty()) continue;
                    BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(block.m_49966_());
                    renderer.setDirections(faceInfo);
                    poseStack.m_85836_();
                    poseStack.m_252880_((float)this.structure.length / 2.0f - (float)x, (float)(-plane.length) / 2.0f + (float)y, (float)(-row.length()) / 2.0f + (float)z);
                    poseStack.m_252880_(this.offsetX, this.offsetY, this.offsetZ);
                    int light = block.getLightEmission(block.m_49966_(), (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_);
                    renderer.m_115189_(model, block.m_5456_().m_7968_(), LightTexture.m_109885_((int)light, (int)13), OverlayTexture.f_118083_, poseStack, (VertexConsumer)bufferBuilder);
                    poseStack.m_85849_();
                }
            }
        }
        buffer.m_85921_();
        buffer.m_231221_(bufferBuilder.m_231175_());
        VertexBuffer.m_85931_();
        return buffer;
    }
}

