/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J8\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/gtocore/client/renderer/RenderUtil;", "", "<init>", "()V", "drawRainbowBorder", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "x", "", "y", "width", "height", "z", "borderWidth", "", "addVertex", "buffer", "Lcom/mojang/blaze3d/vertex/BufferBuilder;", "matrix", "Lorg/joml/Matrix4f;", "color", "getRainbowColor", "hue", "getDynamicRainbowColor", "offset", "gtocore"})
public final class RenderUtil {
    @NotNull
    public static final RenderUtil INSTANCE = new RenderUtil();

    private RenderUtil() {
    }

    @JvmStatic
    public static final void drawRainbowBorder(@NotNull GuiGraphics guiGraphics, int x, int y, int width, int height, int z, float borderWidth) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        int c1 = INSTANCE.getDynamicRainbowColor(0.0f);
        int c2 = INSTANCE.getDynamicRainbowColor(0.25f);
        int c3 = INSTANCE.getDynamicRainbowColor(0.5f);
        int c4 = INSTANCE.getDynamicRainbowColor(0.75f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Intrinsics.checkNotNull((Object)bufferBuilder);
        Intrinsics.checkNotNull((Object)matrix);
        INSTANCE.addVertex(bufferBuilder, matrix, x, (float)y + borderWidth, z, c1);
        INSTANCE.addVertex(bufferBuilder, matrix, x + width, (float)y + borderWidth, z, c2);
        INSTANCE.addVertex(bufferBuilder, matrix, x + width, y, z, c2);
        INSTANCE.addVertex(bufferBuilder, matrix, x, y, z, c1);
        INSTANCE.addVertex(bufferBuilder, matrix, (float)(x + width) - borderWidth, y + height, z, c3);
        INSTANCE.addVertex(bufferBuilder, matrix, x + width, y + height, z, c3);
        INSTANCE.addVertex(bufferBuilder, matrix, x + width, y, z, c2);
        INSTANCE.addVertex(bufferBuilder, matrix, (float)(x + width) - borderWidth, y, z, c2);
        INSTANCE.addVertex(bufferBuilder, matrix, x, y + height, z, c4);
        INSTANCE.addVertex(bufferBuilder, matrix, x + width, y + height, z, c3);
        INSTANCE.addVertex(bufferBuilder, matrix, x + width, (float)(y + height) - borderWidth, z, c3);
        INSTANCE.addVertex(bufferBuilder, matrix, x, (float)(y + height) - borderWidth, z, c4);
        INSTANCE.addVertex(bufferBuilder, matrix, x, y + height, z, c4);
        INSTANCE.addVertex(bufferBuilder, matrix, (float)x + borderWidth, y + height, z, c4);
        INSTANCE.addVertex(bufferBuilder, matrix, (float)x + borderWidth, y, z, c1);
        INSTANCE.addVertex(bufferBuilder, matrix, x, y, z, c1);
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    private final void addVertex(BufferBuilder buffer, Matrix4f matrix, float x, float y, float z, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color & 0xFF) / 255.0f;
        float a2 = (float)(color >> 24 & 0xFF) / 255.0f;
        buffer.m_252986_(matrix, x, y, z).m_85950_(r, g, b2, a2).m_5752_();
    }

    private final int getRainbowColor(float hue) {
        return Color.HSBtoRGB(hue, 0.8f, 1.0f);
    }

    private final int getDynamicRainbowColor(float offset) {
        long cycleMillis = 4000L;
        float hue = (float)(System.currentTimeMillis() % cycleMillis) / (float)cycleMillis;
        return this.getRainbowColor((hue + offset) % 1.0f);
    }
}

