/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.hud;

import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import dev.emi.emi.config.EmiConfig;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@DataGeneratorScanned
public interface IMoveableHUD
extends IGuiOverlay,
GuiEventListener,
Renderable {
    public static final Map<String, IMoveableHUD> REGISTERED_HUDS = new HashMap<String, IMoveableHUD>();
    @RegisterLanguage(cn="\u5de6\u952e\u5f00\u5173HUD\u663e\u793a\uff08\u5df2\u542f\u7528\uff09", en="Left click to toggle HUD display (Enabled)")
    public static final String HUD_TOGGLE_ON = "gtocore.hud.toggle.on";
    @RegisterLanguage(cn="\u5de6\u952e\u5f00\u5173HUD\u663e\u793a\uff08\u5df2\u7981\u7528\uff09", en="Left click to toggle HUD display (Disabled)")
    public static final String HUD_TOGGLE_OFF = "gtocore.hud.toggle.off";
    @RegisterLanguage(cn="\u53f3\u952e\u53ef\u5f00\u542fHUD\u62d6\u62fd\u6a21\u5f0f", en="Right click to enable HUD drag mode")
    public static final String HUD_DRAG = "gtocore.hud.drag";
    public static final Set<IMoveableHUD> activeHuds = new ReferenceOpenHashSet();

    public static void registerHUD(RegisterGuiOverlaysEvent event, String id, IMoveableHUD hud) {
        REGISTERED_HUDS.put(id, hud);
        event.registerAboveAll(id, (IGuiOverlay)hud);
    }

    default public void render(ForgeGui forgeGui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        if (!this.isEnabled() || mc.f_91073_ == null || mc.f_91066_.f_92063_ || mc.f_91066_.f_92062_) {
            return;
        }
        this.renderGeneral(guiGraphics, partialTick, screenWidth, screenHeight);
    }

    default public void m_88315_(@NotNull GuiGraphics guiGraphics, int i, int i1, float v) {
        this.renderGeneral(guiGraphics, v, Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
    }

    default public void renderGeneral(GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
    }

    public Rect2i getBounds(int var1, int var2);

    default public boolean m_5953_(double mouseX, double mouseY) {
        return this.getBounds(Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_()).m_110087_((int)mouseX, (int)mouseY);
    }

    default public void m_93692_(boolean b2) {
    }

    default public boolean m_93696_() {
        return false;
    }

    default public void toggleEnabled() {
    }

    default public boolean isEnabled() {
        return false;
    }

    public static boolean addActiveHud(IMoveableHUD hud) {
        if (EmiConfig.enabled) {
            EmiConfig.enabled = false;
        }
        return activeHuds.add(hud);
    }

    public static boolean removeActiveHud(IMoveableHUD hud) {
        boolean b2 = activeHuds.remove(hud);
        if (!EmiConfig.enabled && activeHuds.isEmpty()) {
            EmiConfig.enabled = true;
        }
        return b2;
    }

    @Mod.EventBusSubscriber(modid="gtocore", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class EventHandler {
        @SubscribeEvent
        public static void onGuiRender(ScreenEvent.Render.Post event) {
            for (IMoveableHUD hud : activeHuds) {
                if (!hud.isEnabled()) continue;
                hud.m_88315_(event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick());
            }
        }

        @SubscribeEvent
        public static void onMouseClicked(ScreenEvent.MouseButtonPressed.Pre event) {
            boolean handled = false;
            for (IMoveableHUD hud : activeHuds) {
                if (!hud.isEnabled() || handled) continue;
                handled = hud.m_6375_(event.getMouseX(), event.getMouseY(), event.getButton());
            }
            event.setCanceled(handled);
        }

        @SubscribeEvent
        public static void onMouseDragged(ScreenEvent.MouseDragged.Pre event) {
            boolean handled = false;
            for (IMoveableHUD hud : activeHuds) {
                if (!hud.isEnabled() || handled) continue;
                handled = hud.m_7979_(event.getMouseX(), event.getMouseY(), event.getMouseButton(), event.getDragX(), event.getDragY());
            }
            event.setCanceled(handled);
        }

        @SubscribeEvent
        public static void onMouseReleased(ScreenEvent.MouseButtonReleased.Pre event) {
            boolean handled = false;
            for (IMoveableHUD hud : activeHuds) {
                if (!hud.isEnabled() || handled) continue;
                handled = hud.m_6348_(event.getMouseX(), event.getMouseY(), event.getButton());
            }
            event.setCanceled(handled);
        }

        @SubscribeEvent
        public static void onClosing(ScreenEvent.Closing event) {
            activeHuds.clear();
            EmiConfig.enabled = true;
        }
    }
}

