/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.forge;

import com.fast.fastcollection.O2IOpenCacheHashMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.core.ILevel;
import com.gtocore.client.ClientCache;
import com.gtocore.client.GTOClientCommands;
import com.gtocore.client.Tooltips;
import com.gtocore.client.renderer.RenderHelper;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.item.StructureDetectBehavior;
import com.gtocore.common.item.StructureWriteBehavior;
import com.gtocore.common.machine.multiblock.part.ae.widget.slot.AEPatternViewSlotWidgetKt;
import com.gtolib.IItem;
import com.gtolib.api.lang.CNENS;
import com.gtolib.api.player.IEnhancedPlayer;
import com.gtolib.api.player.PlayerData;
import com.gtolib.utils.ItemUtils;
import com.hepdd.gtmthings.common.block.machine.electric.WirelessEnergyMonitor;
import com.hepdd.gtmthings.data.CustomItems;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.CommandDispatcher;
import dev.emi.emi.screen.RecipeScreen;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import snownee.jade.util.Color;

@OnlyIn(value=Dist.CLIENT)
public final class ForgeClientEvent {
    public static int highlightingTime = 0;
    public static int highlightingRadius;
    public static BlockPos highlightingPos;
    private static boolean lastShiftState;
    public static final O2IOpenCacheHashMap<HighlightNeed> CUstomHighlightNeeds;
    private static final String ITEM_PREFIX = "item.gtocore";
    private static final String BLOCK_PREFIX = "block.gtocore";

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (highlightingTime > 0) {
                --highlightingTime;
            }
            if (ClientCache.highlightTime > 0) {
                --ClientCache.highlightTime;
            }
            CUstomHighlightNeeds.clone().object2IntEntrySet().fastForEach(entry -> {
                int time = entry.getIntValue();
                if (time > 0) {
                    CUstomHighlightNeeds.put((Object)((HighlightNeed)entry.getKey()), --time);
                } else {
                    CUstomHighlightNeeds.removeInt(entry.getKey());
                }
            });
        }
    }

    @SubscribeEvent
    public static void onTooltipEvent(ItemTooltipEvent event) {
        CNENS lang;
        Item item;
        Supplier[] arr;
        String tooltipKey;
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        String translationKey = stack.m_41778_();
        if ((translationKey.startsWith(ITEM_PREFIX) || translationKey.startsWith(BLOCK_PREFIX)) && I18n.m_118936_((String)(tooltipKey = translationKey + ".tooltip"))) {
            event.getToolTip().add(1, Component.m_237115_((String)tooltipKey));
        }
        if ((arr = ((IItem)(item = stack.m_41720_())).gtolib$getToolTips()) != null) {
            for (int i = arr.length - 1; i >= 0; --i) {
                event.getToolTip().add(1, (Component)arr[i].get());
            }
        }
        if ((lang = (CNENS)Tooltips.TOOL_TIPS_MAP.get((Object)item)) != null) {
            for (int i = 0; i < lang.length(); ++i) {
                event.getToolTip().add(Component.m_237115_((String)("gtocore.tooltip.item." + ItemUtils.getIdLocation((Item)item).m_135815_() + "." + i)));
            }
        } else {
            List tooltips = (List)Tooltips.TOOL_TIPS_KEY_MAP.get((Object)item);
            if (tooltips != null) {
                event.getToolTip().addAll(tooltips);
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        boolean isShiftDown;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ instanceof IEnhancedPlayer && (isShiftDown = Screen.m_96638_()) != lastShiftState) {
            PlayerData.SHIFT_KEY.send(buf -> buf.writeBoolean(isShiftDown), new Object[0]);
            lastShiftState = isShiftDown;
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent event) {
        RenderLevelStageEvent.Stage stage = event.getStage();
        if (stage == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            ItemStack itemStack;
            Item item;
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            LocalPlayer player = mc.f_91074_;
            if (level == null || player == null) {
                return;
            }
            PoseStack poseStack = event.getPoseStack();
            Camera camera = event.getCamera();
            if (highlightingTime > 0) {
                RenderHelper.highlightSphere(camera, poseStack, highlightingPos, highlightingRadius);
            }
            if (WirelessEnergyMonitor.p > 0) {
                BlockPos pose;
                if ((long)GTValues.CLIENT_TIME % 20L == 0L) {
                    --WirelessEnergyMonitor.p;
                }
                if ((pose = WirelessEnergyMonitor.pPos) == null) {
                    return;
                }
                RenderHelper.highlightBlock(camera, poseStack, 0.0f, 0.0f, 1.0f, pose, pose);
            }
            if ((item = (itemStack = player.m_21205_()).m_41720_()) != Items.f_41852_ && itemStack.m_41782_()) {
                if (GTCEu.isDev() && StructureWriteBehavior.isItem(itemStack)) {
                    BlockPos[] poses = StructureWriteBehavior.getPos(itemStack);
                    if (poses != null) {
                        RenderHelper.highlightBlock(camera, poseStack, 0.0f, 0.0f, 1.0f, poses);
                    }
                } else if (StructureDetectBehavior.isItem(itemStack)) {
                    BlockPos[] poses = StructureDetectBehavior.getPos(itemStack);
                    if (poses != null && poses.length >= 1) {
                        for (BlockPos pos : poses) {
                            if (pos == null) continue;
                            RenderHelper.highlightBlock(camera, poseStack, 0.0f, 0.0f, 1.0f, pos, pos);
                        }
                    }
                } else if (Highlighting.HIGHLIGHTING_ITEM.contains(item)) {
                    CompoundTag tag = itemStack.m_41783_();
                    BlockPos blockPos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
                    RenderHelper.highlightBlock(camera, poseStack, 0.0f, 0.0f, 1.0f, blockPos, blockPos);
                }
            }
            CUstomHighlightNeeds.object2IntEntrySet().fastForEach(entry -> {
                Color color = Color.rgb((int)((HighlightNeed)entry.getKey()).color);
                RenderHelper.highlightBlock(camera, poseStack, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, ((HighlightNeed)entry.getKey()).start, ((HighlightNeed)entry.getKey()).end);
            });
            if (ClientCache.machineNotFormedHighlight) {
                ((ILevel)level).gtceu$getHighlightCache().forEach(p -> {
                    BlockPos pos = BlockPos.m_122022_((long)p);
                    RenderHelper.highlightBlock(camera, poseStack, 1.0f, 0.1f, 0.1f, pos, pos);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onScreenClosing(ScreenEvent.Closing event) {
        Screen screen = event.getScreen();
        if (screen instanceof ModularUIGuiContainer) {
            ModularUIGuiContainer gui = (ModularUIGuiContainer)screen;
            Optional<AEPatternViewSlotWidgetKt> p = ((ModularUIContainer)gui.m_6262_()).getModularUI().getFlatWidgetCollection().stream().filter(AEPatternViewSlotWidgetKt.class::isInstance).map(AEPatternViewSlotWidgetKt.class::cast).filter(AEPatternViewSlotWidgetKt::emiFlagFilter).findFirst();
            p.ifPresent(AEPatternViewSlotWidgetKt::onDestroy);
        }
    }

    @SubscribeEvent
    public static void onScreenOpening(ScreenEvent.Opening event) {
        Screen screen = event.getCurrentScreen();
        if (screen instanceof ModularUIGuiContainer) {
            ModularUIGuiContainer gui = (ModularUIGuiContainer)screen;
            if (event.getNewScreen() instanceof RecipeScreen) {
                ((ModularUIContainer)gui.m_6262_()).getModularUI().getFlatWidgetCollection().stream().filter(AEPatternViewSlotWidgetKt.class::isInstance).map(AEPatternViewSlotWidgetKt.class::cast).forEach(a2 -> a2.setEmiFlag(true));
            }
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterClientCommandsEvent evt) {
        GTOClientCommands.init((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }

    public static void highlightRegion(ResourceKey<Level> dimension, BlockPos start, BlockPos end, int color, int durationTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        if (mc.f_91073_.m_46472_() != dimension) {
            return;
        }
        HighlightNeed need = new HighlightNeed(start, end, color);
        CUstomHighlightNeeds.put((Object)need, durationTicks);
    }

    public static void stopHighlight(BlockPos start, BlockPos end) {
        CUstomHighlightNeeds.object2IntEntrySet().removeIf(entry -> ((HighlightNeed)entry.getKey()).start.equals((Object)start) && ((HighlightNeed)entry.getKey()).end.equals((Object)end));
    }

    static {
        lastShiftState = false;
        CUstomHighlightNeeds = new O2IOpenCacheHashMap();
    }

    private static class Highlighting {
        private static final Set<Item> HIGHLIGHTING_ITEM = Set.of(CustomItems.WIRELESS_ITEM_TRANSFER_COVER.m_5456_(), CustomItems.WIRELESS_FLUID_TRANSFER_COVER.m_5456_(), CustomItems.ADVANCED_WIRELESS_ITEM_TRANSFER_COVER.m_5456_(), CustomItems.ADVANCED_WIRELESS_FLUID_TRANSFER_COVER.m_5456_(), GTOItems.COORDINATE_CARD.m_5456_());

        private Highlighting() {
        }
    }

    public record HighlightNeed(BlockPos start, BlockPos end, int color) {
    }
}

