/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.AlloyBlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.RotorProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gtocore.api.data.material.GTOMaterialFlags;
import com.gtocore.client.forge.GTOComponentHandler;
import com.gtolib.GTOCore;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterEnumLang;
import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@DataGeneratorScanned
public class MaterialReport {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void generateReport() {
        StringBuilder report = new StringBuilder();
        StringBuilder report_json = new StringBuilder();
        StringBuilder report_table = new StringBuilder();
        report_table.append("\u4e2d\u6587\u540d,\u82f1\u6587\u540d,\u7b26\u53f7,\u4e3b\u989c\u8272,\u6b21\u989c\u8272,\u56fe\u6807\u96c6,\u57fa\u7840\u7c7b\u578b,\u8d28\u91cf,\u6d41\u4f53\u7ba1\u9053\u541e\u5410\u91cf,\u7269\u54c1\u7ba1\u9053\u4f18\u5148\u7ea7,\u7269\u54c1\u7ba1\u9053\u4f20\u8f93\u901f\u7387,\u662f\u5426\u4e3a\u5bfc\u7ebf\u6750\u6599,\u5bfc\u7ebf\u6700\u5927\u5b89\u57f9\u6570,\u5bfc\u7ebf\u7535\u538b,\u5bfc\u7ebf\u6bcf\u7c73\u635f\u8017,\u662f\u5426\u4e3a\u5de5\u5177\u6750\u6599,\u5de5\u5177\u6316\u6398\u901f\u5ea6,\u5de5\u5177\u8010\u4e45\u5ea6,\u5de5\u5177\u6316\u6398\u7b49\u7ea7,\u5de5\u5177\u9644\u9b54\u6027,\u662f\u5426\u4e3a\u65e0\u5c3d\u8010\u4e45\u5de5\u5177,\u5de5\u5177\u8010\u4e45\u5ea6\u500d\u7387,\u662f\u5426\u4e3a\u8f6c\u5b50\u6750\u6599,\u8f6c\u5b50\u8010\u4e45\u5ea6,\u8f6c\u5b50\u529f\u7387,\u8f6c\u5b50\u6548\u7387,\u7206\u70b8\u6e29\u5ea6,\u662f\u5426\u6709\u5bb3\u7269\u8d28\n");
        for (Material material : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            Entry entry = Entry.fromMaterial(material);
            report.append("## ").append(entry.cnName).append(" (").append(entry.enName).append(")\n");
            report.append("- \u7b26\u53f7: ").append(entry.symbol).append("\n");
            report.append("- \u4e3b\u989c\u8272: ").append(entry.hexColor1).append("\n");
            report.append("- \u6b21\u989c\u8272: ").append(entry.hexColor2).append("\n");
            report.append("- \u56fe\u6807\u96c6: ").append(entry.iconSetName).append("\n");
            report.append("- \u57fa\u7840\u7c7b\u578b: ").append(entry.baseType.cn).append(" / ").append(entry.baseType.en).append("\n");
            report.append("- \u8d28\u91cf: ").append(entry.mass).append("\n");
            report.append("\n");
            report_json.append(GSON.toJson((Object)entry)).append("\n");
            Object cnNameInCsv = entry.cnName.contains(",") ? "\"" + entry.cnName + "\"" : entry.cnName;
            Object enNameInCsv = entry.enName.contains(",") ? "\"" + entry.enName + "\"" : entry.enName;
            report_table.append(String.format("%s,%s,%s,%s,%s,%s,%s,%d,", cnNameInCsv, enNameInCsv, entry.symbol, entry.hexColor1, entry.hexColor2, entry.iconSetName, entry.baseType.en, entry.mass));
            report_table.append(entry.hasFluidPipe ? Integer.valueOf(entry.fluidPipeThroughput) : "").append(",");
            report_table.append(entry.hasItemPipe ? Integer.valueOf(entry.itemPipePriority) : "").append(",");
            report_table.append(entry.hasItemPipe ? Float.valueOf(entry.itemPipeTransferRate) : "").append(",");
            report_table.append(entry.isWireMaterial ? "\u662f" : "\u5426").append(",");
            report_table.append(entry.isWireMaterial ? Integer.valueOf(entry.wireMaxAmperes) : "").append(",");
            report_table.append(entry.isWireMaterial ? Long.valueOf(entry.wireVoltage) : "").append(",");
            report_table.append(entry.isWireMaterial ? Integer.valueOf(entry.wireLossPerMeter) : "").append(",");
            report_table.append(entry.isToolMaterial ? "\u662f" : "\u5426").append(",");
            report_table.append(entry.isToolMaterial ? Float.valueOf(entry.harvestSpeedTool) : "").append(",");
            report_table.append(entry.isToolMaterial ? Integer.valueOf(entry.durabilityTool) : "").append(",");
            report_table.append(entry.isToolMaterial ? Integer.valueOf(entry.harvestLevelTool) : "").append(",");
            report_table.append(entry.isToolMaterial ? Integer.valueOf(entry.enchantabilityTool) : "").append(",");
            report_table.append(entry.isToolMaterial ? (entry.isUnbreakableTool ? "\u662f" : "\u5426") : "").append(",");
            report_table.append(entry.isToolMaterial ? Integer.valueOf(entry.durabilityMultiplierTool) : "").append(",");
            report_table.append(entry.isRotorMaterial ? "\u662f" : "\u5426").append(",");
            report_table.append(entry.isRotorMaterial ? Integer.valueOf(entry.durabilityRotor) : "").append(",");
            report_table.append(entry.isRotorMaterial ? Integer.valueOf(entry.powerRotor) : "").append(",");
            report_table.append(entry.isRotorMaterial ? Integer.valueOf(entry.efficiencyRotor) : "").append(",");
            report_table.append(entry.blastTemperature > 0 ? Integer.valueOf(entry.blastTemperature) : "").append(",");
            report_table.append(entry.isHazard ? "\u662f" : "\u5426").append("\n");
        }
        MaterialReport.writeReportsToFiles(report, report_json, report_table);
    }

    private static void writeReportsToFiles(StringBuilder report, StringBuilder json, StringBuilder report_table) {
        try {
            Path logDir = Paths.get("logs", "report");
            if (!Files.exists(logDir, new LinkOption[0])) {
                Files.createDirectories(logDir, new FileAttribute[0]);
            }
            String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            Path reportPath = logDir.resolve("ore_report_" + timestamp + ".md");
            Path reportPath_arrays = logDir.resolve("mat_report_arrays_" + timestamp + ".json");
            Path reportPath_table = logDir.resolve("mat_report_table_" + timestamp + ".csv");
            try (BufferedWriter writer = Files.newBufferedWriter(reportPath, new OpenOption[0]);){
                writer.write(report.toString());
            }
            writer = Files.newBufferedWriter(reportPath_arrays, new OpenOption[0]);
            try {
                writer.write(json.toString());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            writer = Files.newBufferedWriter(reportPath_table, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            try {
                writer.write(65279);
                writer.write(report_table.toString());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Exception e) {
            GTOCore.LOGGER.error("\u5199\u5165\u62a5\u544a\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    protected static String getHexColorString(int color) {
        String var10000 = Integer.toHexString(color);
        boolean alpha = (color >> 24 & 0xFF) != 0;
        int var10001 = alpha ? 8 : 6;
        return "#" + StringUtils.leftPad((String)var10000, (int)var10001, (char)'0');
    }

    public static class Entry {
        public String cnName;
        public String enName;
        public String symbol;
        public String hexColor1;
        public String hexColor2;
        public String iconSetName;
        public BaseType baseType;
        public long mass;
        public boolean hasFluidPipe;
        public int fluidPipeThroughput;
        public boolean hasItemPipe;
        public int itemPipePriority;
        public float itemPipeTransferRate;
        public boolean isWireMaterial;
        public int wireMaxAmperes;
        public long wireVoltage;
        public int wireLossPerMeter;
        public boolean isToolMaterial;
        public float harvestSpeedTool;
        public int durabilityTool;
        public int harvestLevelTool;
        public int enchantabilityTool;
        public boolean isUnbreakableTool;
        public int durabilityMultiplierTool;
        public boolean isRotorMaterial;
        public int durabilityRotor;
        public int powerRotor;
        public int efficiencyRotor;
        public int blastTemperature;
        public boolean isHazard;

        public static Entry fromMaterial(Material material) {
            Entry entry = new Entry();
            entry.cnName = material.getLocalizedName().getString();
            entry.enName = GTOComponentHandler.INSTANCE.getEnglishLanguage().m_118919_(material.getUnlocalizedName(), material.getUnlocalizedName());
            entry.symbol = material.getChemicalFormula();
            entry.hexColor1 = MaterialReport.getHexColorString(material.getMaterialRGB());
            entry.hexColor2 = MaterialReport.getHexColorString(material.getMaterialSecondaryRGB());
            entry.iconSetName = material.getMaterialIconSet().name;
            entry.baseType = BaseType.inferFromMaterial(material);
            entry.mass = material.getMass();
            entry.hasFluidPipe = material.hasProperty(PropertyKey.FLUID_PIPE);
            if (entry.hasFluidPipe) {
                FluidPipeProperties materialFluidPipeProperties = (FluidPipeProperties)material.getProperty(PropertyKey.FLUID_PIPE);
                entry.fluidPipeThroughput = materialFluidPipeProperties.getThroughput();
            }
            entry.hasItemPipe = material.hasProperty(PropertyKey.ITEM_PIPE);
            if (entry.hasItemPipe) {
                entry.itemPipePriority = ((ItemPipeProperties)material.getProperty(PropertyKey.ITEM_PIPE)).getPriority();
                entry.itemPipeTransferRate = ((ItemPipeProperties)material.getProperty(PropertyKey.ITEM_PIPE)).getTransferRate();
            }
            entry.isWireMaterial = material.hasProperty(PropertyKey.WIRE);
            if (entry.isWireMaterial) {
                entry.wireMaxAmperes = ((WireProperties)material.getProperty(PropertyKey.WIRE)).getAmperage();
                entry.wireVoltage = ((WireProperties)material.getProperty(PropertyKey.WIRE)).getVoltage();
                entry.wireLossPerMeter = ((WireProperties)material.getProperty(PropertyKey.WIRE)).getLossPerBlock();
            }
            entry.isToolMaterial = material.hasProperty(PropertyKey.TOOL);
            if (entry.isToolMaterial) {
                ToolProperty toolProperty = (ToolProperty)material.getProperty(PropertyKey.TOOL);
                entry.harvestSpeedTool = toolProperty.getHarvestSpeed();
                entry.durabilityTool = toolProperty.getDurability();
                entry.harvestLevelTool = toolProperty.getHarvestLevel();
                entry.enchantabilityTool = toolProperty.getEnchantability();
                entry.isUnbreakableTool = toolProperty.isUnbreakable();
                entry.durabilityMultiplierTool = toolProperty.getDurabilityMultiplier();
            }
            entry.isRotorMaterial = material.hasProperty(PropertyKey.ROTOR);
            if (entry.isRotorMaterial) {
                entry.durabilityRotor = ((RotorProperty)material.getProperty(PropertyKey.ROTOR)).getDurability();
                entry.powerRotor = ((RotorProperty)material.getProperty(PropertyKey.ROTOR)).getPower();
                entry.efficiencyRotor = ((RotorProperty)material.getProperty(PropertyKey.ROTOR)).getEfficiency();
            }
            entry.blastTemperature = material.hasProperty(PropertyKey.BLAST) ? ((BlastProperty)material.getProperty(PropertyKey.BLAST)).getBlastTemperature() : (material.hasProperty(PropertyKey.ALLOY_BLAST) ? ((AlloyBlastProperty)material.getProperty(PropertyKey.ALLOY_BLAST)).getTemperature() : 0);
            entry.isHazard = material.hasProperty(PropertyKey.HAZARD);
            return entry;
        }
    }

    @RegisterEnumLang(keyPrefix="gtocore.material.base_type")
    public static enum BaseType {
        METAL("\u91d1\u5c5e", "Metal"),
        GEM("\u5b9d\u77f3", "Gem"),
        CHEMICAL("\u5316\u5b66\u54c1", "Chemical"),
        POLYMER("\u9ad8\u5206\u5b50\u6750\u6599", "Polymer"),
        COMPOSITE("\u590d\u5408\u6750\u6599", "Composite"),
        CERAMIC("\u9676\u74f7", "Ceramic"),
        WOOD("\u6728\u6750", "Wood"),
        MAGIC("\u9b54\u6cd5\u6750\u6599", "Magic"),
        OTHER("\u5176\u4ed6", "Other");

        @RegisterEnumLang.CnValue(value="name")
        final String cn;
        @RegisterEnumLang.EnValue(value="name")
        final String en;

        private BaseType(String cn, String en) {
            this.cn = cn;
            this.en = en;
        }

        static BaseType inferFromMaterial(Material material) {
            if (material.hasFlag(GTOMaterialFlags.COMPOSITE_MATERIAL)) {
                return COMPOSITE;
            }
            if (material.hasFlag(GTOMaterialFlags.GENERATE_CERAMIC)) {
                return CERAMIC;
            }
            if (material.hasFlag(MaterialFlags.MAGICAL)) {
                return MAGIC;
            }
            if (material.hasProperty(PropertyKey.GEM)) {
                return GEM;
            }
            if (material.hasProperty(PropertyKey.WOOD)) {
                return WOOD;
            }
            if (material.hasProperty(PropertyKey.POLYMER)) {
                return POLYMER;
            }
            if (material.hasProperty(PropertyKey.BLAST) || material.hasProperty(PropertyKey.ALLOY_BLAST) || material.getMaterialIconSet() == MaterialIconSet.METALLIC) {
                return METAL;
            }
            return CHEMICAL;
        }
    }
}

