/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.report;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.gtolib.GTOCore;
import com.gtolib.utils.RegistriesUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.io.IOUtils;

public class LootTableExporter {
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTER = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP_FORMATTER = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd-HHmmss"));
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("#.##%");
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#.##");
    private static final Pattern PATTERN = Pattern.compile("[^a-zA-Z0-9_-]");

    public static void exportAllLootTables() {
        List<String> allLootTables = LootTableExporter.getAllLootTableLocations();
        LootTableExporter.exportLootTables(allLootTables);
    }

    public static void exportLootTables(List<String> lootTables) {
        if (lootTables == null || lootTables.isEmpty()) {
            GTOCore.LOGGER.warn("\u6ca1\u6709\u6307\u5b9a\u8981\u5bfc\u51fa\u7684\u6218\u5229\u54c1\u8868\u6216\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u6218\u5229\u54c1\u8868");
            return;
        }
        long startTime = System.nanoTime();
        LootTableExporter.exportAllLootTablesToMarkdown(lootTables);
        long endTime = System.nanoTime();
        long durationMs = TimeUnit.NANOSECONDS.toMillis(endTime - startTime);
        GTOCore.LOGGER.info("\u6218\u5229\u54c1\u8868\u5bfc\u51fa\u5b8c\u6210\uff0c\u5171\u5904\u7406 {} \u4e2a\u6218\u5229\u54c1\u8868\uff0c\u8017\u65f6 {} ms", (Object)lootTables.size(), (Object)durationMs);
    }

    public static List<String> getAllLootTableLocations() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            GTOCore.LOGGER.error("\u65e0\u6cd5\u83b7\u53d6\u670d\u52a1\u5668\u5b9e\u4f8b - \u53ef\u80fd\u4e0d\u5728\u670d\u52a1\u7aef\u73af\u5883\u6216\u670d\u52a1\u5668\u672a\u542f\u52a8");
            return Collections.emptyList();
        }
        ResourceManager resourceManager = server.m_177941_();
        Set allResources = resourceManager.m_214159_("loot_tables", path -> path.toString().endsWith(".json")).keySet();
        return allResources.stream().map(location -> {
            String path = location.m_135815_();
            String lootTablePath = path.substring("loot_tables/".length(), path.length() - ".json".length());
            return location.m_135827_() + ":" + lootTablePath;
        }).sorted().collect(Collectors.toList());
    }

    private static void exportAllLootTablesToMarkdown(List<String> lootTables) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            GTOCore.LOGGER.error("\u65e0\u6cd5\u83b7\u53d6\u670d\u52a1\u5668\u5b9e\u4f8b - \u53ef\u80fd\u4e0d\u5728\u670d\u52a1\u7aef\u73af\u5883\u6216\u670d\u52a1\u5668\u672a\u542f\u52a8");
            return;
        }
        try {
            LinkedHashMap<String, LootTableAnalysis> allLootTables = new LinkedHashMap<String, LootTableAnalysis>();
            Map lootTablesByNamespace = lootTables.stream().collect(Collectors.groupingBy(tableName -> new ResourceLocation(tableName).m_135827_(), TreeMap::new, Collectors.toList()));
            for (Map.Entry entry : lootTablesByNamespace.entrySet()) {
                String namespace = (String)entry.getKey();
                List namespaceTables = (List)entry.getValue();
                GTOCore.LOGGER.info("\u6b63\u5728\u5904\u7406\u547d\u540d\u7a7a\u95f4 {} \u4e0b\u7684 {} \u4e2a\u6218\u5229\u54c1\u8868", (Object)namespace, (Object)namespaceTables.size());
                for (String string : namespaceTables) {
                    LootTableExporter.processLootTable(server, string, allLootTables);
                }
            }
            Map lootTablesByType = allLootTables.values().stream().collect(Collectors.groupingBy(LootTableAnalysis::getType, TreeMap::new, Collectors.toList()));
            String timestamp = TIMESTAMP_FORMATTER.get().format(new Date());
            String randomNumber = String.format("%08d", (int)(Math.random() * 1.0E8));
            Path logDir = Paths.get("logs", "report", "loottable_analysis_" + timestamp + "_" + randomNumber);
            Files.createDirectories(logDir, new FileAttribute[0]);
            for (Map.Entry entry : lootTablesByType.entrySet()) {
                String type = (String)entry.getKey();
                List typeTables = (List)entry.getValue();
                String markdown = LootTableExporter.generateTypeMarkdown(type, typeTables, lootTablesByNamespace);
                String safeTypeName = PATTERN.matcher(type).replaceAll("_");
                Path reportPath = logDir.resolve("[" + safeTypeName + "].md");
                BufferedWriter writer = Files.newBufferedWriter(reportPath, new OpenOption[0]);
                try {
                    writer.write(markdown);
                    GTOCore.LOGGER.info("\u7c7b\u578b\u4e3a {} \u7684\u6218\u5229\u54c1\u8868\u5df2\u5bfc\u51fa\u5230: {}", (Object)type, (Object)reportPath.toAbsolutePath());
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            String summaryMarkdown = LootTableExporter.generateSummaryMarkdown(allLootTables, lootTablesByNamespace, lootTablesByType);
            Path path = logDir.resolve("\u6c47\u603b.md");
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(summaryMarkdown);
                GTOCore.LOGGER.info("\u6218\u5229\u54c1\u8868\u6c47\u603b\u5df2\u5bfc\u51fa\u5230: {}", (Object)path.toAbsolutePath());
            }
        }
        catch (IOException e) {
            GTOCore.LOGGER.error("\u5bfc\u51fa\u6218\u5229\u54c1\u8868\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void processLootTable(MinecraftServer server, String tableName, Map<String, LootTableAnalysis> allLootTables) {
        if (!ResourceLocation.m_135830_((String)tableName)) {
            GTOCore.LOGGER.error("\u65e0\u6548\u7684\u6218\u5229\u54c1\u8868\u540d\u79f0\u683c\u5f0f: {}", (Object)tableName);
            return;
        }
        ResourceLocation lootTableLocation = new ResourceLocation(tableName);
        LootTableAnalysis analysis = new LootTableAnalysis(tableName);
        try {
            JsonObject lootTableJson;
            String jsonText;
            ResourceManager resourceManager = server.m_177941_();
            ResourceLocation jsonLocation = new ResourceLocation(lootTableLocation.m_135827_(), "loot_tables/" + lootTableLocation.m_135815_() + ".json");
            Optional resourceOpt = resourceManager.m_213713_(jsonLocation);
            if (resourceOpt.isEmpty()) {
                GTOCore.LOGGER.error("\u627e\u4e0d\u5230\u6218\u5229\u54c1\u8868JSON: {}", (Object)jsonLocation);
                analysis.setError("\u627e\u4e0d\u5230\u6218\u5229\u54c1\u8868JSON\u8d44\u6e90");
                allLootTables.put(tableName, analysis);
                return;
            }
            Resource resource = (Resource)resourceOpt.get();
            try (InputStream inputStream = resource.m_215507_();){
                jsonText = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            }
            JsonElement jsonElement = JsonParser.parseString((String)jsonText);
            if (!jsonElement.isJsonObject()) {
                GTOCore.LOGGER.error("\u6218\u5229\u54c1\u8868JSON\u4e0d\u662f\u6709\u6548\u7684\u5bf9\u8c61: {}", (Object)jsonLocation);
                analysis.setError("\u6218\u5229\u54c1\u8868JSON\u683c\u5f0f\u9519\u8bef");
                allLootTables.put(tableName, analysis);
            }
            analysis.setType((lootTableJson = jsonElement.getAsJsonObject()).has("type") ? lootTableJson.get("type").getAsString() : "\u901a\u7528");
            ArrayList<String> globalConditions = new ArrayList<String>();
            if (lootTableJson.has("conditions") && lootTableJson.get("conditions").isJsonArray()) {
                for (JsonElement condElem : lootTableJson.getAsJsonArray("conditions")) {
                    if (condElem.isJsonObject()) {
                        globalConditions.add(LootTableExporter.parseCondition(condElem.getAsJsonObject()));
                        continue;
                    }
                    GTOCore.LOGGER.warn("\u6218\u5229\u54c1\u8868{}\u4e2d\u53d1\u73b0\u975e\u5bf9\u8c61\u7c7b\u578b\u7684\u6761\u4ef6", (Object)tableName);
                }
            }
            analysis.setGlobalConditions(globalConditions);
            List<LootPool> lootPools = LootTableExporter.processLootTable(lootTableJson);
            analysis.setLootPools(lootPools);
            allLootTables.put(tableName, analysis);
        }
        catch (IOException e) {
            String errorMsg = "\u5904\u7406\u6218\u5229\u54c1\u8868 " + tableName + " \u65f6\u51fa\u9519: " + e.getMessage();
            GTOCore.LOGGER.error(errorMsg, (Throwable)e);
            analysis.setError(errorMsg);
            allLootTables.put(tableName, analysis);
        }
        catch (Exception e) {
            String errorMsg = "\u5206\u6790\u6218\u5229\u54c1\u8868 " + tableName + " \u65f6\u53d1\u751f\u610f\u5916\u9519\u8bef: " + e.getMessage();
            GTOCore.LOGGER.error(errorMsg, (Throwable)e);
            analysis.setError(errorMsg);
            allLootTables.put(tableName, analysis);
        }
    }

    private static List<LootPool> processLootTable(JsonObject lootTableJson) {
        ArrayList<LootPool> lootPools = new ArrayList<LootPool>();
        if (lootTableJson.has("pools") && lootTableJson.get("pools").isJsonArray()) {
            int poolIndex = 1;
            for (JsonElement poolElement : lootTableJson.getAsJsonArray("pools")) {
                if (!poolElement.isJsonObject()) {
                    GTOCore.LOGGER.warn("\u53d1\u73b0\u975e\u5bf9\u8c61\u7c7b\u578b\u7684\u5956\u52b1\u6c60");
                    continue;
                }
                JsonObject pool = poolElement.getAsJsonObject();
                LootPool lootPool = new LootPool();
                lootPool.poolIndex = poolIndex;
                String string = lootPool.name = pool.has("name") ? pool.get("name").getAsString() : "-";
                if (pool.has("functions") && pool.get("functions").isJsonArray()) {
                    for (JsonElement functionElement : pool.getAsJsonArray("functions")) {
                        if (!functionElement.isJsonObject()) continue;
                        lootPool.functions.add(functionElement.getAsJsonObject());
                    }
                }
                if (pool.has("rolls")) {
                    lootPool.rolls = LootTableExporter.getValueInfo(pool.get("rolls"));
                } else {
                    ValueInfo defaultRolls = new ValueInfo();
                    defaultRolls.average = 1.0;
                    defaultRolls.detail = "1";
                    lootPool.rolls = defaultRolls;
                    GTOCore.LOGGER.debug("\u5956\u52b1\u6c60{}\u672a\u6307\u5b9arolls\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c1", (Object)poolIndex);
                }
                if (pool.has("bonus_rolls")) {
                    lootPool.bonusRolls = LootTableExporter.getValueInfo(pool.get("bonus_rolls"));
                }
                if (pool.has("conditions") && pool.get("conditions").isJsonArray()) {
                    for (JsonElement condElem : pool.getAsJsonArray("conditions")) {
                        if (condElem.isJsonObject()) {
                            lootPool.conditions.add(LootTableExporter.parseCondition(condElem.getAsJsonObject()));
                            continue;
                        }
                        GTOCore.LOGGER.warn("\u5956\u52b1\u6c60{}\u4e2d\u53d1\u73b0\u975e\u5bf9\u8c61\u7c7b\u578b\u7684\u6761\u4ef6", (Object)poolIndex);
                    }
                }
                if (pool.has("entries") && pool.get("entries").isJsonArray()) {
                    for (JsonElement entryElement : pool.getAsJsonArray("entries")) {
                        if (entryElement.isJsonObject()) {
                            LootTableExporter.processLootEntry(entryElement.getAsJsonObject(), lootPool);
                            continue;
                        }
                        GTOCore.LOGGER.warn("\u5956\u52b1\u6c60{}\u4e2d\u53d1\u73b0\u975e\u5bf9\u8c61\u7c7b\u578b\u7684\u6761\u76ee", (Object)poolIndex);
                    }
                }
                LootTableExporter.applyPoolFunctionsToItems(lootPool);
                LootTableExporter.calculatePoolStats(lootPool);
                lootPools.add(lootPool);
                ++poolIndex;
            }
        } else {
            GTOCore.LOGGER.debug("\u6218\u5229\u54c1\u8868\u4e0d\u5305\u542bpools\u6570\u7ec4\u6216pools\u4e0d\u662f\u6570\u7ec4\u7c7b\u578b");
        }
        return lootPools;
    }

    private static void applyPoolFunctionsToItems(LootPool lootPool) {
        if (lootPool.lootItems == null || lootPool.functions == null) {
            return;
        }
        for (LootItem item : lootPool.lootItems) {
            for (JsonObject function : lootPool.functions) {
                LootTableExporter.processFunction(function, item, true);
            }
        }
    }

    private static void processLootEntry(JsonObject entry, LootPool lootPool) {
        String entryType;
        if (entry == null) {
            GTOCore.LOGGER.warn("\u5904\u7406\u7a7a\u7684\u6218\u5229\u54c1\u6761\u76ee");
            return;
        }
        if (!entry.has("type")) {
            GTOCore.LOGGER.warn("\u53d1\u73b0\u6ca1\u6709\u7c7b\u578b\u7684\u6218\u5229\u54c1\u6761\u76ee");
            return;
        }
        String string = entryType = entry.get("type").getAsString();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"minecraft:item", "minecraft:tag", "minecraft:loot_table", "minecraft:empty", "minecraft:group"}, (Object)string, n)) {
            case 0: {
                LootTableExporter.processItemEntry(entry, lootPool);
                break;
            }
            case 1: {
                LootTableExporter.processTagEntry(entry, lootPool);
                break;
            }
            case 2: {
                LootTableExporter.processLootTableEntry(entry, lootPool);
                break;
            }
            case 3: {
                LootTableExporter.processEmptyEntry(entry, lootPool);
                break;
            }
            case 4: {
                LootTableExporter.processGroupEntry(entry, lootPool);
                break;
            }
            default: {
                GTOCore.LOGGER.debug("\u672a\u5904\u7406\u7684\u6218\u5229\u54c1\u6761\u76ee\u7c7b\u578b: {}", (Object)entryType);
                LootItem lootItem = new LootItem();
                lootItem.type = "\u672a\u5904\u7406\u7c7b\u578b";
                lootItem.itemId = entryType;
                lootItem.displayName = "\u672a\u5904\u7406: " + entryType;
                lootItem.weight = entry.has("weight") ? entry.get("weight").getAsDouble() : 1.0;
                lootPool.lootItems.add(lootItem);
            }
        }
    }

    private static void processItemEntry(JsonObject entry, LootPool lootPool) {
        LootItem lootItem = new LootItem();
        lootItem.type = "\u7269\u54c1";
        if (entry.has("name")) {
            lootItem.itemId = entry.get("name").getAsString();
            lootItem.displayName = LootTableExporter.getItemTranslation(lootItem.itemId);
        } else {
            GTOCore.LOGGER.warn("\u7269\u54c1\u6761\u76ee\u7f3a\u5c11name\u5c5e\u6027");
            lootItem.itemId = "unknown";
            lootItem.displayName = "\u672a\u77e5\u7269\u54c1";
        }
        lootItem.weight = entry.has("weight") ? entry.get("weight").getAsDouble() : 1.0;
        double d = lootItem.quality = entry.has("quality") ? entry.get("quality").getAsDouble() : 0.0;
        if (entry.has("conditions") && entry.get("conditions").isJsonArray()) {
            for (JsonElement condElem : entry.getAsJsonArray("conditions")) {
                if (!condElem.isJsonObject()) continue;
                lootItem.conditions.add(LootTableExporter.parseCondition(condElem.getAsJsonObject()));
                lootItem.conditionFactor *= 0.7;
            }
        }
        if (entry.has("functions") && entry.get("functions").isJsonArray()) {
            for (JsonElement functionElement : entry.getAsJsonArray("functions")) {
                if (!functionElement.isJsonObject()) continue;
                LootTableExporter.processFunction(functionElement.getAsJsonObject(), lootItem, false);
            }
        }
        lootPool.lootItems.add(lootItem);
    }

    private static void processFunction(JsonObject function, LootItem lootItem, boolean isPoolFunction) {
        if (function == null || lootItem == null || !function.has("function")) {
            return;
        }
        String functionType = function.get("function").getAsString();
        String functionSource = isPoolFunction ? "\u6c60\u7ea7\u522b" : "\u6761\u76ee\u7ea7\u522b";
        lootItem.functions.add(functionSource + ":" + functionType);
        String string = functionType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"minecraft:set_count", "minecraft:add_count", "minecraft:looting_enchant", "minecraft:enchant_randomly", "minecraft:enchant_with_levels", "minecraft:potion", "minecraft:smelt", "minecraft:set_damage", "minecraft:set_nbt", "minecraft:fill_player_head", "minecraft:entity\u88c5\u5907", "minecraft:copy_name", "minecraft:copy_nbt", "minecraft:limit_count", "minecraft:set_attributes", "minecraft:set_book_contents", "minecraft:set_lore", "minecraft:set_name", "minecraft:explosion_decay"}, (Object)string, n)) {
            case 0: {
                boolean isAdd = function.has("add") && function.get("add").getAsBoolean();
                String string2 = lootItem.countOperation = isAdd ? "\u6dfb\u52a0" : "\u8bbe\u7f6e";
                if (!function.has("count")) break;
                ValueInfo countInfo = LootTableExporter.getValueInfo(function.get("count"));
                if (isAdd) {
                    lootItem.count += countInfo.average;
                    lootItem.countDetail = (String)(lootItem.countDetail != null ? lootItem.countDetail + "+" : "") + countInfo.detail;
                } else {
                    lootItem.count = countInfo.average;
                    lootItem.countDetail = countInfo.detail;
                }
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60" : " (") + lootItem.countOperation + "\u6570\u91cf: " + countInfo.detail + ")";
                break;
            }
            case 1: {
                lootItem.countOperation = "\u6dfb\u52a0";
                if (!function.has("count")) break;
                ValueInfo countInfo = LootTableExporter.getValueInfo(function.get("count"));
                lootItem.count += countInfo.average;
                lootItem.countDetail = (String)(lootItem.countDetail != null ? lootItem.countDetail + "+" : "") + countInfo.detail;
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u6dfb\u52a0\u6570\u91cf: " : " (\u6dfb\u52a0\u6570\u91cf: ") + countInfo.detail + ")";
                break;
            }
            case 2: {
                lootItem.lootingAffected = true;
                if (function.has("count")) {
                    ValueInfo countInfo = LootTableExporter.getValueInfo(function.get("count"));
                    lootItem.lootingCount = countInfo.average;
                    lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u63a0\u593a\u52a0\u6210: " : " (\u63a0\u593a\u52a0\u6210: ") + countInfo.detail + "\u6bcf\u7ea7)";
                }
                if (!function.has("limit")) break;
                lootItem.lootingLimit = function.get("limit").getAsInt();
                lootItem.displayName = lootItem.displayName + " (\u4e0a\u9650: " + lootItem.lootingLimit + ")";
                break;
            }
            case 3: {
                lootItem.enchanted = true;
                if (function.has("enchantments")) {
                    lootItem.enchantments = function.getAsJsonArray("enchantments").toString().replace("[", "").replace("]", "").replace("\"", "");
                    lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u968f\u673a\u9644\u9b54: " : " (\u968f\u673a\u9644\u9b54: ") + lootItem.enchantments + ")";
                    break;
                }
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u968f\u673a\u9644\u9b54)" : " (\u968f\u673a\u9644\u9b54)");
                break;
            }
            case 4: {
                lootItem.enchanted = true;
                lootItem.enchantWithLevels = true;
                if (function.has("levels")) {
                    ValueInfo levelsInfo = LootTableExporter.getValueInfo(function.get("levels"));
                    lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u7b49\u7ea7\u9644\u9b54: " : " (\u7b49\u7ea7\u9644\u9b54: ") + levelsInfo.detail + "\u7ea7)";
                }
                if (!function.has("treasure") || !function.get("treasure").getAsBoolean()) break;
                lootItem.treasureEnchant = true;
                lootItem.displayName = lootItem.displayName + " (\u5305\u542b\u5b9d\u85cf\u9644\u9b54)";
                break;
            }
            case 5: {
                lootItem.hasPotion = true;
                if (function.has("potion")) {
                    lootItem.potionType = function.get("potion").getAsString();
                    lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u836f\u6c34: " : " (\u836f\u6c34: ") + lootItem.potionType + ")";
                    break;
                }
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u968f\u673a\u836f\u6c34)" : " (\u968f\u673a\u836f\u6c34)");
                break;
            }
            case 6: {
                lootItem.smelted = true;
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u5df2\u51b6\u70bc)" : " (\u5df2\u51b6\u70bc)");
                break;
            }
            case 7: {
                lootItem.hasDamage = true;
                if (!function.has("damage")) break;
                ValueInfo damageInfo = LootTableExporter.getValueInfo(function.get("damage"));
                lootItem.damage = damageInfo.average;
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u635f\u4f24: " : " (\u635f\u4f24: ") + damageInfo.detail + ")";
                break;
            }
            case 8: {
                lootItem.hasNbt = true;
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u6709NBT\u6570\u636e)" : " (\u6709NBT\u6570\u636e)");
                break;
            }
            case 9: {
                lootItem.hasPlayerHeadData = true;
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u586b\u5145\u73a9\u5bb6\u5934\u9885\u6570\u636e)" : " (\u586b\u5145\u73a9\u5bb6\u5934\u9885\u6570\u636e)");
                break;
            }
            case 10: {
                lootItem.isEntityEquipment = true;
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u5b9e\u4f53\u88c5\u5907)" : " (\u5b9e\u4f53\u88c5\u5907)");
                break;
            }
            case 11: {
                lootItem.copyName = true;
                String source = function.has("source") ? function.get("source").getAsString() : "\u5b9e\u4f53";
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u590d\u5236" : " (\u590d\u5236") + source + "\u540d\u79f0)";
                break;
            }
            case 12: {
                lootItem.copyNbt = true;
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u590d\u5236NBT)" : " (\u590d\u5236NBT)");
                break;
            }
            case 13: {
                lootItem.limitCount = true;
                if (!function.has("limit")) break;
                int limit = function.get("limit").getAsInt();
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u6570\u91cf\u4e0a\u9650: " : " (\u6570\u91cf\u4e0a\u9650: ") + limit + ")";
                break;
            }
            case 14: {
                lootItem.hasAttributes = true;
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u8bbe\u7f6e\u5c5e\u6027)" : " (\u8bbe\u7f6e\u5c5e\u6027)");
                break;
            }
            case 15: {
                lootItem.hasBookContents = true;
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u8bbe\u7f6e\u4e66\u672c\u5185\u5bb9)" : " (\u8bbe\u7f6e\u4e66\u672c\u5185\u5bb9)");
                break;
            }
            case 16: {
                lootItem.hasLore = true;
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u8bbe\u7f6e Lore)" : " (\u8bbe\u7f6e Lore)");
                break;
            }
            case 17: {
                lootItem.hasCustomName = true;
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u81ea\u5b9a\u4e49\u540d\u79f0)" : " (\u81ea\u5b9a\u4e49\u540d\u79f0)");
                break;
            }
            case 18: {
                lootItem.explosionDecay = true;
                lootItem.displayName = lootItem.displayName + (isPoolFunction ? " (\u6c60\u7206\u70b8\u8870\u51cf)" : " (\u7206\u70b8\u8870\u51cf)");
                break;
            }
            default: {
                GTOCore.LOGGER.debug("\u672a\u5904\u7406\u7684{}\u51fd\u6570\u7c7b\u578b: {}", (Object)functionSource, (Object)functionType);
                lootItem.otherFunctions.add(functionSource + ":" + functionType);
            }
        }
    }

    private static void processTagEntry(JsonObject entry, LootPool lootPool) {
        if (entry == null || lootPool == null) {
            GTOCore.LOGGER.warn("\u5904\u7406\u7a7a\u7684\u6807\u7b7e\u6761\u76ee\u6216\u5956\u52b1\u6c60");
            return;
        }
        LootItem lootItem = new LootItem();
        lootItem.type = "\u6807\u7b7e";
        if (entry.has("name")) {
            lootItem.itemId = entry.get("name").getAsString();
            lootItem.displayName = "\u6807\u7b7e: " + lootItem.itemId;
        } else {
            GTOCore.LOGGER.warn("\u6807\u7b7e\u6761\u76ee\u7f3a\u5c11name\u5c5e\u6027");
            lootItem.itemId = "unknown:tag";
            lootItem.displayName = "\u672a\u77e5\u6807\u7b7e";
        }
        lootItem.weight = entry.has("weight") ? entry.get("weight").getAsDouble() : 1.0;
        double d = lootItem.quality = entry.has("quality") ? entry.get("quality").getAsDouble() : 0.0;
        if (entry.has("conditions") && entry.get("conditions").isJsonArray()) {
            for (JsonElement condElem : entry.getAsJsonArray("conditions")) {
                if (!condElem.isJsonObject()) continue;
                lootItem.conditions.add(LootTableExporter.parseCondition(condElem.getAsJsonObject()));
                lootItem.conditionFactor *= 0.7;
            }
        }
        lootPool.lootItems.add(lootItem);
    }

    private static void processLootTableEntry(JsonObject entry, LootPool lootPool) {
        if (entry == null || lootPool == null) {
            GTOCore.LOGGER.warn("\u5904\u7406\u7a7a\u7684\u6218\u5229\u54c1\u8868\u5f15\u7528\u6761\u76ee\u6216\u5956\u52b1\u6c60");
            return;
        }
        LootItem lootItem = new LootItem();
        lootItem.type = "\u6218\u5229\u54c1\u8868\u5f15\u7528";
        if (entry.has("name")) {
            lootItem.itemId = entry.get("name").getAsString();
            lootItem.displayName = "\u5f15\u7528: " + lootItem.itemId;
        } else {
            GTOCore.LOGGER.warn("\u6218\u5229\u54c1\u8868\u5f15\u7528\u6761\u76ee\u7f3a\u5c11name\u5c5e\u6027");
            lootItem.itemId = "unknown:loottable";
            lootItem.displayName = "\u672a\u77e5\u6218\u5229\u54c1\u8868\u5f15\u7528";
        }
        lootItem.weight = entry.has("weight") ? entry.get("weight").getAsDouble() : 1.0;
        double d = lootItem.quality = entry.has("quality") ? entry.get("quality").getAsDouble() : 0.0;
        if (entry.has("conditions") && entry.get("conditions").isJsonArray()) {
            for (JsonElement condElem : entry.getAsJsonArray("conditions")) {
                if (!condElem.isJsonObject()) continue;
                lootItem.conditions.add(LootTableExporter.parseCondition(condElem.getAsJsonObject()));
                lootItem.conditionFactor *= 0.7;
            }
        }
        lootPool.lootItems.add(lootItem);
    }

    private static void processEmptyEntry(JsonObject entry, LootPool lootPool) {
        if (entry == null || lootPool == null) {
            GTOCore.LOGGER.warn("\u5904\u7406\u7a7a\u7684\u7a7a\u6761\u76ee\u6216\u5956\u52b1\u6c60");
            return;
        }
        LootItem lootItem = new LootItem();
        lootItem.type = "\u7a7a";
        lootItem.itemId = "empty";
        lootItem.displayName = "\u65e0\u7269\u54c1";
        lootItem.weight = entry.has("weight") ? entry.get("weight").getAsDouble() : 1.0;
        lootPool.lootItems.add(lootItem);
    }

    private static void processGroupEntry(JsonObject entry, LootPool lootPool) {
        if (entry == null || lootPool == null) {
            GTOCore.LOGGER.warn("\u5904\u7406\u7a7a\u7684\u7ec4\u6761\u76ee\u6216\u5956\u52b1\u6c60");
            return;
        }
        LootItem lootItem = new LootItem();
        lootItem.type = "\u7ec4";
        lootItem.itemId = "group";
        lootItem.displayName = "\u7269\u54c1\u7ec4";
        lootItem.weight = entry.has("weight") ? entry.get("weight").getAsDouble() : 1.0;
        double d = lootItem.quality = entry.has("quality") ? entry.get("quality").getAsDouble() : 0.0;
        if (entry.has("conditions") && entry.get("conditions").isJsonArray()) {
            for (JsonElement condElem : entry.getAsJsonArray("conditions")) {
                if (!condElem.isJsonObject()) continue;
                lootItem.conditions.add(LootTableExporter.parseCondition(condElem.getAsJsonObject()));
                lootItem.conditionFactor *= 0.7;
            }
        }
        if (entry.has("children") && entry.get("children").isJsonArray()) {
            int childCount = entry.getAsJsonArray("children").size();
            lootItem.displayName = lootItem.displayName + " (" + childCount + "\u4e2a\u5b50\u6761\u76ee)";
        }
        lootPool.lootItems.add(lootItem);
    }

    private static String parseCondition(JsonObject condition) {
        if (condition == null || !condition.has("condition")) {
            return "\u672a\u77e5\u6761\u4ef6";
        }
        String conditionType = condition.get("condition").getAsString();
        StringBuilder sb = new StringBuilder();
        switch (conditionType) {
            case "minecraft:killed_by_player": {
                sb.append("\u88ab\u73a9\u5bb6\u6740\u6b7b");
                break;
            }
            case "minecraft:random_chance": {
                double chance = condition.get("chance").getAsDouble();
                sb.append(String.format("\u968f\u673a\u6982\u7387 (%.0f%%)", chance * 100.0));
                break;
            }
            case "minecraft:random_chance_with_looting": {
                double baseChance = condition.get("chance").getAsDouble();
                double lootingMultiplier = condition.get("looting_multiplier").getAsDouble();
                sb.append(String.format("\u968f\u63a0\u593a\u7b49\u7ea7\u53d8\u5316\u7684\u6982\u7387 (\u57fa\u7840: %.0f%%, \u6bcf\u7ea7\u63a0\u593a+%.0f%%)", baseChance * 100.0, lootingMultiplier * 100.0));
                break;
            }
            case "minecraft:difficulty": {
                sb.append("\u96be\u5ea6: ").append(condition.get("difficulty").getAsString());
                break;
            }
            case "minecraft:tool": {
                if (condition.has("predicate") && condition.get("predicate").isJsonObject()) {
                    JsonObject predicate = condition.getAsJsonObject("predicate");
                    if (predicate.has("tag")) {
                        sb.append("\u9700\u8981\u5de5\u5177\u6807\u7b7e: ").append(predicate.get("tag").getAsString());
                        break;
                    }
                    sb.append("\u9700\u8981\u7279\u5b9a\u5de5\u5177");
                    break;
                }
                sb.append("\u9700\u8981\u7279\u5b9a\u5de5\u5177");
                break;
            }
            case "minecraft:entity_properties": {
                sb.append("\u5b9e\u4f53\u5c5e\u6027\u6761\u4ef6");
                break;
            }
            case "minecraft:location_check": {
                sb.append("\u4f4d\u7f6e\u68c0\u67e5\u6761\u4ef6");
                break;
            }
            case "minecraft:weather_check": {
                sb.append("\u5929\u6c14\u68c0\u67e5\u6761\u4ef6");
                break;
            }
            case "minecraft:time_check": {
                sb.append("\u65f6\u95f4\u68c0\u67e5\u6761\u4ef6");
                break;
            }
            case "minecraft:dimension": {
                sb.append("\u7ef4\u5ea6: ").append(condition.get("dimension").getAsString());
                break;
            }
            case "minecraft:match_tool": {
                sb.append("\u5de5\u5177\u5339\u914d\u6761\u4ef6");
                break;
            }
            default: {
                sb.append("\u6761\u4ef6: ").append(conditionType);
            }
        }
        return sb.toString();
    }

    private static void calculatePoolStats(LootPool lootPool) {
        double totalWeight;
        if (lootPool == null || lootPool.lootItems == null) {
            return;
        }
        lootPool.totalWeight = totalWeight = lootPool.lootItems.stream().mapToDouble(item -> item.weight).sum();
        double baseRolls = lootPool.rolls != null ? lootPool.rolls.average : 1.0;
        double bonusRolls = lootPool.bonusRolls != null ? lootPool.bonusRolls.average : 0.0;
        lootPool.totalRollsAverage = baseRolls + bonusRolls;
        for (LootItem item2 : lootPool.lootItems) {
            if (totalWeight <= 0.0) {
                item2.probability = 0.0;
                item2.expectedValue = 0.0;
                continue;
            }
            double baseProb = item2.weight / totalWeight;
            double conditionalProb = baseProb * item2.conditionFactor;
            conditionalProb = Math.max(0.0, Math.min(1.0, conditionalProb));
            item2.probability = 1.0 - Math.pow(1.0 - conditionalProb, lootPool.totalRollsAverage);
            item2.probability = Math.max(0.0, Math.min(1.0, item2.probability));
            item2.expectedValue = item2.probability * item2.count;
            lootPool.totalExpectedValue += item2.expectedValue;
        }
        if (!lootPool.lootItems.isEmpty()) {
            lootPool.lootItems.sort((a2, b2) -> Double.compare(b2.probability, a2.probability));
        }
    }

    private static ValueInfo getValueInfo(JsonElement element) {
        ValueInfo info;
        block19: {
            info = new ValueInfo();
            if (element == null || element.isJsonNull()) {
                info.average = 1.0;
                info.detail = "1";
                return info;
            }
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                if (obj.has("min") && obj.has("max")) {
                    try {
                        double min = obj.get("min").getAsDouble();
                        double max = obj.get("max").getAsDouble();
                        if (min > max) {
                            double temp = min;
                            min = max;
                            max = temp;
                            GTOCore.LOGGER.warn("\u53d1\u73b0min > max\u7684\u60c5\u51b5\uff0c\u5df2\u81ea\u52a8\u4ea4\u6362");
                        }
                        info.average = (min + max) / 2.0;
                        if (min == (double)((long)min) && max == (double)((long)max)) {
                            info.detail = String.format("%d-%d", (long)min, (long)max);
                            break block19;
                        }
                        info.detail = String.format("%.1f-%.1f", min, max);
                    }
                    catch (Exception e) {
                        GTOCore.LOGGER.warn("\u89e3\u6790\u8303\u56f4\u503c\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
                        info.average = 1.0;
                        info.detail = "1";
                    }
                } else if (obj.has("value")) {
                    try {
                        info.average = obj.get("value").getAsDouble();
                        if (info.average == (double)((long)info.average)) {
                            info.detail = String.format("%d", (long)info.average);
                            break block19;
                        }
                        info.detail = String.valueOf(info.average);
                    }
                    catch (Exception e) {
                        GTOCore.LOGGER.warn("\u89e3\u6790\u56fa\u5b9a\u503c\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
                        info.average = 1.0;
                        info.detail = "1";
                    }
                } else {
                    info.average = 1.0;
                    info.detail = "1";
                }
            } else if (element.isJsonPrimitive()) {
                try {
                    info.average = element.getAsDouble();
                    if (info.average == (double)((long)info.average)) {
                        info.detail = String.format("%d", (long)info.average);
                        break block19;
                    }
                    info.detail = String.valueOf(info.average);
                }
                catch (Exception e) {
                    GTOCore.LOGGER.warn("\u89e3\u6790\u539f\u59cb\u503c\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
                    info.average = 1.0;
                    info.detail = "1";
                }
            } else {
                info.average = 1.0;
                info.detail = "1";
            }
        }
        return info;
    }

    private static String getItemTranslation(String itemId) {
        try {
            if (itemId == null || !ResourceLocation.m_135830_((String)itemId)) {
                return "\u65e0\u6548ID: " + (itemId == null ? "null" : itemId);
            }
            Item item = RegistriesUtils.getItem((String)itemId);
            if (item != null) {
                String translation = item.m_41466_().getString();
                if (translation.isEmpty()) {
                    return itemId;
                }
                return translation + " (`" + itemId + "`)";
            }
        }
        catch (Exception e) {
            GTOCore.LOGGER.warn("\u65e0\u6cd5\u83b7\u53d6\u7269\u54c1 {} \u7684\u7ffb\u8bd1: {}", (Object)itemId, (Object)e.getMessage());
        }
        return itemId;
    }

    private static String generateTypeMarkdown(String type, List<LootTableAnalysis> typeTables, Map<String, List<String>> lootTablesByNamespace) {
        if (typeTables == null || typeTables.isEmpty()) {
            return "# " + type + " \u7c7b\u578b\u6218\u5229\u54c1\u8868\u5206\u6790\u62a5\u544a\n\n\u6ca1\u6709\u8be5\u7c7b\u578b\u7684\u6218\u5229\u54c1\u8868\u6570\u636e\u3002";
        }
        StringBuilder markdown = new StringBuilder();
        markdown.append("# Minecraft \u6218\u5229\u54c1\u8868\u5206\u6790\u62a5\u544a - \u7c7b\u578b: ").append(type).append("\n\n");
        markdown.append("\u751f\u6210\u65f6\u95f4: ").append(DATE_FORMATTER.get().format(new Date())).append("\n\n");
        markdown.append("## \u6458\u8981\n");
        markdown.append("- \u672c\u7c7b\u578b\u6218\u5229\u54c1\u8868\u6570\u91cf: ").append(typeTables.size()).append("\n");
        Map<String, Long> namespaceCount = typeTables.stream().map(analysis -> new ResourceLocation(analysis.getName()).m_135827_()).collect(Collectors.groupingBy(namespace -> namespace, Collectors.counting()));
        markdown.append("\n### \u547d\u540d\u7a7a\u95f4\u5206\u5e03\n");
        for (Map.Entry<String, Long> entry : namespaceCount.entrySet()) {
            markdown.append("- ").append(entry.getKey()).append(": ").append(entry.getValue()).append(" \u4e2a\u6218\u5229\u54c1\u8868\n");
        }
        long errorCount = typeTables.stream().filter(a2 -> a2.getError() != null).count();
        markdown.append("\n- \u5206\u6790\u5931\u8d25\u7684\u6218\u5229\u54c1\u8868: ").append(errorCount).append("\n\n");
        Map byNamespace = typeTables.stream().collect(Collectors.groupingBy(analysis -> new ResourceLocation(analysis.getName()).m_135827_(), TreeMap::new, Collectors.toList()));
        for (Map.Entry namespaceEntry : byNamespace.entrySet()) {
            String namespace2 = (String)namespaceEntry.getKey();
            List namespaceTables = (List)namespaceEntry.getValue();
            markdown.append("## \u547d\u540d\u7a7a\u95f4: ").append(namespace2).append("\n");
            markdown.append("**\u5305\u542b\u672c\u7c7b\u578b\u6218\u5229\u54c1\u8868\u6570\u91cf:** ").append(namespaceTables.size()).append("\n\n");
            for (LootTableAnalysis analysis2 : namespaceTables) {
                String tableName = analysis2.getName();
                markdown.append("### \u6218\u5229\u54c1\u8868: ").append(tableName).append("\n\n");
                if (analysis2.getError() != null) {
                    markdown.append("> **\u9519\u8bef**: ").append(analysis2.getError()).append("\n\n");
                    continue;
                }
                markdown.append("**\u7c7b\u578b**: ").append(analysis2.getType()).append("\n");
                if (!analysis2.getGlobalConditions().isEmpty()) {
                    markdown.append("**\u5168\u5c40\u6761\u4ef6**: \n");
                    for (String cond : analysis2.getGlobalConditions()) {
                        markdown.append("- ").append(cond).append("\n");
                    }
                    markdown.append("\n");
                }
                for (LootPool pool2 : analysis2.getLootPools()) {
                    if (pool2 == null) continue;
                    markdown.append("#### \u5956\u52b1\u6c60 ").append(pool2.poolIndex).append((String)(pool2.name != null ? " (" + pool2.name + ")" : "")).append("\n\n");
                    if (!pool2.functions.isEmpty()) {
                        markdown.append("**\u6c60\u7ea7\u51fd\u6570:**\n");
                        for (JsonObject func : pool2.functions) {
                            if (func == null || !func.has("function")) continue;
                            String funcName = func.get("function").getAsString();
                            markdown.append("- ").append(funcName);
                            if (func.has("count")) {
                                markdown.append(" (\u6570\u91cf: ").append(LootTableExporter.getValueInfo((JsonElement)func.get((String)"count")).detail).append(")");
                            } else if (func.has("levels")) {
                                markdown.append(" (\u7b49\u7ea7: ").append(LootTableExporter.getValueInfo((JsonElement)func.get((String)"levels")).detail).append(")");
                            } else if (func.has("limit")) {
                                markdown.append(" (\u4e0a\u9650: ").append(func.get("limit").getAsInt()).append(")");
                            }
                            markdown.append("\n");
                        }
                        markdown.append("\n");
                    }
                    markdown.append("**\u6c60\u4fe1\u606f:**\n");
                    markdown.append("- \u62bd\u53d6\u6b21\u6570: ").append(pool2.rolls != null ? pool2.rolls.detail : "1").append(" (\u5e73\u5747: ").append(pool2.rolls != null ? NUMBER_FORMAT.format(pool2.rolls.average) : "1").append(")\n");
                    if (pool2.bonusRolls != null) {
                        markdown.append("- \u989d\u5916\u62bd\u53d6\u6b21\u6570: ").append(pool2.bonusRolls.detail).append(" (\u5e73\u5747: ").append(NUMBER_FORMAT.format(pool2.bonusRolls.average)).append(")\n");
                    }
                    markdown.append("- \u603b\u5e73\u5747\u62bd\u53d6\u6b21\u6570: ").append(NUMBER_FORMAT.format(pool2.totalRollsAverage)).append("\n");
                    markdown.append("- \u7269\u54c1\u6761\u76ee\u603b\u6570: ").append(pool2.lootItems.size()).append("\n");
                    markdown.append("- \u603b\u6743\u91cd: ").append(NUMBER_FORMAT.format(pool2.totalWeight)).append("\n");
                    markdown.append("- \u603b\u671f\u671b\u503c: ").append(NUMBER_FORMAT.format(pool2.totalExpectedValue)).append("\n");
                    if (!pool2.conditions.isEmpty()) {
                        markdown.append("- \u6c60\u6761\u4ef6: \n");
                        for (String cond : pool2.conditions) {
                            markdown.append("  - ").append(cond).append("\n");
                        }
                    }
                    markdown.append("\n");
                    markdown.append("| \u7c7b\u578b | \u7269\u54c1 | \u6570\u91cf | \u6743\u91cd | \u6982\u7387 | \u671f\u671b | \u7279\u6b8a\u5c5e\u6027 |\n");
                    markdown.append("|------|------|------|------|------|------|----------|\n");
                    for (LootItem item2 : pool2.lootItems) {
                        if (item2 == null) continue;
                        ArrayList<Object> attributes = new ArrayList<Object>();
                        if (item2.enchanted) {
                            attributes.add("\u5df2\u9644\u9b54");
                        }
                        if (item2.enchantWithLevels) {
                            attributes.add("\u7b49\u7ea7\u9644\u9b54");
                        }
                        if (item2.treasureEnchant) {
                            attributes.add("\u5b9d\u85cf\u9644\u9b54");
                        }
                        if (item2.smelted) {
                            attributes.add("\u5df2\u51b6\u70bc");
                        }
                        if (item2.hasNbt) {
                            attributes.add("\u6709NBT");
                        }
                        if (item2.copyNbt) {
                            attributes.add("\u590d\u5236NBT");
                        }
                        if (item2.lootingAffected) {
                            attributes.add("\u53d7\u63a0\u593a\u5f71\u54cd");
                        }
                        if (item2.hasDamage) {
                            attributes.add("\u6709\u635f\u8017");
                        }
                        if (item2.hasPotion) {
                            attributes.add("\u6709\u836f\u6c34\u6548\u679c");
                        }
                        if (item2.copyName) {
                            attributes.add("\u590d\u5236\u540d\u79f0");
                        }
                        if (item2.limitCount) {
                            attributes.add("\u6570\u91cf\u6709\u9650\u5236");
                        }
                        if (item2.hasAttributes) {
                            attributes.add("\u6709\u5c5e\u6027");
                        }
                        if (item2.hasBookContents) {
                            attributes.add("\u6709\u4e66\u672c\u5185\u5bb9");
                        }
                        if (item2.hasLore) {
                            attributes.add("\u6709Lore");
                        }
                        if (item2.hasCustomName) {
                            attributes.add("\u6709\u81ea\u5b9a\u4e49\u540d\u79f0");
                        }
                        if (item2.explosionDecay) {
                            attributes.add("\u7206\u70b8\u8870\u51cf");
                        }
                        if (item2.hasPlayerHeadData) {
                            attributes.add("\u73a9\u5bb6\u5934\u9885\u6570\u636e");
                        }
                        if (item2.isEntityEquipment) {
                            attributes.add("\u5b9e\u4f53\u88c5\u5907");
                        }
                        if (!item2.otherFunctions.isEmpty()) {
                            attributes.add("\u5176\u4ed6\u51fd\u6570: " + String.join((CharSequence)",", item2.otherFunctions));
                        }
                        String attrStr = attributes.isEmpty() ? "-" : String.join((CharSequence)", ", attributes);
                        String displayName = item2.displayName != null ? item2.displayName : "\u672a\u77e5";
                        String countDetail = item2.countDetail != null ? item2.countDetail : NUMBER_FORMAT.format(item2.count);
                        String countOp = item2.countOperation != null ? item2.countOperation + " " : "";
                        markdown.append("| ").append(item2.type).append(" | ").append(displayName).append(" | ").append(countOp).append(countDetail).append(" | ").append(NUMBER_FORMAT.format(item2.weight)).append(" | ").append(PERCENT_FORMAT.format(item2.probability)).append(" | ").append(NUMBER_FORMAT.format(item2.expectedValue)).append(" | ").append(attrStr).append(" |\n");
                    }
                    List<LootItem> itemsWithConditions = pool2.lootItems.stream().filter(item -> item != null && !item.conditions.isEmpty()).toList();
                    if (!itemsWithConditions.isEmpty()) {
                        markdown.append("\n**\u7269\u54c1\u6761\u4ef6\u8bf4\u660e:**\n");
                        for (LootItem item3 : itemsWithConditions) {
                            markdown.append("- ").append(item3.displayName).append(":\n");
                            for (String cond : item3.conditions) {
                                markdown.append("  - ").append(cond).append("\n");
                            }
                        }
                    }
                    markdown.append("\n");
                }
                double tableTotalExpectedValue = analysis2.getLootPools().stream().filter(Objects::nonNull).mapToDouble(pool -> pool.totalExpectedValue).sum();
                markdown.append("**\u6218\u5229\u54c1\u8868\u603b\u671f\u671b\u503c:** ").append(NUMBER_FORMAT.format(tableTotalExpectedValue)).append("\n\n");
            }
        }
        return markdown.toString();
    }

    private static String generateSummaryMarkdown(Map<String, LootTableAnalysis> allLootTables, Map<String, List<String>> lootTablesByNamespace, Map<String, List<LootTableAnalysis>> lootTablesByType) {
        if (allLootTables == null || allLootTables.isEmpty()) {
            return "# \u6218\u5229\u54c1\u8868\u5206\u6790\u6c47\u603b\u62a5\u544a\n\n\u6ca1\u6709\u53ef\u5206\u6790\u7684\u6218\u5229\u54c1\u8868\u6570\u636e\u3002";
        }
        StringBuilder markdown = new StringBuilder();
        markdown.append("# Minecraft \u6218\u5229\u54c1\u8868\u5206\u6790\u6c47\u603b\u62a5\u544a\n\n");
        markdown.append("\u751f\u6210\u65f6\u95f4: ").append(DATE_FORMATTER.get().format(new Date())).append("\n\n");
        markdown.append("## \u6458\u8981\n");
        markdown.append("- \u5206\u6790\u7684\u6218\u5229\u54c1\u8868\u603b\u6570: ").append(allLootTables.size()).append("\n");
        markdown.append("- \u6d89\u53ca\u7684\u547d\u540d\u7a7a\u95f4\u6570\u91cf: ").append(lootTablesByNamespace.size()).append("\n");
        markdown.append("- \u6218\u5229\u54c1\u8868\u7c7b\u578b\u6570\u91cf: ").append(lootTablesByType.size()).append("\n\n");
        markdown.append("### \u7c7b\u578b\u5206\u5e03\n");
        for (Map.Entry<String, List<LootTableAnalysis>> entry : lootTablesByType.entrySet()) {
            markdown.append("- ").append(entry.getKey()).append(": ").append(entry.getValue().size()).append(" \u4e2a\u6218\u5229\u54c1\u8868\n");
        }
        markdown.append("\n### \u547d\u540d\u7a7a\u95f4\u5206\u5e03\n");
        for (Map.Entry<String, List<Object>> entry : lootTablesByNamespace.entrySet()) {
            markdown.append("- ").append(entry.getKey()).append(": ").append(entry.getValue().size()).append(" \u4e2a\u6218\u5229\u54c1\u8868\n");
        }
        long errorCount = allLootTables.values().stream().filter(a2 -> a2.getError() != null).count();
        markdown.append("\n- \u5206\u6790\u5931\u8d25\u7684\u6218\u5229\u54c1\u8868: ").append(errorCount).append("\n\n");
        markdown.append("## \u7c7b\u578b\u62a5\u544a\u5217\u8868\n");
        for (Map.Entry<String, List<LootTableAnalysis>> entry : lootTablesByType.entrySet()) {
            String type = entry.getKey();
            String safeTypeName = PATTERN.matcher(type).replaceAll("_");
            markdown.append("- [").append(type).append("](").append("[").append(safeTypeName).append("].md) - ").append(entry.getValue().size()).append(" \u4e2a\u6218\u5229\u54c1\u8868\n");
        }
        markdown.append("\n## \u6218\u5229\u54c1\u8868\u6c47\u603b\u6bd4\u8f83\n\n");
        markdown.append("| \u7c7b\u578b | \u547d\u540d\u7a7a\u95f4 | \u6218\u5229\u54c1\u8868 | \u5956\u52b1\u6c60\u6570\u91cf | \u603b\u671f\u671b\u503c | \u72b6\u6001 |\n");
        markdown.append("|------|----------|----------|-----------|----------|------|\n");
        for (Map.Entry<String, Object> entry : allLootTables.entrySet()) {
            LootTableAnalysis analysis = (LootTableAnalysis)entry.getValue();
            if (analysis == null) continue;
            ResourceLocation loc = new ResourceLocation(entry.getKey());
            String namespace = loc.m_135827_();
            String status = analysis.getError() != null ? "\u9519\u8bef" : "\u6b63\u5e38";
            double tableTotalExpectedValue = analysis.getLootPools().stream().filter(Objects::nonNull).mapToDouble(pool -> pool.totalExpectedValue).sum();
            markdown.append("| ").append(analysis.getType()).append(" | ").append(namespace).append(" | `").append(loc.m_135815_()).append("` | ").append(analysis.getLootPools().size()).append(" | ").append(analysis.getError() != null ? "-" : NUMBER_FORMAT.format(tableTotalExpectedValue)).append(" | ").append(status).append(" |\n");
        }
        return markdown.toString();
    }

    private static class LootTableAnalysis {
        private final String name;
        private String type;
        private List<String> globalConditions = new ArrayList<String>();
        private List<LootPool> lootPools = new ArrayList<LootPool>();
        private String error;

        LootTableAnalysis(String name) {
            this.name = name;
            this.type = "\u672a\u77e5";
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public List<String> getGlobalConditions() {
            return this.globalConditions;
        }

        @Generated
        public List<LootPool> getLootPools() {
            return this.lootPools;
        }

        @Generated
        public String getError() {
            return this.error;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setGlobalConditions(List<String> globalConditions) {
            this.globalConditions = globalConditions;
        }

        @Generated
        public void setLootPools(List<LootPool> lootPools) {
            this.lootPools = lootPools;
        }

        @Generated
        public void setError(String error) {
            this.error = error;
        }
    }

    private static class LootPool {
        int poolIndex;
        String name;
        ValueInfo rolls;
        ValueInfo bonusRolls;
        List<LootItem> lootItems = new ArrayList<LootItem>();
        List<String> conditions = new ArrayList<String>();
        List<JsonObject> functions = new ArrayList<JsonObject>();
        double totalWeight;
        double totalRollsAverage;
        double totalExpectedValue;

        private LootPool() {
        }
    }

    private static class ValueInfo {
        double average;
        String detail;

        private ValueInfo() {
        }
    }

    private static class LootItem {
        String type;
        String itemId;
        String displayName;
        double count = 1.0;
        String countDetail;
        String countOperation;
        double weight = 1.0;
        double quality = 0.0;
        double probability = 0.0;
        double expectedValue = 0.0;
        List<String> conditions = new ArrayList<String>();
        List<String> functions = new ArrayList<String>();
        List<String> otherFunctions = new ArrayList<String>();
        double conditionFactor = 1.0;
        boolean enchanted = false;
        boolean enchantWithLevels = false;
        boolean treasureEnchant = false;
        boolean smelted = false;
        boolean hasNbt = false;
        boolean copyNbt = false;
        boolean lootingAffected = false;
        boolean hasDamage = false;
        boolean hasPotion = false;
        boolean copyName = false;
        boolean limitCount = false;
        boolean hasAttributes = false;
        boolean hasBookContents = false;
        boolean hasLore = false;
        boolean hasCustomName = false;
        boolean explosionDecay = false;
        boolean hasPlayerHeadData = false;
        boolean isEntityEquipment = false;
        double lootingCount = 0.0;
        int lootingLimit = Integer.MAX_VALUE;
        String enchantments;
        String potionType;
        double damage;

        private LootItem() {
        }
    }
}

