/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.report;

import com.gtocore.data.recipe.builder.research.ExResearchManager;
import com.gtolib.GTOCore;
import com.gtolib.utils.RLUtils;
import com.gtolib.utils.RegistriesUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class DataCrystalReport {
    public static void grtDataCrystalReport() {
        ExResearchManager.DataCrystal dataCrystal;
        int serial;
        StringBuilder report = new StringBuilder("# ***\u6570\u636e\u6676\u7247(\u626b\u63cf)-\u7edf\u8ba1***\n  ");
        report.append("|   \u626b\u63cf ID  | \u6570\u636e\u7b49\u7ea7 | \u4ecb\u8d28\u7b49\u7ea7 |    \u626b\u63cf\u7269    |   \u6570\u91cf   |\n  ");
        report.append("|-----------|--------|---------|-------------|---------|\n  ");
        for (Int2ObjectMap.Entry entry : ExResearchManager.scanningMap.int2ObjectEntrySet()) {
            String scanningThing;
            serial = entry.getIntKey();
            dataCrystal = (ExResearchManager.DataCrystal)entry.getValue();
            String scanningId = dataCrystal.data();
            String[] parts = scanningId.split("-", 3);
            String countPart = parts[0];
            int count = Integer.parseInt(countPart.substring(0, countPart.length() - 1));
            String state = countPart.substring(countPart.length() - 1);
            if (state.equals("i")) {
                Item item = RegistriesUtils.getItem((String)parts[1], (String)parts[2]);
                ItemStack stack = new ItemStack((ItemLike)item, 1);
                scanningThing = "item  - " + stack.m_41786_().getString();
                report.append(String.format("|0x%08X|%d|%d|%s|%d|\n  ", serial, dataCrystal.tier(), dataCrystal.crystal(), scanningThing, count));
                continue;
            }
            if (!state.equals("f")) continue;
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(RLUtils.fromNamespaceAndPath((String)parts[1], (String)parts[2]));
            String fluidState = parts[2].contains("gas") ? "\u6c14\u6001 " : (parts[2].contains("liquid") ? "\u6db2\u6001 " : (parts[2].contains("molten") ? "\u7194\u878d " : (parts[2].contains("plasma") ? "\u7b49\u79bb\u5b50\u6001 " : "")));
            scanningThing = "fluid - " + fluidState + I18n.m_118938_((String)fluid.getFluidType().getDescriptionId(), (Object[])new Object[0]);
            report.append(String.format("|0x%08X|%d|%d|%s|%d|\n  ", serial, dataCrystal.tier(), dataCrystal.crystal(), scanningThing, count));
        }
        report.append("\n\n\n\n  ");
        report.append("# ***\u6570\u636e\u6676\u7247(\u7814\u7a76)-\u7edf\u8ba1***\n  ");
        report.append("|   \u7814\u7a76 ID  | \u6570\u636e\u7b49\u7ea7 | \u4ecb\u8d28\u7b49\u7ea7 |    \u7814\u7a76\u540d    |\n  ");
        report.append("|-----------|--------|---------|-------------|\n  ");
        for (Int2ObjectMap.Entry entry : ExResearchManager.analyzeMap.int2ObjectEntrySet()) {
            serial = entry.getIntKey();
            dataCrystal = (ExResearchManager.DataCrystal)entry.getValue();
            String analyzeId = "gtocore.data." + dataCrystal.data();
            report.append(String.format("|0x%08X|%d|%d|%s|\n  ", serial, dataCrystal.tier(), dataCrystal.crystal(), I18n.m_118938_((String)analyzeId, (Object[])new Object[0])));
        }
        try {
            String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            Path logDir = Paths.get("logs", "report");
            if (!Files.exists(logDir, new LinkOption[0])) {
                Files.createDirectories(logDir, new FileAttribute[0]);
            }
            Path reportPath1 = logDir.resolve("Data_Crystal_report_" + timestamp + ".md");
            try (BufferedWriter writer = Files.newBufferedWriter(reportPath1, new OpenOption[0]);){
                writer.write(report.toString());
            }
            GTOCore.LOGGER.info("\u6570\u636e\u6676\u7247(\u626b\u63cf/\u7814\u7a76)\u7edf\u8ba1\u62a5\u544a\u5df2\u751f\u6210:run\\logs\\report\\{}", (Object)reportPath1);
        }
        catch (Exception e) {
            GTOCore.LOGGER.error("\u751f\u6210\u6570\u636e\u6676\u7247(\u626b\u63cf/\u7814\u7a76)\u7edf\u8ba1\u62a5\u544a\u5931\u8d25", (Throwable)e);
        }
    }
}

