/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.misc;

import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class AnimalsRevengeAttackGoal
extends Goal {
    private final PathfinderMob mob;
    private final double speed;
    private final double attackReach;
    private final int attackCooldown;
    private final float damage;
    private int ticksUntilNextAttack;

    public AnimalsRevengeAttackGoal(PathfinderMob mob, double speed, double attackReach, int attackCooldownTicks, float damage) {
        this.mob = mob;
        this.speed = speed;
        this.attackReach = attackReach;
        this.attackCooldown = Math.max(5, attackCooldownTicks);
        this.damage = Math.max(0.5f, damage);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        return target != null && target.m_6084_();
    }

    public boolean m_8045_() {
        LivingEntity target = this.mob.m_5448_();
        return target != null && target.m_6084_();
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        this.mob.m_21573_().m_5624_((Entity)target, this.speed);
        double distance = this.mob.m_20280_((Entity)target);
        double reach = Math.pow(this.attackReach + (double)this.mob.m_20205_() * 0.5 + (double)target.m_20205_() * 0.5, 2.0);
        if (this.ticksUntilNextAttack > 0) {
            --this.ticksUntilNextAttack;
        }
        if (distance <= reach && this.ticksUntilNextAttack <= 0) {
            this.performAttack(target);
            this.ticksUntilNextAttack = this.attackCooldown;
        }
    }

    private void performAttack(LivingEntity target) {
        PathfinderMob self = this.mob;
        Level level = self.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.mob.m_6674_(this.mob.m_7655_());
        target.m_6469_(serverLevel.m_269111_().m_269333_((LivingEntity)this.mob), this.damage);
    }
}

