/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.util.bin.format.swift;

import java.util.List;

import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;

/**
 * Implemented by all Swift type metadata structures
 */
public abstract class SwiftTypeMetadataStructure implements StructConverter {

	public static final String CATEGORY = "/SwiftTypeMetadata";
	public static final CategoryPath CATEGORY_PATH = new CategoryPath(CATEGORY);
	
	private long base;

	/**
	 * Creates a new {@link SwiftTypeMetadataStructure}
	 * 
	 * @param base The base "address" of this {@link SwiftTypeMetadataStructure}
	 */
	public SwiftTypeMetadataStructure(long base) {
		this.base = base;
	}

	/**
	 * {@return the base "address" of this {@link SwiftTypeMetadataStructure}}
	 */
	public long getBase() {
		return base;
	}

	/**
	 * {@return a {@link List} of {@link SwiftTypeMetadataStructure structures} that trail this 
	 * {@link SwiftTypeMetadataStructure structure}}
	 */
	public List<SwiftTypeMetadataStructure> getTrailingObjects() {
		return List.of();
	}

	/**
	 * {@return the name of the {@link SwiftTypeMetadataStructure}}
	 */
	public abstract String getStructureName();

	/**
	 * {@return a short description of the {@link SwiftTypeMetadataStructure}}
	 */
	public abstract String getDescription();
}
