/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.database.symbol.DBTraceOffsetReference;
import ghidra.trace.database.symbol.DBTraceReference;
import ghidra.trace.database.symbol.DBTraceReferenceSpace;
import ghidra.trace.database.symbol.DBTraceShiftedReference;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.symbol.TraceReference;
import ghidra.trace.model.symbol.TraceReferenceManager;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.UnionAddressSetView;
import ghidra.util.database.spatial.rect.Rectangle2DDirection;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceReferenceManager
extends AbstractDBTraceSpaceBasedManager<DBTraceReferenceSpace>
implements TraceReferenceManager,
DBTraceDelegatingManager<DBTraceReferenceSpace> {
    public static final String NAME = "Reference";
    protected final DBTraceOverlaySpaceAdapter overlayAdapter;

    public DBTraceReferenceManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager, DBTraceOverlaySpaceAdapter overlayAdapter) throws VersionException, IOException {
        super(NAME, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager);
        this.overlayAdapter = overlayAdapter;
        this.loadSpaces();
    }

    @Override
    protected DBTraceReferenceSpace createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceReferenceSpace(this, this.dbh, space, ent);
    }

    @Override
    public DBTraceReferenceSpace getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceReferenceSpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    protected void doAddXRef(DBTraceReferenceSpace.DBTraceReferenceEntry entry) {
        if (!entry.toAddrMin.isMemoryAddress()) {
            return;
        }
        DBTraceReferenceSpace space = this.getReferenceSpace(entry.toAddrMin.getAddressSpace(), true);
        space.doAddXRef(entry);
    }

    protected void doDelXRef(DBTraceReferenceSpace.DBTraceReferenceEntry entry) {
        if (!entry.toAddrMin.isMemoryAddress()) {
            return;
        }
        DBTraceReferenceSpace space = this.getReferenceSpace(entry.toAddrMin.getAddressSpace(), false);
        assert (space != null);
        space.doDelXRef(entry);
    }

    protected void doSetXRefLifespan(DBTraceReferenceSpace.DBTraceReferenceEntry entry) {
        if (!entry.toAddrMin.isMemoryAddress()) {
            return;
        }
        DBTraceReferenceSpace space = this.getReferenceSpace(entry.toAddrMin.getAddressSpace(), false);
        assert (space != null);
        space.doSetXRefLifespan(entry);
    }

    public DBTraceReference assertIsMine(Reference ref) {
        if (!(ref instanceof DBTraceReference)) {
            throw new IllegalArgumentException("Given reference is not in this trace");
        }
        DBTraceReference dbRef = (DBTraceReference)ref;
        if (dbRef.ent.space.manager != this) {
            throw new IllegalArgumentException("Given reference is not in this trace");
        }
        return dbRef;
    }

    @Override
    public DBTraceReferenceSpace getReferenceSpace(AddressSpace space, boolean createIfAbsent) {
        return this.getForSpace(space, createIfAbsent);
    }

    @Override
    public DBTraceReferenceSpace getReferenceRegisterSpace(TraceThread thread, boolean createIfAbsent) {
        return (DBTraceReferenceSpace)this.getForRegisterSpace(thread, 0, createIfAbsent);
    }

    @Override
    public DBTraceReferenceSpace getReferenceRegisterSpace(TraceStackFrame frame, boolean createIfAbsent) {
        return (DBTraceReferenceSpace)this.getForRegisterSpace(frame, createIfAbsent);
    }

    @Override
    public DBTraceReference addReference(TraceReference reference) {
        return (DBTraceReference)this.delegateWrite(reference.getFromAddress().getAddressSpace(), s -> s.addReference(reference));
    }

    @Override
    public DBTraceReference addReference(Lifespan lifespan, Reference reference) {
        return (DBTraceReference)this.delegateWrite(reference.getFromAddress().getAddressSpace(), s -> s.addReference(lifespan, reference));
    }

    @Override
    public DBTraceReference addMemoryReference(Lifespan lifespan, Address fromAddress, AddressRange toRange, RefType refType, SourceType source, int operandIndex) {
        return (DBTraceReference)this.delegateWrite(fromAddress.getAddressSpace(), s -> s.addMemoryReference(lifespan, fromAddress, toRange, refType, source, operandIndex));
    }

    @Override
    public DBTraceOffsetReference addOffsetReference(Lifespan lifespan, Address fromAddress, Address toAddress, boolean toAddrIsBase, long offset, RefType refType, SourceType source, int operandIndex) {
        return (DBTraceOffsetReference)this.delegateWrite(fromAddress.getAddressSpace(), s -> s.addOffsetReference(lifespan, fromAddress, toAddress, toAddrIsBase, offset, refType, source, operandIndex));
    }

    @Override
    public DBTraceShiftedReference addShiftedReference(Lifespan lifespan, Address fromAddress, Address toAddress, int shift, RefType refType, SourceType source, int operandIndex) {
        return (DBTraceShiftedReference)this.delegateWrite(fromAddress.getAddressSpace(), s -> s.addShiftedReference(lifespan, fromAddress, toAddress, shift, refType, source, operandIndex));
    }

    @Override
    public DBTraceReference addRegisterReference(Lifespan lifespan, Address fromAddress, Register toRegister, RefType refType, SourceType source, int operandIndex) {
        return (DBTraceReference)this.delegateWrite(fromAddress.getAddressSpace(), s -> s.addRegisterReference(lifespan, fromAddress, toRegister, refType, source, operandIndex));
    }

    @Override
    public DBTraceReference addStackReference(Lifespan lifespan, Address fromAddress, int toStackOffset, RefType refType, SourceType source, int operandIndex) {
        return (DBTraceReference)this.delegateWrite(fromAddress.getAddressSpace(), s -> s.addStackReference(lifespan, fromAddress, toStackOffset, refType, source, operandIndex));
    }

    @Override
    public DBTraceReference getReference(long snap, Address fromAddress, AddressRange toRange, int operandIndex) {
        return (DBTraceReference)this.delegateRead(fromAddress.getAddressSpace(), s -> s.getReference(snap, fromAddress, toRange, operandIndex));
    }

    public Collection<? extends DBTraceReference> getReferencesFrom(long snap, Address fromAddress) {
        return (Collection)this.delegateRead(fromAddress.getAddressSpace(), s -> s.getReferencesFrom(snap, fromAddress), Collections.emptyList());
    }

    public Collection<? extends DBTraceReference> getReferencesFrom(long snap, Address fromAddress, int operandIndex) {
        return (Collection)this.delegateRead(fromAddress.getAddressSpace(), s -> s.getReferencesFrom(snap, fromAddress, operandIndex), Collections.emptyList());
    }

    public Collection<? extends DBTraceReference> getReferencesFromRange(Lifespan span, AddressRange range) {
        return (Collection)this.delegateRead(range.getAddressSpace(), s -> s.getReferencesFromRange(span, range), Collections.emptyList());
    }

    public Collection<? extends DBTraceReference> getFlowReferencesFrom(long snap, Address fromAddress) {
        return (Collection)this.delegateRead(fromAddress.getAddressSpace(), s -> s.getFlowReferencesFrom(snap, fromAddress), Collections.emptyList());
    }

    @Override
    public DBTraceReference getPrimaryReferenceFrom(long snap, Address fromAddress, int operandIndex) {
        return (DBTraceReference)this.delegateRead(fromAddress.getAddressSpace(), s -> s.getPrimaryReferenceFrom(snap, fromAddress, operandIndex));
    }

    @Override
    public void clearReferencesFrom(Lifespan span, AddressRange range) {
        this.delegateDeleteV(range.getAddressSpace(), s -> s.clearReferencesFrom(span, range));
    }

    public Collection<? extends DBTraceReference> getReferencesTo(long snap, Address toAddress) {
        return (Collection)this.delegateRead(toAddress.getAddressSpace(), s -> s.getReferencesTo(snap, toAddress), Collections.emptyList());
    }

    public Collection<? extends DBTraceReference> getReferencesToRange(Lifespan span, AddressRange range, Rectangle2DDirection order) {
        return (Collection)this.delegateRead(range.getAddressSpace(), s -> s.getReferencesToRange(span, range, order), Collections.emptyList());
    }

    @Override
    public void clearReferencesTo(Lifespan span, AddressRange range) {
        this.delegateDeleteV(range.getAddressSpace(), s -> s.clearReferencesTo(span, range));
    }

    @Override
    public AddressSetView getReferenceSources(Lifespan span) {
        return new UnionAddressSetView(this.spacesView.stream().map(s -> s.getReferenceSources(span)).toList());
    }

    @Override
    public AddressSetView getReferenceDestinations(Lifespan span) {
        return new UnionAddressSetView(this.spacesView.stream().map(s -> s.getReferenceDestinations(span)).toList());
    }

    @Override
    public int getReferenceCountFrom(long snap, Address fromAddress) {
        return this.delegateReadI(fromAddress.getAddressSpace(), s -> s.getReferenceCountFrom(snap, fromAddress), 0);
    }

    @Override
    public int getReferenceCountTo(long snap, Address toAddress) {
        return this.delegateReadI(toAddress.getAddressSpace(), s -> s.getReferenceCountTo(snap, toAddress), 0);
    }

    protected Collection<? extends DBTraceReference> getReferencesBySymbolId(long id) {
        return this.delegateCollection(this.spacesView, m -> m.getReferencesBySymbolId(id));
    }
}

