/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.var;

import ghidra.pcode.emu.jit.analysis.JitDataFlowArithmetic;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.access.AccessGen;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.gen.var.VarGen;
import ghidra.pcode.emu.jit.var.JitVarnodeVar;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.Varnode;

public interface MemoryVarGen<V extends JitVarnodeVar>
extends VarGen<V> {
    default public Varnode getVarnode(JitCodeGenerator<?> gen, V v) {
        return v.varnode();
    }

    @Override
    default public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<N> genValInit(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, V v) {
        return VarGen.genVarnodeInit(em, gen, this.getVarnode(gen, v));
    }

    @Override
    default public <THIS extends JitCompiledPassage, T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>, N extends Emitter.Next> Emitter<Emitter.Ent<N, T>> genReadToStack(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, V v, JT type, Opnd.Ext ext) {
        return VarGen.genReadValDirectToStack(em, localThis, gen, type, this.getVarnode(gen, v));
    }

    @Override
    default public <THIS extends JitCompiledPassage, N extends Emitter.Next> Opnd.OpndEm<JitType.MpIntJitType, N> genReadToOpnd(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, V v, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope) {
        return AccessGen.lookupMp(gen.getAnalysisContext().getEndian()).genReadToOpnd(em, localThis, gen, this.getVarnode(gen, v), type, ext, scope);
    }

    @Override
    default public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genReadLegToStack(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, V v, JitType.MpIntJitType type, int leg, Opnd.Ext ext) {
        Varnode vn = this.getVarnode(gen, v);
        if (vn.getSize() <= leg * 4) {
            return switch (ext) {
                default -> throw new MatchException(null, null);
                case Opnd.Ext.ZERO -> em.emit(Op::ldc__i, 0);
                case Opnd.Ext.SIGN -> {
                    Varnode v1 = switch (gen.getAnalysisContext().getEndian()) {
                        default -> throw new MatchException(null, null);
                        case Endian.BIG -> new Varnode(vn.getAddress(), 1);
                        case Endian.LITTLE -> new Varnode(vn.getAddress().add((long)(vn.getSize() - 1)), 1);
                    };
                    Varnode msbVn = v1;
                    yield em.emit(VarGen::genReadValDirectToStack, localThis, gen, JitType.IntJitType.I1, msbVn).emit(Op::ldc__i, 24).emit(Op::ishl).emit(Op::ldc__i, 31).emit(Op::ishr);
                }
            };
        }
        Varnode subVn = JitDataFlowArithmetic.subPieceVn(gen.getAnalysisContext().getEndian(), vn, leg * 4, 4);
        return VarGen.genReadValDirectToStack(em, localThis, gen, type.legTypesLE().get(leg), subVn);
    }

    @Override
    default public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TRef<int[]>>> genReadToArray(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, V v, JitType.MpIntJitType type, Opnd.Ext ext, Scope scope, int slack) {
        return AccessGen.lookupMp(gen.getAnalysisContext().getEndian()).genReadToArray(em, localThis, gen, this.getVarnode(gen, v), type, ext, scope, slack);
    }

    @Override
    default public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> genReadToBool(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, V v) {
        return AccessGen.genReadToBool(em, localThis, gen, this.getVarnode(gen, v));
    }
}

