/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.opnd;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.opnd.DoubleLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.FloatLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.IntLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.IntReadOnlyLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.LongLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;

public interface SimpleOpnd<T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>>
extends Opnd<JT> {
    public static <T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>> SimpleOpnd<T, JT> of(JT type, Local<T> local) {
        JT JT = type;
        Objects.requireNonNull(JT);
        JT JT2 = JT;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, JT2, n)) {
            case 0 -> {
                JitType.IntJitType t = (JitType.IntJitType)JT2;
                yield IntLocalOpnd.of(t, local);
            }
            case 1 -> {
                JitType.LongJitType t = (JitType.LongJitType)JT2;
                yield LongLocalOpnd.of(t, local);
            }
            case 2 -> {
                JitType.FloatJitType t = (JitType.FloatJitType)JT2;
                yield FloatLocalOpnd.of(t, local);
            }
            case 3 -> {
                JitType.DoubleJitType t = (JitType.DoubleJitType)JT2;
                yield DoubleLocalOpnd.of(t, local);
            }
            default -> throw new AssertionError();
        };
    }

    public static SimpleOpnd<Types.TInt, JitType.IntJitType> ofIntReadOnly(JitType.IntJitType type, Local<Types.TInt> local) {
        return IntReadOnlyLocalOpnd.of(type, local);
    }

    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, T>> read(Emitter<N> var1);

    default public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, T>> SimpleOpndEm<T, JT, N1> write(Emitter<N0> em, Scope scope) {
        return new SimpleOpndEm(this, this.writeDirect(em));
    }

    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, T>> Emitter<N1> writeDirect(Emitter<N0> var1);

    @Override
    default public List<? extends SimpleOpnd<?, ?>> legsLE() {
        return List.of(this);
    }

    public record SimpleOpndEm<T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>, N extends Emitter.Next>(SimpleOpnd<T, JT> opnd, Emitter<N> em) {
        public <TT extends Types.BPrim<?>, TJT extends JitType.SimpleJitType<TT, TJT>> SimpleOpndEm<TT, TJT, N> castBack(TJT to) {
            assert (to == this.opnd.type());
            return this;
        }
    }
}

