/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.opnd;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.opnd.ConstSimpleOpnd;
import ghidra.pcode.emu.jit.gen.opnd.DoubleLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

final class DoubleConstOpnd
extends Record
implements ConstSimpleOpnd<Types.TDouble, JitType.DoubleJitType> {
    private final double value;
    private final JitType.DoubleJitType type;

    DoubleConstOpnd(double value, JitType.DoubleJitType type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public String name() {
        return "const_double_%f".formatted(this.value).replace(".", "dot");
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TDouble>> read(Emitter<N> em) {
        return em.emit(Op::ldc__d, this.value);
    }

    @Override
    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TDouble>> SimpleOpnd.SimpleOpndEm<Types.TDouble, JitType.DoubleJitType, N1> write(Emitter<N0> em, Scope scope) {
        return DoubleLocalOpnd.temp(this.type(), this.tempName(), scope).write(em, scope);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DoubleConstOpnd.class, "value;type", "value", "type"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DoubleConstOpnd.class, "value;type", "value", "type"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DoubleConstOpnd.class, "value;type", "value", "type"}, this, o);
    }

    public double value() {
        return this.value;
    }

    @Override
    public JitType.DoubleJitType type() {
        return this.type;
    }
}

