/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.FieldForSpaceIndirect;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.access.IntAccessGen;
import ghidra.pcode.emu.jit.gen.access.LongAccessGen;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Methods;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.op.JitStoreOp;
import ghidra.program.model.lang.Endian;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;

public enum StoreOpGen implements OpGen<JitStoreOp>
{
    GEN;


    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<N1> genRunConvMpIntLeg(Emitter<N0> em, Local<Types.TRef<byte[]>> localArr, IntAccessGen access, int off, JitType.IntJitType type) {
        return em.emit(Op::aload, localArr).emit(Op::ldc__i, off).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, access.chooseWriteName(type.size()), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<N1> genRunConvInt(Emitter<N0> em, Local<Types.TRef<byte[]>> localArr, Endian endian, JitType.IntJitType type) {
        return em.emit(this::genRunConvMpIntLeg, localArr, IntAccessGen.forEndian(endian), 0, type);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> Emitter<N1> genRunConvLong(Emitter<N0> em, Local<Types.TRef<byte[]>> localArr, Endian endian, JitType.LongJitType type) {
        LongAccessGen access = LongAccessGen.forEndian(endian);
        return em.emit(Op::aload, localArr).emit(Op::ldc__i, 0).emit(Op::invokestatic, GenConsts.T_JIT_COMPILED_PASSAGE, access.chooseWriteName(type.size()), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::retVoid);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TFloat>> Emitter<N1> genRunConvFloat(Emitter<N0> em, Local<Types.TRef<byte[]>> localArr, Endian endian, JitType.FloatJitType type) {
        return em.emit(Opnd.FloatToInt.INSTANCE::convertStackToStack, type, JitType.IntJitType.I4, Opnd.Ext.ZERO).emit(this::genRunConvInt, localArr, endian, JitType.IntJitType.I4);
    }

    private <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TDouble>> Emitter<N1> genRunConvDouble(Emitter<N0> em, Local<Types.TRef<byte[]>> localArr, Endian endian, JitType.DoubleJitType type) {
        return em.emit(Opnd.DoubleToLong.INSTANCE::convertStackToStack, type, JitType.LongJitType.I8, Opnd.Ext.ZERO).emit(this::genRunConvLong, localArr, endian, JitType.LongJitType.I8);
    }

    private <N extends Emitter.Next> Emitter<N> genRunConvMpIntBE(Emitter<N> em, Local<Types.TRef<byte[]>> localArr, Opnd<JitType.MpIntJitType> opnd, Scope scope) {
        List legs = opnd.type().castLegsLE(opnd);
        int off = opnd.type().size();
        for (SimpleOpnd l : legs) {
            em = em.emit(l::read).emit(this::genRunConvMpIntLeg, localArr, IntAccessGen.BE, off -= ((JitType.IntJitType)l.type()).size(), (JitType.IntJitType)l.type());
        }
        return em;
    }

    private <N extends Emitter.Next> Emitter<N> genRunConvMpIntLE(Emitter<N> em, Local<Types.TRef<byte[]>> localArr, Opnd<JitType.MpIntJitType> opnd, Scope scope) {
        List legs = opnd.type().castLegsLE(opnd);
        int off = 0;
        for (SimpleOpnd l : legs) {
            em = em.emit(l::read).emit(this::genRunConvMpIntLeg, localArr, IntAccessGen.LE, off, (JitType.IntJitType)l.type());
            off += ((JitType.IntJitType)l.type()).size();
        }
        return em;
    }

    private <N extends Emitter.Next> Emitter<N> genRunConvMpInt(Emitter<N> em, Local<Types.TRef<byte[]>> localArr, Endian endian, Opnd<JitType.MpIntJitType> opnd, Scope scope) {
        return switch (endian) {
            default -> throw new MatchException(null, null);
            case Endian.BIG -> this.genRunConvMpIntBE(em, localArr, opnd, scope);
            case Endian.LITTLE -> this.genRunConvMpIntLE(em, localArr, opnd, scope);
        };
    }

    @Override
    public <THIS extends JitCompiledPassage> OpGen.OpResult genRun(Emitter<Emitter.Bot> em, Local<Types.TRef<THIS>> localThis, Local<Types.TInt> localCtxmod, Methods.RetReq<Types.TRef<JitCompiledPassage.EntryPoint>> retReq, JitCodeGenerator<THIS> gen, JitStoreOp op, JitControlFlowModel.JitBlock block, Scope scope) {
        FieldForSpaceIndirect field = gen.requestFieldForSpaceIndirect(op.space());
        Local<Types.TRef<byte[]>> localArr = scope.decl(Types.T_BYTE_ARR, "arr");
        Emitter emSpaceOffset = em.emit(field::genLoad, localThis, gen).emit(gen::genReadToStack, localThis, op.offset(), JitType.LongJitType.I8, Opnd.Ext.ZERO).emit(Op::ldc__i, op.value().size()).emit(Op::newarray, Types.T_BYTE).emit(Op::astore, localArr);
        Endian endian = gen.getAnalysisContext().getEndian();
        JitType jitType = gen.getTypeModel().typeOf(op.value());
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        Emitter emConv = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType t = (JitType.IntJitType)jitType2;
                yield emSpaceOffset.emit(gen::genReadToStack, localThis, op.value(), t, Opnd.Ext.ZERO).emit(this::genRunConvInt, localArr, endian, t);
            }
            case 1 -> {
                JitType.LongJitType t = (JitType.LongJitType)jitType2;
                yield emSpaceOffset.emit(gen::genReadToStack, localThis, op.value(), t, Opnd.Ext.ZERO).emit(this::genRunConvLong, localArr, endian, t);
            }
            case 2 -> {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                Opnd.OpndEm value = emSpaceOffset.emit(gen::genReadToOpnd, localThis, op.value(), t, Opnd.Ext.ZERO, scope);
                yield value.em().emit(this::genRunConvMpInt, localArr, endian, value.opnd(), scope);
            }
            case 3 -> {
                JitType.FloatJitType t = (JitType.FloatJitType)jitType2;
                yield emSpaceOffset.emit(gen::genReadToStack, localThis, op.value(), t, Opnd.Ext.ZERO).emit(this::genRunConvFloat, localArr, endian, t);
            }
            case 4 -> {
                JitType.DoubleJitType t = (JitType.DoubleJitType)jitType2;
                yield emSpaceOffset.emit(gen::genReadToStack, localThis, op.value(), t, Opnd.Ext.ZERO).emit(this::genRunConvDouble, localArr, endian, t);
            }
            default -> throw new AssertionError();
        };
        return new OpGen.LiveOpResult(emConv.emit(Op::aload, localArr).emit(Op::ldc__i, 0).emit(Op::ldc__i, op.value().size()).emit(Op::invokevirtual, GenConsts.T_JIT_BYTES_PCODE_EXECUTOR_STATE_SPACE, "write", GenConsts.MDESC_JIT_BYTES_PCODE_EXECUTOR_STATE_SPACE__WRITE, false).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeArg).step(Methods.Inv::takeObjRef).step(Methods.Inv::retVoid));
    }
}

